/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class LoaderGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 8834267363875256916L;
    private InterfaceLoaderGUI subs;
    private final JLabel onCameraLabel = new JLabel("ON CAMERA SENSOR");
    private final JPanel fakeSensorsPanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final String carrierName = "loader/carrier";
    private final JPanel cpsPanel = new JPanel();
    private final JPanel keysPanel = new JPanel();
    private final DigitalSwitch onCameraDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch ap2Switch = new DigitalSwitch();
    private final DigitalSwitch af0Switch = new DigitalSwitch();
    private final DigitalSwitch af1Switch = new DigitalSwitch();
    private final DigitalSwitch af3Switch = new DigitalSwitch();
    private final DigitalSwitch keyLockSwitch = new DigitalSwitch();
    private final DigitalSwitch keyEngSwitch = new DigitalSwitch();
    private final DigitalSwitch carrierRelaySwitch = new DigitalSwitch();
    private final DigitalSwitch hooksRelaySwitch = new DigitalSwitch();
    private final DigitalSwitch chainPresenceSwitch = new DigitalSwitch();
    private final DigitalSwitch defaultStatusSwitch = new DigitalSwitch();
    private final JPanel clampPanel = new JPanel();
    private final DigitalSwitch filterInLoaderSwitch = new DigitalSwitch();
    private final JLabel clampHomingLabel = new JLabel();
    private final JLabel clampStateLabel = new JLabel();
    private final JLabel clampPositionLabel = new JLabel();
    private final JLabel forceStatusLabel = new JLabel();
    private final DigitalSwitch clampControllerSwitch = new DigitalSwitch();
    private final JPanel carrierPanel = new JPanel();
    private final JLabel carrierPositionLabel = new JLabel();
    private final JLabel carrierStatusLabel = new JLabel();
    private final JProgressBar carrierPositionProgressBar = new JProgressBar(1, 0, 100);
    private final DigitalSwitch carrierControllerSwitch = new DigitalSwitch();
    private final JButton loadFilterButton = new JButton("loadFilterIntoStorageBox");
    private final JButton unloadFilterButton = new JButton("unloadFilterFromStorageBox");
    private final JButton moveFilterStoHButton = new JButton("moveFilterFromStorageToHandoff");
    private final JButton moveFilterHtoSButton = new JButton("moveFilterFromHandoffToStorage");
    private final JButton openClampAndMoveEmptyToSButton = new JButton("openClampAndMoveEmptyToStorage");
    private final JButton moveEmptyToHandCloseButton = new JButton("moveEmptyToHandoffAndClose");

    public LoaderGeneralViewPanel() {
        this.initComponents();
    }

    public LoaderGeneralViewPanel(InterfaceLoaderGUI subs) {
        this.subs = subs;
        this.initComponents();
    }

    public void setSubsystem(InterfaceLoaderGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateLoaderGeneral(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateLoaderGeneral(status));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateCarrier(StatusDataPublishedByLoaderCarrier status) {
        SwingUtilities.invokeLater(new UpdateCarrier(status));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "LOADER"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        JPanel clampControllerPanel = new JPanel();
        clampControllerPanel.setBorder(BorderFactory.createEtchedBorder());
        clampControllerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        clampControllerPanel.add((Component)new JLabel("Controller Status"), gbc);
        ++gbc.gridy;
        clampControllerPanel.add((Component)this.clampControllerSwitch, gbc);
        this.clampControllerSwitch.setSize(40);
        JPanel filterPresencePanel = new JPanel();
        filterPresencePanel.setBorder(BorderFactory.createEtchedBorder());
        filterPresencePanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        filterPresencePanel.add((Component)new JLabel("Filter Presence"), gbc);
        ++gbc.gridy;
        filterPresencePanel.add((Component)this.filterInLoaderSwitch, gbc);
        this.filterInLoaderSwitch.setSize(40);
        this.clampPanel.setBorder(BorderFactory.createTitledBorder("Loader Clamp"));
        this.clampPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        this.clampPanel.add((Component)new JLabel("Homing:"), gbc);
        ++gbc.gridx;
        gbc.anchor = 22;
        this.clampPanel.add((Component)this.clampHomingLabel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        gbc.anchor = 21;
        this.clampPanel.add((Component)clampControllerPanel, gbc);
        ++gbc.gridx;
        this.clampPanel.add((Component)filterPresencePanel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        gbc.anchor = 21;
        int y = gbc.gridy++;
        this.clampPanel.add((Component)new JLabel("Hooks Status"), gbc);
        this.clampPanel.add((Component)new JLabel("Hooks Position"), gbc);
        ++gbc.gridy;
        this.clampPanel.add((Component)new JLabel("Clamped Force Status"), gbc);
        gbc.gridy = y;
        ++gbc.gridx;
        gbc.anchor = 10;
        this.clampPanel.add((Component)this.clampStateLabel, gbc);
        ++gbc.gridy;
        gbc.anchor = 22;
        this.clampPanel.add((Component)this.clampPositionLabel, gbc);
        ++gbc.gridy;
        gbc.anchor = 10;
        this.clampPanel.add((Component)this.forceStatusLabel, gbc);
        JPanel controllerPanel = new JPanel();
        controllerPanel.setBorder(BorderFactory.createEtchedBorder());
        controllerPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        controllerPanel.add((Component)new JLabel("Controller Status"), gbc);
        ++gbc.gridy;
        controllerPanel.add((Component)this.carrierControllerSwitch, gbc);
        this.carrierControllerSwitch.setSize(50);
        this.carrierPanel.setBorder(BorderFactory.createTitledBorder("Loader Carrier"));
        this.carrierPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        this.carrierPanel.add((Component)new JLabel("Carrier Position"), gbc);
        ++gbc.gridy;
        this.carrierPanel.add((Component)new JLabel("Carrier Status"), gbc);
        ++gbc.gridy;
        int y2 = gbc.gridy;
        this.carrierPanel.add((Component)controllerPanel, gbc);
        gbc.gridy = 0;
        ++gbc.gridx;
        gbc.anchor = 22;
        this.carrierPanel.add((Component)this.carrierPositionLabel, gbc);
        ++gbc.gridy;
        this.carrierPanel.add((Component)this.carrierStatusLabel, gbc);
        gbc.gridy = y2;
        gbc.gridx = 1;
        gbc.gridheight = 2;
        gbc.anchor = 10;
        this.carrierPositionProgressBar.setBorderPainted(true);
        this.carrierPositionProgressBar.setBackground(Tools.greenColor);
        this.carrierPositionProgressBar.setStringPainted(true);
        this.carrierPanel.add((Component)this.carrierPositionProgressBar, gbc);
        this.loadFilterButton.addActionListener(evt -> this.loadFilterActionPerformed(evt));
        this.unloadFilterButton.addActionListener(evt -> this.unloadFilterActionPerformed(evt));
        this.moveFilterStoHButton.addActionListener(evt -> this.moveFilterStoHActionPerformed(evt));
        this.moveFilterHtoSButton.addActionListener(evt -> this.moveFilterHtoSActionPerformed(evt));
        this.openClampAndMoveEmptyToSButton.addActionListener(evt -> this.openClampAndMoveEmptyToStoSActionPerformed(evt));
        this.moveEmptyToHandCloseButton.addActionListener(evt -> this.moveEmptyToHandCloseActionPerformed(evt));
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.fill = 2;
        this.controlPanel.add((Component)this.loadFilterButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.unloadFilterButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.moveFilterStoHButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.moveFilterHtoSButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.openClampAndMoveEmptyToSButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.moveEmptyToHandCloseButton, gbc0);
        this.fakeSensorsPanel.setBorder(BorderFactory.createLineBorder(Color.BLUE, 6));
        this.fakeSensorsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = 2;
        this.fakeSensorsPanel.add((Component)this.onCameraLabel, gbc1);
        ++gbc1.gridx;
        this.fakeSensorsPanel.add((Component)this.onCameraDigitalSwitch, gbc1);
        this.cpsPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.cpsPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = 17;
        gbc0.insets = Tools.insets_std;
        this.cpsPanel.add((Component)new JLabel("AP2 (AC at handoff)"), gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)new JLabel("AF0 (AC latches opened)"), gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)new JLabel("AF1 (filter detected in AC)"), gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)new JLabel("AF3 (filter locked in AC)"), gbc0);
        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = 13;
        this.cpsPanel.add((Component)this.ap2Switch, gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)this.af0Switch, gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)this.af1Switch, gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)this.af3Switch, gbc0);
        this.keysPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.keysPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = 17;
        gbc0.insets = Tools.insets_std;
        this.keysPanel.add((Component)new JLabel("keyLock/lockOut"), gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)new JLabel("Engineering key"), gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)new JLabel("Carrier relay"), gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)new JLabel("Hooks relay"), gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)new JLabel("Safety belt presence"), gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)new JLabel("Default Status"), gbc0);
        gbc0.gridx = 1;
        ++gbc0.gridy;
        gbc0.gridy = 0;
        gbc0.anchor = 13;
        this.keysPanel.add((Component)this.keyLockSwitch, gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)this.keyEngSwitch, gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)this.carrierRelaySwitch, gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)this.hooksRelaySwitch, gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)this.chainPresenceSwitch, gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)this.defaultStatusSwitch, gbc0);
        gbc = new GridBagConstraints();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "LOADER General View"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        gbc.anchor = 512;
        gbc.insets = Tools.insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.fakeSensorsPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.cpsPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.keysPanel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        this.add((Component)this.clampPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.carrierPanel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        this.add((Component)this.controlPanel, gbc);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.onCameraDigitalSwitch.setColor(Color.gray);
        this.ap2Switch.setColor(Color.gray);
        this.af0Switch.setColor(Color.gray);
        this.af1Switch.setColor(Color.gray);
        this.af3Switch.setColor(Color.gray);
        this.keyLockSwitch.setColor(Color.gray);
        this.keyEngSwitch.setColor(Color.gray);
        this.carrierRelaySwitch.setColor(Color.gray);
        this.hooksRelaySwitch.setColor(Color.gray);
        this.chainPresenceSwitch.setColor(Color.gray);
        this.defaultStatusSwitch.setColor(Color.gray);
        this.clampHomingLabel.setText("TO BE DONE");
        this.clampHomingLabel.setForeground(Color.red);
        this.filterInLoaderSwitch.setColor(Color.gray);
        this.clampControllerSwitch.setColor(Color.gray);
        this.clampStateLabel.setText("UNKNOWN");
        this.clampPositionLabel.setText("0.0");
        this.forceStatusLabel.setText("UNKNOWN");
        this.carrierPositionLabel.setText("0.0");
        this.carrierStatusLabel.setText("UNKNOWN");
        this.carrierControllerSwitch.setColor(Color.gray);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    private void loadFilterActionPerformed(ActionEvent evt) {
        this.subs.loLoadFilterIntoStorageBox();
    }

    private void unloadFilterActionPerformed(ActionEvent evt) {
        this.subs.loUnloadFilterFromStorageBox();
    }

    private void moveFilterStoHActionPerformed(ActionEvent evt) {
        this.subs.loMoveFilterStoH();
    }

    private void moveFilterHtoSActionPerformed(ActionEvent evt) {
        this.subs.loMoveFilterHtoS();
    }

    private void moveEmptyToHandCloseActionPerformed(ActionEvent evt) {
        this.subs.loMoveEmptyToHandClose();
    }

    private void openClampAndMoveEmptyToStoSActionPerformed(ActionEvent evt) {
        this.subs.loOpenClampAndMoveEmptyToS();
    }

    @Override
    public String toString() {
        return "Loader General View Panel";
    }

    public static void main(String[] args) {
        LoaderGeneralViewPanel d = new LoaderGeneralViewPanel();
        JFrame frame = new JFrame("LoaderGeneralViewPanel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map configForCarrier = this.configInfo.getCurrentValuesFor("loader/carrier");
            int handoffPosition = Tools.toInt(configForCarrier, "handoffPosition");
            int storagePosition = Tools.toInt(configForCarrier, "storagePosition");
            LoaderGeneralViewPanel.this.carrierPositionProgressBar.setMinimum(-handoffPosition);
            LoaderGeneralViewPanel.this.carrierPositionProgressBar.setMaximum(-storagePosition);
            LoaderGeneralViewPanel.this.carrierPositionProgressBar.setValue(0);
        }
    }

    private class UpdateCarrier
    implements Runnable {
        private final StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier s) {
            this.s = s;
        }

        @Override
        public void run() {
            LoaderGeneralViewPanel.this.carrierPositionLabel.setText(Integer.toString(this.s.getPosition()));
            LoaderGeneralViewPanel.this.carrierPositionProgressBar.setValue(-this.s.getPosition());
            LoaderGeneralViewPanel.this.carrierPositionProgressBar.setForeground(Color.PINK);
            if (this.s.isAtStorage()) {
                LoaderGeneralViewPanel.this.carrierStatusLabel.setText("STORAGE");
            } else if (this.s.isAtEngaged()) {
                LoaderGeneralViewPanel.this.carrierStatusLabel.setText("ENGAGED");
            } else if (this.s.isAtHandoff()) {
                LoaderGeneralViewPanel.this.carrierStatusLabel.setText("HANDOFF");
            } else {
                LoaderGeneralViewPanel.this.carrierStatusLabel.setText("IN_TRAVEL");
            }
            LoaderGeneralViewPanel.this.carrierControllerSwitch.setColor(this.s.isControllerInError() ? Color.RED : Tools.greenColor);
        }
    }

    private class UpdateClamp
    implements Runnable {
        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            if (this.s.isHomingDone()) {
                LoaderGeneralViewPanel.this.clampHomingLabel.setText("DONE");
                LoaderGeneralViewPanel.this.clampHomingLabel.setForeground(Tools.greenColor);
            } else {
                LoaderGeneralViewPanel.this.clampHomingLabel.setText("NOT DONE");
                LoaderGeneralViewPanel.this.clampHomingLabel.setForeground(Color.red);
            }
            Color clampStateColor = this.s.getClampState().getColor();
            LoaderGeneralViewPanel.this.clampStateLabel.setText(this.s.getClampState().getText());
            LoaderGeneralViewPanel.this.clampStateLabel.setForeground(clampStateColor);
            LoaderGeneralViewPanel.this.forceStatusLabel.setText(this.s.getForceStatus().toString());
            LoaderGeneralViewPanel.this.clampPositionLabel.setText(Integer.toString(this.s.getPosition()));
            LoaderGeneralViewPanel.this.clampControllerSwitch.setColor(this.s.isControllerInError() ? Color.RED : Tools.greenColor);
        }
    }

    class UpdateLoaderGeneral
    implements Runnable {
        private final StatusDataPublishedByLoader s;

        UpdateLoaderGeneral(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            LoaderGeneralViewPanel.this.onCameraDigitalSwitch.updateColor(this.s.isLoaderOnCameraSensorsInError(), this.s.isLoaderOnCameraSensorValue());
            LoaderGeneralViewPanel.this.af0Switch.updateColor(this.s.isAf0InError(), this.s.isAf0());
            LoaderGeneralViewPanel.this.af1Switch.updateColor(this.s.isAf1InError(), this.s.isAf1());
            LoaderGeneralViewPanel.this.af3Switch.updateColor(this.s.isAf3InError(), this.s.isAf3());
            LoaderGeneralViewPanel.this.ap2Switch.updateColor(this.s.isAp2InError(), this.s.isAp2());
            LoaderGeneralViewPanel.this.keyEngSwitch.updateColor(this.s.isKeyEngInError(), this.s.isKeyEng());
            LoaderGeneralViewPanel.this.keyLockSwitch.updateColor(this.s.isKeyLockInError(), this.s.isKeyLock());
            LoaderGeneralViewPanel.this.carrierRelaySwitch.setColor(this.s.isCarrierRelayStatus() ? Tools.greenColor : Color.gray);
            LoaderGeneralViewPanel.this.hooksRelaySwitch.setColor(this.s.isHooksRelayStatus() ? Tools.greenColor : Color.gray);
            LoaderGeneralViewPanel.this.chainPresenceSwitch.setColor(this.s.isLoaderChainPresenceSensor() ? Tools.greenColor : Color.gray);
            LoaderGeneralViewPanel.this.defaultStatusSwitch.setColor(this.s.isLoaderDefaultStatus() ? Tools.greenColor : Color.gray);
            LoaderGeneralViewPanel.this.filterInLoaderSwitch.setColor(this.s.getFilterPresenceSensorValue() ? Tools.greenColor : Color.GRAY);
        }
    }
}

