/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class BrakesPanel
extends JPanel {
    private JTable brakesTable;
    private JScrollPane jScrollPane;
    private final DecimalFormat formatter = new DecimalFormat("#####0.0");

    public BrakesPanel() {
        this.initComponents();
    }

    protected void update(StatusDataPublishedByCarousel s) {
        SwingUtilities.invokeLater(new Update(s));
    }

    protected void updateController(StatusDataPublishedByEPOSController s) {
        SwingUtilities.invokeLater(new UpdateController(s));
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.brakesTable = new JTable();
        this.brakesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"TYPE", "BAY", "STATE", "SENSOR VALUE", "TEMPERATURE"}){
            private static final long serialVersionUID = -6158042587124966771L;
            private final Class[] types;
            private final boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        DefaultTableModel brakesTableModel = (DefaultTableModel)this.brakesTable.getModel();
        Object[] row1 = new Object[]{"Motor", "D", "UNKNOWN", 0, 0};
        brakesTableModel.addRow(row1);
        Object[] row2 = new Object[]{"Brake", "I", "UNKNOWN", 0, 0};
        brakesTableModel.addRow(row2);
        Object[] row3 = new Object[]{"Brake", "N", "UNKNOWN", 0, 0};
        brakesTableModel.addRow(row3);
        Object[] row4 = new Object[]{"Brake", "X", "UNKNOWN", 0, 0};
        brakesTableModel.addRow(row4);
        brakesTableModel.fireTableDataChanged();
        int rowNB = this.brakesTable.getModel().getRowCount();
        for (int i = 0; i < rowNB; ++i) {
            TableColumn column = this.brakesTable.getColumnModel().getColumn(i);
            if (i == 2) {
                column.setPreferredWidth(130);
                continue;
            }
            if (i != 3 && i != 4) continue;
            column.setPreferredWidth(60);
        }
        this.brakesTable.setAutoResizeMode(4);
        this.jScrollPane.setPreferredSize(new Dimension(500, 100));
        this.jScrollPane.setViewportView(this.brakesTable);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Tools.NICE_PINK), "Carousel Brakes"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.jScrollPane, gbc);
    }

    public static void main(String[] argv) {
        BrakesPanel p = new BrakesPanel();
        JFrame frame = new JFrame("Brakes Panel");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        public UpdateController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            DefaultTableModel filterTableModel = (DefaultTableModel)BrakesPanel.this.brakesTable.getModel();
            BrakesPanel.this.brakesTable.setValueAt(this.s.getState().toString(), 0, 2);
            filterTableModel.fireTableDataChanged();
        }
    }

    public class Update
    implements Runnable {
        private final StatusDataPublishedByCarousel s;

        public Update(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            DefaultTableModel filterTableModel = (DefaultTableModel)BrakesPanel.this.brakesTable.getModel();
            BrakesPanel.this.brakesTable.setValueAt(this.s.getCurrent(), 0, 3);
            BrakesPanel.this.brakesTable.setValueAt(BrakesPanel.this.formatter.format(this.s.getTemperature1()), 0, 4);
            BrakesPanel.this.brakesTable.setValueAt(this.s.getBrakeState1().toString(), 1, 2);
            BrakesPanel.this.brakesTable.setValueAt(this.s.getSensor1(), 1, 3);
            BrakesPanel.this.brakesTable.setValueAt(BrakesPanel.this.formatter.format(this.s.getTemperature2()), 1, 4);
            BrakesPanel.this.brakesTable.setValueAt(this.s.getBrakeState2().toString(), 2, 2);
            BrakesPanel.this.brakesTable.setValueAt(this.s.getSensor2(), 2, 3);
            BrakesPanel.this.brakesTable.setValueAt(BrakesPanel.this.formatter.format(this.s.getTemperature3()), 2, 4);
            BrakesPanel.this.brakesTable.setValueAt(this.s.getBrakeState3().toString(), 3, 2);
            BrakesPanel.this.brakesTable.setValueAt(this.s.getSensor3(), 3, 3);
            BrakesPanel.this.brakesTable.setValueAt(BrakesPanel.this.formatter.format(this.s.getTemperature4()), 3, 4);
            filterTableModel.fireTableDataChanged();
        }
    }
}

