
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import static java.awt.image.ImageObserver.WIDTH;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import static org.lsst.ccs.subsystems.fcs.FCSCst.UNKNOWN;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * A panel to display state of controller.
 *
 * @author virieux
 */
public class ControllerStatePanel extends JPanel {

    private final DigitalSwitch controllerSwitch = new DigitalSwitch();
    private final JLabel nameLabel = new JLabel();
    private final JLabel eposStateLabel = new JLabel();
    private final JLabel modeLabel = new JLabel();
    private final JLabel currentjLabel = new JLabel("0");
    private final JLabel positionjLabel = new JLabel("0");
    private final JLabel velocityjLabel = new JLabel("0");


    public ControllerStatePanel() {
        initComponents();
    }

    public void update(String controllerName, StatusDataPublishedByEPOSController s) {
        FCSLOG.debug("ControllerStatePanel updating from controller data of " + controllerName);
        SwingUtilities.invokeLater(new ControllerStatePanel.UpdateController(controllerName, s));
    }

    /**
     * A Runnable to update controller panel with data published by a
     * controller.
     */
    public class UpdateController implements Runnable {

        private final StatusDataPublishedByEPOSController s;
        private final String controllerName;

        private UpdateController(String controllerName, StatusDataPublishedByEPOSController s) {
            this.s = s;
            this.controllerName = controllerName;
        }

        @Override
        public void run() {
            nameLabel.setText(controllerName);
            if (s.isBooted() && s.getState() != null) {
                eposStateLabel.setText(s.getState().name());
                controllerSwitch.setColor(s.getState().getColor());
            } else if (!s.isBooted()) {
                eposStateLabel.setText("not booted");
                controllerSwitch.setColor(Color.RED);
            }
            
            if (s.isBooted()) {
                positionjLabel.setText(Integer.toString(s.getPosition()));
                currentjLabel.setText(Integer.toString(s.getCurrent()));
                velocityjLabel.setText(Integer.toString(s.getVelocity()));
            }
            modeLabel.setText(s.getMode() == null ? UNKNOWN : s.getMode().toString());
        }
    }
    //s.isControllerInFault() ? Color.RED : greenColor

    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        setDefaultValues();
        nameLabel.setFont(BIG_FONT);

        setBorder(BorderFactory.createLineBorder(Color.MAGENTA, WIDTH + 5));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(nameLabel, gbc);
        gbc.gridy++;
        controllerSwitch.setSize(40);
        add(controllerSwitch, gbc);
        gbc.gridy++;
        add(eposStateLabel, gbc);
        gbc.gridy++;
        add(modeLabel, gbc);

        /* current, position, velocity */
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridy = 4;
        add(new JLabel("<HTML>Current : <BR>(in mA) </HTML>"), gbc);
        gbc.gridy++;
        add(new JLabel("<HTML>Position : <BR>(in um)</HTML>"), gbc);
        gbc.gridy++;
        add(new JLabel("<HTML>Velocity : <BR>(in rpm) </HTML>"), gbc);
        gbc.gridx++;
        gbc.gridy = 4;
        gbc.anchor = GridBagConstraints.EAST;
        add(currentjLabel, gbc);
        gbc.gridy++;
        add(positionjLabel, gbc);
        gbc.gridy++;
        add(velocityjLabel, gbc);
    }

    private void setDefaultValues() {
        nameLabel.setText("UNKNOWN CTL NAME");
        controllerSwitch.setColor(Color.gray);
        eposStateLabel.setText(UNKNOWN_STATE);
        modeLabel.setText(UNKNOWN);
        positionjLabel.setText("0");
        currentjLabel.setText("0");
        velocityjLabel.setText("0");
    }

    /**
     * Reset Panel to default values when subsystem is shutdown.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    @Override
    public String toString() {
        return "Controller State View";
    }

    /**
     * Just to test the Panel.
     *
     * @param argv
     */
    public static void main(String[] argv) {

        ControllerStatePanel d = new ControllerStatePanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
