/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class PlutoGatewayPanel
extends JPanel {
    private static final long serialVersionUID = -7222037685600465352L;
    private final String gatewayName;
    private final String publishedDataKey;
    private final CanOpenDevicePanel generalInfoPanel;
    private final JPanel valuesPanel;
    JScrollPane jScrollPane = new JScrollPane();
    JTable valuesTable = new JTable();

    public PlutoGatewayPanel(String gatewayName) {
        this.gatewayName = gatewayName;
        this.generalInfoPanel = new CanOpenDevicePanel(gatewayName);
        this.valuesPanel = new JPanel();
        int ind = gatewayName.lastIndexOf("/");
        this.publishedDataKey = ind >= 0 ? gatewayName.substring(ind + 1) : gatewayName;
        this.initComponents();
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        this.generalInfoPanel.initializeGui(configInfo);
        DefaultTableModel valuesTableModel = (DefaultTableModel)this.valuesTable.getModel();
        for (int i = 0; i < 16; ++i) {
            Object[] tab = new Object[]{i, 0, 0};
            valuesTableModel.addRow(tab);
        }
        valuesTableModel.fireTableDataChanged();
    }

    public void updatePlutoGateway(String deviceToUpdateName, StatusDataPublishedByPlutoGateway status) {
        if (this.publishedDataKey.equals(deviceToUpdateName)) {
            this.generalInfoPanel.updateCanOpenDevice(deviceToUpdateName, status);
            SwingUtilities.invokeLater(new UpdatePlutoGateway(status));
        }
    }

    private void initComponents() {
        this.valuesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"ByteNumero", "Decimal Value", "Binaire Value"}){
            private static final long serialVersionUID = 1L;
            private final Class[] types;
            private final boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Integer.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        for (int i = 0; i < 3; ++i) {
            TableColumn column = this.valuesTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(25);
            }
            if (i != 2) continue;
            column.setPreferredWidth(150);
        }
        this.jScrollPane.setViewportView(this.valuesTable);
        this.valuesPanel.setBorder(BorderFactory.createLineBorder(Tools.NICE_PINK));
        this.valuesPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.anchor = 18;
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        this.valuesPanel.add((Component)this.jScrollPane, gbc0);
        this.setBorder(BorderFactory.createLineBorder(Color.GREEN));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.generalInfoPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.valuesPanel, gbc);
    }

    public void resetPanel() {
        this.generalInfoPanel.resetPanel();
        DefaultTableModel valuesTableModel = (DefaultTableModel)this.valuesTable.getModel();
        for (int i = 15; i >= 0; --i) {
            valuesTableModel.removeRow(i);
            valuesTableModel.fireTableRowsDeleted(i, i);
        }
    }

    @Override
    public String toString() {
        if (this.gatewayName == null) {
            return "plutoGateway";
        }
        int ind = this.gatewayName.lastIndexOf("/");
        return ind >= 0 ? this.gatewayName.substring(ind + 1) : this.gatewayName;
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("Pluto Gateway Panel");
        PlutoGatewayPanel p = new PlutoGatewayPanel("my_plutoGateway");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdatePlutoGateway
    implements Runnable {
        private StatusDataPublishedByPlutoGateway s;

        public UpdatePlutoGateway(StatusDataPublishedByPlutoGateway status) {
            this.s = status;
        }

        @Override
        public void run() {
            GatherPanel.FCSLOG.fine((Object)(" UpdatePlutoGateway for gateway=" + PlutoGatewayPanel.this.gatewayName));
            PlutoGatewayPanel.this.generalInfoPanel.updateCanOpenDevice(PlutoGatewayPanel.this.gatewayName, this.s);
            DefaultTableModel valuesTableModel = (DefaultTableModel)PlutoGatewayPanel.this.valuesTable.getModel();
            int rowNB = this.s.getIntValues().length;
            for (int i = 0; i < rowNB; ++i) {
                int value = this.s.getIntValues()[i];
                String bin = String.format("%016d", Long.parseLong(Integer.toBinaryString(value)));
                valuesTableModel.setValueAt(value, i, 1);
                valuesTableModel.setValueAt("  0b" + bin, i, 2);
            }
            valuesTableModel.fireTableDataChanged();
        }
    }
}

