
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 *
 * @author turri
 */
public class FilterPanel extends JPanel {

    private static final long serialVersionUID = 1771035528248774462L;

    private int size = 200;
    private final Color filterOutColor = new Color(153, 153, 153);
    private final Color filterInColor = new Color(0, 165, 0);
    private Color filterColor = filterOutColor;
    private String filterString = "";

    /**
     * Creates new form DigitalSwitch
     */
    public FilterPanel() {
        initComponents();
        setSize(size);
    }

    public final void setSize(int size) {
        this.size = size;
        super.setPreferredSize(new Dimension(size, size));
    }

    @Override
    public void setBackground(Color bg) {
        setColor(bg);
    }

    public void setIsFilterInHouse(boolean isFilterIn, String filterName) {
        if (isFilterIn) {
            //filterString = "Filter In";
            filterString = filterName;
            setColor(filterInColor);
        } else {
            filterString = "No Filter";
            setColor(filterOutColor);
        }
    }

    public void setColor(Color c) {
        this.filterColor = c;
        repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);

        float width = size;
        float height = size;
        float actualWidth = Math.min(width, height);

        double border = 1;

        // Draw the outline
        Shape outerCircle = new Arc2D.Double(border, border, actualWidth - 2 * border, actualWidth - 2 * border, 0, 360, Arc2D.CHORD);
        g2.setStroke(new BasicStroke(1));
        g2.setColor(Color.gray);
        g2.fill(outerCircle);
        g2.setColor(Color.black);
        g2.draw(outerCircle);

//        actualWidth = actualWidth - 20;
        BigDecimal aw = BigDecimal.valueOf(actualWidth).add(BigDecimal.valueOf(-20));
        Arc2D filterCircle = new Arc2D.Double(border + 10, border + 10,
                aw.floatValue() - 2 * border,
                aw.floatValue() - 2 * border, 0, 360, Arc2D.CHORD);
        g2.setStroke(new BasicStroke(1));
        g2.setColor(filterColor);
        g2.fill(filterCircle);
        g2.setColor(Color.black);
        g2.draw(filterCircle);

        String msg = filterString;
        if (!"".equals(msg)) {
            g2.setFont(new Font("system", Font.BOLD, 20));
            Rectangle2D bounds = g2.getFontMetrics().getStringBounds(msg, g2);
            g2.drawString(msg, (int) ((getWidth() - bounds.getWidth()) / 2), (int) (getHeight() + bounds.getHeight() / 2) / 2);
        }

    }

    public static void main(String[] argv) {

        FilterPanel d = new FilterPanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    private void initComponents() {

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );
    }

}
