/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;

public class MonitorTableCellRenderer
extends DefaultTableCellRenderer {
    private boolean ensureWidth = false;
    private boolean ensureHeight = false;
    private int addedSpace = 0;
    private String additionalSpace;

    public void setEnsureWidth(boolean ensureWidth) {
        this.ensureWidth = ensureWidth;
    }

    public void setEnsureHeight(boolean ensureHeight) {
        this.ensureHeight = ensureHeight;
    }

    public void setAddedHorizontalSpace(int addedSpace) {
        this.addedSpace = -addedSpace;
        if (this.addedSpace <= 0) {
            this.additionalSpace = null;
        } else if (this.addedSpace > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.addedSpace; ++i) {
                sb.append(' ');
            }
            this.additionalSpace = sb.toString();
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int h;
        TableColumn c;
        int w;
        if (value instanceof FormattedValue) {
            FormattedValue fv = (FormattedValue)value;
            super.getTableCellRendererComponent(table, this.addSpace(fv.getText()), false, false, row, column);
            this.setBackground(fv.getBgColor());
            this.setForeground(fv.getFgColor());
            this.setHorizontalAlignment(fv.getHorizontalAlignment());
            this.setToolTipText(fv.getToolTip());
        } else if (value == null) {
            super.getTableCellRendererComponent(table, this.addSpace(" "), false, false, row, column);
            TableColumn c2 = table.getColumnModel().getColumn(column);
            this.setBackground(MonitorFormat.COLOR_OFF);
            this.setHorizontalAlignment(0);
        } else {
            super.getTableCellRendererComponent(table, this.addSpace(value.toString()), false, false, row, column);
            this.setHorizontalAlignment(0);
        }
        if (this.ensureWidth && (w = this.getMinimumSize().width + 2) > (c = table.getColumnModel().getColumn(column)).getMinWidth()) {
            c.setMinWidth(w);
        }
        if (this.ensureHeight && (h = this.getMinimumSize().height) > table.getRowHeight(row)) {
            table.setRowHeight(row, h);
        }
        return this;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private String addSpace(String text) {
        if (this.addedSpace == 0) {
            return text;
        }
        if (this.addedSpace < 0) {
            return this.additionalSpace + text + this.additionalSpace;
        }
        int n = text.length();
        StringBuilder sb = new StringBuilder();
        int space = 0;
        int i = 0;
        while (i < n && text.charAt(i++) == ' ') {
            ++space;
        }
        while (space++ < this.addedSpace) {
            sb.append(' ');
        }
        sb.append(text);
        if (i != n) {
            space = 0;
            i = n;
            while (text.charAt(--i) == ' ') {
                ++space;
            }
            while (space++ < this.addedSpace) {
                sb.append(' ');
            }
        }
        return sb.toString();
    }
}

