
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import static java.awt.image.ImageObserver.WIDTH;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * A panel to display autochanger status : AP1, AP2, AP3, AF0, AF1, AF2
 *
 * @author virieux
 */
public class AutochangerStatusPanel extends JPanel {
    private static final long serialVersionUID = 1L;

    private final DigitalSwitch ap1Switch = new DigitalSwitch();
    private final DigitalSwitch ap2Switch = new DigitalSwitch();
    private final DigitalSwitch ap3Switch = new DigitalSwitch();
    private final DigitalSwitch af0Switch = new DigitalSwitch();
    private final DigitalSwitch af1Switch = new DigitalSwitch();
    private final DigitalSwitch af3Switch = new DigitalSwitch();

    public AutochangerStatusPanel() {
        initComponents();
    }

    /**
     * A Runnable to update from data published by autochanger. For output
     * signals from autochanger : AF0, AF1, AF3, AP1, AP2, AP3
     */
    class UpdateAutochanger implements Runnable {

        private final StatusDataPublishedByAutoChanger s;

        UpdateAutochanger(StatusDataPublishedByAutoChanger s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (s.isOUT_AF0_InError()) {
                af0Switch.setColor(Color.RED);
            } else if (s.isOUT_AF0()) {
                af0Switch.setColor(greenColor);
            } else {
                af0Switch.setColor(Color.gray);
            }

            if (s.isOUT_AF1_InError()) {
                af1Switch.setColor(Color.RED);
            } else if (s.isOUT_AF1()) {
                af1Switch.setColor(greenColor);
            } else {
                af1Switch.setColor(Color.gray);
            }

            if (s.isOUT_AF3_InError()) {
                af3Switch.setColor(Color.RED);
            } else if (s.isOUT_AF3()) {
                af3Switch.setColor(greenColor);
            } else {
                af3Switch.setColor(Color.gray);
            }

            if (s.isOUT_AP1_InError()) {
                ap1Switch.setColor(Color.RED);
            } else if (s.isOUT_AP1()) {
                ap1Switch.setColor(greenColor);
            } else {
                ap1Switch.setColor(Color.gray);
            }

            if (s.isOUT_AP2_InError()) {
                ap2Switch.setColor(Color.RED);
            } else if (s.isOUT_AP2()) {
                ap2Switch.setColor(greenColor);
            } else {
                ap2Switch.setColor(Color.gray);
            }

            if (s.isOUT_AP3_InError()) {
                ap3Switch.setColor(Color.RED);
            } else if (s.isOUT_AP3()) {
                ap3Switch.setColor(greenColor);
            } else {
                ap3Switch.setColor(Color.gray);
            }
        }
    }

    /**
     * A Runnable to update from data published by loader.
     */
    class UpdateLoader implements Runnable {

        private final StatusDataPublishedByLoader s;

        UpdateLoader(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (s.isAf0InError()) {
                af0Switch.setColor(Color.RED);
            } else if (s.isAf0()) {
                af0Switch.setColor(greenColor);
            } else {
                af0Switch.setColor(Color.gray);
            }

            if (s.isAf1InError()) {
                af1Switch.setColor(Color.RED);
            } else if (s.isAf1()) {
                af1Switch.setColor(greenColor);
            } else {
                af1Switch.setColor(Color.gray);
            }

            if (s.isAf3InError()) {
                af3Switch.setColor(Color.RED);
            } else if (s.isAf3()) {
                af3Switch.setColor(greenColor);
            } else {
                af3Switch.setColor(Color.gray);
            }

            if (s.isAp2InError()) {
                ap2Switch.setColor(Color.RED);
            } else if (s.isAp2()) {
                ap2Switch.setColor(greenColor);
            } else {
                ap2Switch.setColor(Color.gray);
            }
        }
    }

    /**
     * A Runnable to update from data published by carousel.
     */
    class UpdateCarousel implements Runnable {

        private final StatusDataPublishedByCarousel s;

        UpdateCarousel(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (s.isAp1InError()) {
                ap1Switch.setColor(Color.RED);
            } else if (s.isAp1()) {
                ap1Switch.setColor(greenColor);
            } else {
                ap1Switch.setColor(Color.gray);
            }

            if (s.isAp2InError()) {
                ap2Switch.setColor(Color.RED);
            } else if (s.isAp2()) {
                ap2Switch.setColor(greenColor);
            } else {
                ap2Switch.setColor(Color.gray);
            }

            if (s.isAp3InError()) {
                ap3Switch.setColor(Color.RED);
            } else if (s.isAf3()) {
                ap3Switch.setColor(greenColor);
            } else {
                ap3Switch.setColor(Color.gray);
            }

            if (s.isAf3InError()) {
                af3Switch.setColor(Color.RED);
            } else if (s.isAp2()) {
                af3Switch.setColor(greenColor);
            } else {
                af3Switch.setColor(Color.gray);
            }
        }
    }

    /**
     * To update the Panel when the autochanger publishes on the bus its global
     * status.
     *
     * @param status
     */
    public void updateAutochanger(StatusDataPublishedByAutoChanger status) {
        SwingUtilities.invokeLater(new AutochangerStatusPanel.UpdateAutochanger(status));
    }

    /**
     * To update the Panel when the loader publishes on the bus its global
     * status.
     *
     * @param status
     */
    public void updateLoader(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new AutochangerStatusPanel.UpdateLoader(status));
    }

    /**
     * To update the Panel when the carousel publishes on the bus its global
     * status.
     *
     * @param status
     */
    public void updateCarousel(StatusDataPublishedByCarousel status) {
        SwingUtilities.invokeLater(new AutochangerStatusPanel.UpdateCarousel(status));
    }

    /**
     * To initialize all the components of this Panel.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        //CameraProtectionPanel with status coming from autochanger
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(
                Color.MAGENTA, WIDTH + 5), "Read on acPlutoGateway"));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = insets_std;
        add(new JLabel("AP1 (AC at standby)"), gbc);
        gbc.gridy++;
        add(new JLabel("AP2 (AC at handoff)"), gbc);
        gbc.gridy++;
        add(new JLabel("AP3 (AC at online)"), gbc);
        gbc.gridy++;
        add(new JLabel("AF0 (AC latches opened)"), gbc);
        gbc.gridy++;
        add(new JLabel("AF1 (filter detected in AC)"), gbc);
        gbc.gridy++;
        add(new JLabel("AF3 (filter locked in AC)"), gbc);

        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.EAST;
        add(ap1Switch, gbc);
        gbc.gridy++;
        add(ap2Switch, gbc);
        gbc.gridy++;
        add(ap3Switch, gbc);
        gbc.gridy++;
        add(af0Switch, gbc);
        gbc.gridy++;
        add(af1Switch, gbc);
        gbc.gridy++;
        add(af3Switch, gbc);
        setDefaultValues();
    }

    protected void setDefaultValues() {
        ap1Switch.setColor(Color.gray);
        ap2Switch.setColor(Color.gray);
        ap3Switch.setColor(Color.gray);
        af0Switch.setColor(Color.gray);
        af1Switch.setColor(Color.gray);
        af3Switch.setColor(Color.gray);
    }

    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    /**
     * To be displayed on the GUI.
     *
     * @return
     */
    @Override
    public String toString() {
        return "Autochanger Protection Status";
    }

    /**
     * Just for tests.
     *
     * @param args
     */
    public static void main(String[] args) {
        AutochangerStatusPanel d = new AutochangerStatusPanel();
        JFrame frame = new JFrame("AutochangerProtectionStatusPanel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }


}
