/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselDisk;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class CarouselGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 3579024322081964467L;
    private static final String NONE = "None";
    private InterfaceCarouselGUI subs;
    private final JPanel generalInfoPanel = new JPanel();
    private final JLabel speedLabel = new JLabel();
    private final JPanel actualParametersPanel = new JPanel();
    private final JLabel homingLabel = new JLabel();
    private final JLabel actualPositionLabel = new JLabel();
    private final JLabel actualSpeedLabel = new JLabel();
    private final JLabel actualCurrentLabel = new JLabel();
    private final JLabel standbyLabel = new JLabel();
    private final DigitalSwitch standbySwitch = new DigitalSwitch();
    private final JLabel socketAtStandbyLabel = new JLabel();
    private final JLabel filterAtStandbyLabel = new JLabel();
    private final CarouselDisk carouselDisk = new CarouselDisk();
    private final JPanel controlPanel = new JPanel();
    private final JButton updatePositionButton = new JButton("Update Position");
    private final JButton rotateButton = new JButton("RotateSocketToStandby");
    private final JTextField socketNBField = new JTextField(1);
    private final JLabel socketLabel = new JLabel("enter socket nb:");
    private int socketID;

    public CarouselGeneralViewPanel() {
        this.initComponents();
    }

    protected void setSubsystem(InterfaceCarouselGUI subs) {
        this.subs = subs;
    }

    private void setDefaultValues() {
        this.speedLabel.setText("0.0");
        this.homingLabel.setText("NOT DONE");
        this.homingLabel.setForeground(Color.RED);
        this.actualPositionLabel.setText("0.0");
        this.actualSpeedLabel.setText("0.0");
        this.actualCurrentLabel.setText("0.0");
        this.standbyLabel.setText("NOT AT STANDBY position");
        this.standbySwitch.setColor(Color.gray);
        this.socketAtStandbyLabel.setText(NONE);
        this.filterAtStandbyLabel.setText("NO FILTER");
    }

    protected void initializeGui(ConfigurationInfo configInfo) {
    }

    protected void update(StatusDataPublishedByCarousel s) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " updating from carousel data:"));
        SwingUtilities.invokeLater(new Update(s));
    }

    protected void update(String filterName, String socketName) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " updating from filter data:"));
        SwingUtilities.invokeLater(new UpdateFilter(filterName, socketName));
    }

    private void initComponents() {
        this.setName("carouselGeneralViewPanel");
        this.updatePositionButton.addActionListener(evt -> this.updatePositionButtonActionPerformed(evt));
        this.rotateButton.addActionListener(evt -> this.rotateButtonActionPerformed(evt));
        this.socketNBField.addActionListener(evt -> this.socketNBFieldActionPerformed(evt));
        this.setDefaultValues();
        this.generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        this.generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        this.generalInfoPanel.add((Component)new JLabel("Maximum speed:"), gbc3);
        ++gbc3.gridy;
        ++gbc3.gridx;
        gbc3.gridy = 0;
        gbc3.anchor = 22;
        this.generalInfoPanel.add((Component)this.speedLabel, gbc3);
        this.actualParametersPanel.setBorder(BorderFactory.createLineBorder(Color.yellow));
        this.actualParametersPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 21;
        this.actualParametersPanel.add((Component)new JLabel("Homing: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Position: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Speed: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Current: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.standbyLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Socket at STANDBY: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Filter at STANDBY: "), gbc1);
        ++gbc1.gridx;
        gbc1.gridy = 0;
        gbc1.anchor = 22;
        this.actualParametersPanel.add((Component)this.homingLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.actualPositionLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.actualSpeedLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.actualCurrentLabel, gbc1);
        ++gbc1.gridy;
        this.standbySwitch.setColor(Color.gray);
        this.actualParametersPanel.add((Component)this.standbySwitch, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.socketAtStandbyLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.filterAtStandbyLabel, gbc1);
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.insets = Tools.insets_std;
        gbc4.anchor = 23;
        gbc4.fill = 2;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        gbc4.gridwidth = 2;
        this.controlPanel.add((Component)this.updatePositionButton, gbc4);
        ++gbc4.gridy;
        gbc4.anchor = 13;
        gbc4.gridwidth = 1;
        this.controlPanel.add((Component)this.socketLabel, gbc4);
        ++gbc4.gridx;
        gbc4.anchor = 17;
        gbc4.fill = 0;
        this.controlPanel.add((Component)this.socketNBField, gbc4);
        ++gbc4.gridy;
        gbc4.gridx = 0;
        gbc4.gridwidth = 2;
        gbc4.fill = 2;
        gbc4.anchor = 23;
        this.controlPanel.add((Component)this.rotateButton, gbc4);
        this.setBorder(BorderFactory.createTitledBorder("CAROUSEL GENERAL VIEW"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        this.add((Component)this.carouselDisk, gbc);
        gbc.gridheight = 1;
        ++gbc.gridx;
        this.add((Component)this.generalInfoPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.actualParametersPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.controlPanel, gbc);
    }

    private void updatePositionButtonActionPerformed(ActionEvent evt) {
        this.subs.updatePosition();
    }

    private void rotateButtonActionPerformed(ActionEvent evt) {
        this.subs.rotate(this.socketID);
    }

    private void socketNBFieldActionPerformed(ActionEvent evt) {
        this.socketID = Integer.parseInt(this.socketNBField.getText());
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.carouselDisk.resetPanel();
    }

    @Override
    public String toString() {
        return "Carousel General View";
    }

    public static void main(String[] argv) {
        CarouselGeneralViewPanel d = new CarouselGeneralViewPanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateFilter
    implements Runnable {
        private final String filterName;
        private final String socketName;

        public UpdateFilter(String filterName, String socketName) {
            this.filterName = filterName;
            this.socketName = socketName;
        }

        @Override
        public void run() {
            CarouselGeneralViewPanel.this.carouselDisk.update(this.filterName, this.socketName);
        }
    }

    public class Update
    implements Runnable {
        private final StatusDataPublishedByCarousel s;

        public Update(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isHomingDone()) {
                CarouselGeneralViewPanel.this.homingLabel.setText("DONE");
                CarouselGeneralViewPanel.this.homingLabel.setForeground(Tools.greenColor);
            } else {
                CarouselGeneralViewPanel.this.homingLabel.setText("TO_BE_DONE");
                CarouselGeneralViewPanel.this.homingLabel.setForeground(Color.RED);
            }
            CarouselGeneralViewPanel.this.actualPositionLabel.setText(Integer.toString(this.s.getPosition()));
            CarouselGeneralViewPanel.this.actualSpeedLabel.setText(Double.toString(this.s.getVelocity()));
            CarouselGeneralViewPanel.this.actualCurrentLabel.setText(Double.toString(this.s.getCurrent()));
            if (this.s.isAtStandby()) {
                CarouselGeneralViewPanel.this.standbyLabel.setText("AT STANDBY position");
                CarouselGeneralViewPanel.this.standbySwitch.setColor(Tools.greenColor);
                CarouselGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                CarouselGeneralViewPanel.this.socketAtStandbyLabel.setFont(Tools.BIG_FONT);
                CarouselGeneralViewPanel.this.filterAtStandbyLabel.setText(this.s.getFilterAtStandbyName());
                CarouselGeneralViewPanel.this.filterAtStandbyLabel.setFont(Tools.BIG_FONT);
            } else {
                CarouselGeneralViewPanel.this.standbyLabel.setText("NOT AT STANDBY position");
                CarouselGeneralViewPanel.this.standbySwitch.setColor(Color.orange);
                CarouselGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                CarouselGeneralViewPanel.this.filterAtStandbyLabel.setText(CarouselGeneralViewPanel.NONE);
            }
            CarouselGeneralViewPanel.this.carouselDisk.update(this.s);
        }
    }
}

