package org.lsst.ccs.subsystems.fcs.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.ui.commons.BottomPanel;

/**
 * This this the bottom panel for the whole FCS subsystem.
 *
 * @author virieux
 */
public class FcsBottomPanel extends BottomPanel {
    private static final long serialVersionUID = 7628056462801372170L;

    /**
     * Build a new FcsBottomPanel with a FcsGatherPanel and a title.
     * The title is displayed on the border of the Panel.
     *
     * @param gatherPanel
     * @param title
     */
    public FcsBottomPanel(FcsGatherPanel gatherPanel, String title) {
        super(gatherPanel, title);
    }

    /**
     * Creates the nodes of the TreePanel.
     * This tree is displayed on the left part of this Panel.
     * @param top
     */
    @Override
    public void createNodes(DefaultMutableTreeNode top) {

        if (gatherPanel == null) {
            gatherPanel = new FcsGatherPanel(CHANGER_TCPPROXY_NAME);
        }

        /** Overview view */
        top.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getGeneralViewPanel()));

        /** Changer CANopen devices panels*/
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("Changer CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getCanOpenHardwareListPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getClampXminusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getClampXplusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getCarouselControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getHyTTCPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getCancbxAI814Panel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getCancbxPT100Panel()));

        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getPlutoGatewayPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getLatchXminusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getLatchXplusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getLinearRailSlaveControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getLinearRailMasterControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getOnlineClampXminusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getOnlineClampXplusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((FcsGatherPanel) gatherPanel).getOnlineClampYminusControllerPanel()));
        top.add(devicesNode);

        /** Loader CANopen devices panels*/
        DefaultMutableTreeNode loaderDevicesNode = new DefaultMutableTreeNode("Loader CANopen devices");
        loaderDevicesNode.add(new DefaultMutableTreeNode(
                ((FcsGatherPanel) gatherPanel).getLoaderGatherPanel().getCanOpenHardwareListPanel()));
        loaderDevicesNode.add(new DefaultMutableTreeNode(
                ((FcsGatherPanel) gatherPanel).getLoaderGatherPanel().getHooksControllerPanel()));
        loaderDevicesNode.add(new DefaultMutableTreeNode(
                ((FcsGatherPanel) gatherPanel).getLoaderGatherPanel().getCarrierControllerPanel()));
        loaderDevicesNode.add(new DefaultMutableTreeNode(
                ((FcsGatherPanel) gatherPanel).getLoaderGatherPanel().getPlutoGatewayPanel()));
        top.add(loaderDevicesNode);



        DefaultMutableTreeNode autochangerNode = new DefaultMutableTreeNode("Autochanger");
        top.add(autochangerNode);

        DefaultMutableTreeNode carouselNode = new DefaultMutableTreeNode("Carousel");
        top.add(carouselNode);

        DefaultMutableTreeNode loaderNode = new DefaultMutableTreeNode("Loader");
        top.add(loaderNode);

        /********************************************************************/
        /*   Carousel panels*/
        /********************************************************************/
        /** Carousel General view */
        carouselNode.add(new DefaultMutableTreeNode(((FcsGatherPanel)
                gatherPanel).getCarouselGatherPanel().getCaGeneralViewPanel()));

        /** Filter List Panel */
        carouselNode.add(new DefaultMutableTreeNode(((FcsGatherPanel)
                gatherPanel).getCarouselGatherPanel().getFilterListPanel()));


        /** Carousel socket panel*/
        DefaultMutableTreeNode socketsNode = new DefaultMutableTreeNode("Carousel sockets");
        ((FcsGatherPanel)
                gatherPanel).getCarouselGatherPanel().getSocketPanels().entrySet().stream().forEach((entry) -> {
            socketsNode.add(new DefaultMutableTreeNode(entry.getValue()));
        });
        carouselNode.add(socketsNode);
        /********************************************************************/

        /********************************************************************/
        /*   Autochanger panels*/
        /********************************************************************/
        autochangerNode.add(new DefaultMutableTreeNode(((FcsGatherPanel)
                gatherPanel).getAutochangerGatherPanel().getAcGeneralViewPanel()));

        autochangerNode.add(new DefaultMutableTreeNode(((FcsGatherPanel)
                gatherPanel).getAutochangerGatherPanel().getAcLatchesPanel()));

        autochangerNode.add(new DefaultMutableTreeNode(((FcsGatherPanel)
                gatherPanel).getAutochangerGatherPanel().getAcTrucksPanel()));

        autochangerNode.add(new DefaultMutableTreeNode(((FcsGatherPanel)
                gatherPanel).getAutochangerGatherPanel().getAcClampsPanel()));
        /********************************************************************/

        /********************************************************************/
        /*   Loader panels*/
        /********************************************************************/
        /** Loader General view Panel*/
        loaderNode.add(new DefaultMutableTreeNode(((FcsGatherPanel)
                gatherPanel).getLoaderGatherPanel().getLoaderGeneralViewPanel()));

        /** Clamp Panel*/
        loaderNode.add(new DefaultMutableTreeNode(((FcsGatherPanel)
                gatherPanel).getLoaderGatherPanel().getLoaderClampPanel()));

        /** Carrier Panel*/
        loaderNode.add(new DefaultMutableTreeNode(((FcsGatherPanel)
                gatherPanel).getLoaderGatherPanel().getLoaderCarrierPanel()));

        /********************************************************************/

    }

}
