/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.carousel.ui.AnalogicSensorPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class FilterPresenceSensorPanel
extends AnalogicSensorPanel {
    private static final long serialVersionUID = 1L;

    public FilterPresenceSensorPanel(String clampName, String sensorName, int orientation) {
        super(clampName, sensorName, orientation);
    }

    @Override
    public void initializeGui(ConfigurationInfo configInfo) {
        Map config = configInfo.getCurrentValuesFor(this.clampName);
        String[] words = this.sensorName.split("X");
        this.minLockValueLabel.setText("0");
        this.valueALabel.setText("0");
        this.valueBLabel.setText((String)config.get(words[0] + "ValueB"));
        this.maxLockValueLabel.setText((String)config.get(words[0] + "MaxValue"));
    }

    protected void updateOffset1(int value) {
        this.minLockValueLabel.setText(Integer.toString(value));
    }

    protected void updateOffset2(int value) {
        this.valueALabel.setText(Integer.toString(value));
    }

    @Override
    protected void initParamsPanel() {
        this.paramsPanel = new JPanel();
        this.paramsPanel.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = Tools.insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = 21;
        this.paramsPanel.add((Component)new JLabel("offset1:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("offset2:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("minNoFilter:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("maxValue:"), gbcp);
        ++gbcp.gridx;
        gbcp.anchor = 22;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        this.paramsPanel.add((Component)this.minLockValueLabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.valueALabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.valueBLabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.maxLockValueLabel, gbcp);
    }

    public static void main(String[] argv) {
        FilterPresenceSensorPanel d = new FilterPresenceSensorPanel("clampToto", "leBoCapteur", 0);
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

