package org.lsst.ccs.subsystems.fcs;

import javax.swing.JComponent;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGUI;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.FcsGUI;

/**
 * 
 *
 * @author onoprien
 */
@Plugin(name="LSST CCS Filter Control Subsystem GUI",
        id="fcs-gui",
        description="LSST CCS Filter Control Subsystem GUI")
public class LsstFcsPlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------

// -- Life cycle : -------------------------------------------------------------
    
    @Override
    public void initialize() {
        OptionalPage.getService().add(new FcsOptPage());
        OptionalPage.getService().add(new AutochangerOptPage());
        OptionalPage.getService().add(new CarouselOptPage());
        OptionalPage.getService().add(new LoaderOptPage());
    }
    
// -- GUI pages : --------------------------------------------------------------
    
    // for whole fcs //
    private class FcsOptPage implements OptionalPage {

        @Override
        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty(AgentCategory.AGENT_CATEGORY_PROPERTY, "").equals(AgentCategory.FILTER_CHANGER.name())
                    && (agent.getAgentProperty("org.lsst.ccs.subsystem.fcs.wholefcs") != null)) {
                return "CCS Subsystems/" + agent.getName() +"/FCS";
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            FcsGUI fcsGUI = new FcsGUI("FcsGUI", "org.lsst.ccs.subsystem.fcs.wholefcs", Agent.getEnvironmentMessagingAccess());
            fcsGUI.initGui();
            return fcsGUI.getGuiLayout();
        }
        
    }
    
    // for autochanger in standalone mode 
    private class AutochangerOptPage implements OptionalPage {

        @Override
        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty(AgentCategory.AGENT_CATEGORY_PROPERTY,"").equals(AgentCategory.FILTER_CHANGER.name())
                    && (agent.getAgentProperty("org.lsst.ccs.subsystem.fcs.autochanger") != null)) {
                return "CCS Subsystems/" + agent.getName() +"/AUTOCHANGER";
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            AutochangerGUI autochangerGUI = new AutochangerGUI("AutochangerGUI","org.lsst.ccs.subsystem.fcs.autochanger",
                getConsole().getMessagingAccess());
            autochangerGUI.initGui();
            return autochangerGUI.getGuiLayout();
        }

    }
    
    // for carousel in standalone mode 
    private class CarouselOptPage implements OptionalPage {

        @Override
        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty(AgentCategory.AGENT_CATEGORY_PROPERTY,"").equals(AgentCategory.FILTER_CHANGER.name())
                    && (agent.getAgentProperty("org.lsst.ccs.subsystem.fcs.carousel") != null)) {
                return "CCS Subsystems/" + agent.getName() +"/CAROUSEL";
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            CarouselGUI carouselGUI = new CarouselGUI("CarouselGUIModule", 
                    "org.lsst.ccs.subsystem.fcs.carousel", getConsole().getMessagingAccess());
            carouselGUI.initGui();
            return carouselGUI.getGuiLayout();
        }
        
    }

        
    // for loader in standalone mode 
    private class LoaderOptPage implements OptionalPage {

        @Override
        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty(AgentCategory.AGENT_CATEGORY_PROPERTY,"").equals(AgentCategory.FILTER_CHANGER.name())
                    && (agent.getAgentProperty("org.lsst.ccs.subsystem.fcs.loader") != null)) {
                return "CCS Subsystems/" + agent.getName() +"/LOADER";
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            LoaderGUI loaderGUI = new LoaderGUI("LoaderGUIModule", 
                    "org.lsst.ccs.subsystem.fcs.loader", getConsole().getMessagingAccess());
            loaderGUI.initGui();
            return loaderGUI.getGuiLayout();
        }
        
    }        

}
