/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.structs;

import java.io.Serializable;

public class ParameterPath
implements Serializable,
Comparable {
    private static final long serialVersionUID = -8374146985540286600L;
    final String componentName;
    final String parameterName;

    public ParameterPath(String componentName, String parameterName) {
        if (componentName == null || parameterName == null) {
            throw new IllegalArgumentException("null argument in ParameterPath");
        }
        this.componentName = componentName;
        this.parameterName = parameterName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterPath that = (ParameterPath)o;
        if (!this.componentName.equals(that.componentName)) {
            return false;
        }
        return this.parameterName.equals(that.parameterName);
    }

    public int hashCode() {
        int result = this.componentName.hashCode();
        result = 31 * result + this.parameterName.hashCode();
        return result;
    }

    public String toString() {
        return this.componentName + '/' + this.parameterName;
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public static ParameterPath valueOf(String pathString) {
        if (pathString.contains("//")) {
            String[] split = pathString.split("//");
            return new ParameterPath(split[0], split[1]);
        }
        int lastSep = pathString.lastIndexOf(47);
        if (lastSep < 0) {
            throw new IllegalArgumentException(pathString + " is is not a configuration parameter path");
        }
        String parameterName = pathString.substring(lastSep + 1);
        String componentName = pathString.substring(0, lastSep);
        return new ParameterPath(componentName, parameterName);
    }
}

