/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import javax.swing.JComponent;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGUI;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.FcsGUI;

@Plugin(name="LSST CCS Filter Control Subsystem GUI", id="fcs-gui", description="LSST CCS Filter Control Subsystem GUI")
public class LsstFcsPlugin
extends ConsolePlugin {
    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new FcsOptPage());
        OptionalPage.getService().add((OptionalPage)new AutochangerOptPage());
        OptionalPage.getService().add((OptionalPage)new CarouselOptPage());
        OptionalPage.getService().add((OptionalPage)new LoaderOptPage());
    }

    private class LoaderOptPage
    implements OptionalPage {
        private LoaderOptPage() {
        }

        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty("agentCategory", "").equals(AgentCategory.FILTER_CHANGER.name()) && agent.getAgentProperty("org.lsst.ccs.subsystem.fcs.loader") != null) {
                return "CCS Subsystems/" + agent.getName() + "/LOADER";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            LoaderGUI loaderGUI = new LoaderGUI("LoaderGUIModule", "org.lsst.ccs.subsystem.fcs.loader", LsstFcsPlugin.this.getConsole().getMessagingAccess());
            loaderGUI.initGui();
            return loaderGUI.getGuiLayout();
        }
    }

    private class CarouselOptPage
    implements OptionalPage {
        private CarouselOptPage() {
        }

        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty("agentCategory", "").equals(AgentCategory.FILTER_CHANGER.name()) && agent.getAgentProperty("org.lsst.ccs.subsystem.fcs.carousel") != null) {
                return "CCS Subsystems/" + agent.getName() + "/CAROUSEL";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            CarouselGUI carouselGUI = new CarouselGUI("CarouselGUIModule", "org.lsst.ccs.subsystem.fcs.carousel", LsstFcsPlugin.this.getConsole().getMessagingAccess());
            carouselGUI.initGui();
            return carouselGUI.getGuiLayout();
        }
    }

    private class AutochangerOptPage
    implements OptionalPage {
        private AutochangerOptPage() {
        }

        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty("agentCategory", "").equals(AgentCategory.FILTER_CHANGER.name()) && agent.getAgentProperty("org.lsst.ccs.subsystem.fcs.autochanger") != null) {
                return "CCS Subsystems/" + agent.getName() + "/AUTOCHANGER";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            AutochangerGUI autochangerGUI = new AutochangerGUI("AutochangerGUI", "org.lsst.ccs.subsystem.fcs.autochanger", LsstFcsPlugin.this.getConsole().getMessagingAccess());
            autochangerGUI.initGui();
            return autochangerGUI.getGuiLayout();
        }
    }

    private class FcsOptPage
    implements OptionalPage {
        private FcsOptPage() {
        }

        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty("agentCategory", "").equals(AgentCategory.FILTER_CHANGER.name()) && agent.getAgentProperty("org.lsst.ccs.subsystem.fcs.wholefcs") != null) {
                return "CCS Subsystems/" + agent.getName() + "/FCS";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            FcsGUI fcsGUI = new FcsGUI("FcsGUI", "org.lsst.ccs.subsystem.fcs.wholefcs", Agent.getEnvironmentMessagingAccess());
            fcsGUI.initGui();
            return fcsGUI.getGuiLayout();
        }
    }
}

