/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.FcsBottomPanel;
import org.lsst.ccs.subsystems.fcs.ui.FcsGatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

public class FcsGUI
extends GeneralGUI
implements InterfaceCarouselGUI,
InterfaceAutochangerGUI,
InterfaceLoaderGUI {
    private static final long serialVersionUID = -6702752740750789411L;
    private static final String clampModuleName = "clamp";
    private static final String carrierModuleName = "carrier";
    private long timeoutForTrucksMotion;
    private long updateTrucksPositionTimeout;
    private long timeoutForOnlineClampMotion;
    private final long timeoutForClosingClamps;
    private long timeoutForClosingLatches;
    private long rotationTimeout;
    private long updateCarouselPositionTimeout;
    protected long updateCarrierPositionTimeout;
    protected long openHooksTimeout;
    protected long closeHooksTimeout;
    protected long clampHooksTimeout;
    protected long homingHooksTimeout;
    protected long goToHandoffTimeout;
    protected long goToStorageTimeout;
    protected long goToEngagedTimeout;
    protected long quickStopTimeout;

    public FcsGUI(String name, String role, AgentMessagingLayer aml) {
        super(name, role, aml);
        FcsGatherPanel fcsGatherPanel = new FcsGatherPanel(this);
        FcsBottomPanel fcsBottomPanel = new FcsBottomPanel(fcsGatherPanel, "FCS");
        this.generalPanel = new GeneralPanel(this, fcsBottomPanel);
        this.pane = new JScrollPane(this.generalPanel);
        this.updateTrucksPositionTimeout = 1000L;
        this.timeoutForClosingLatches = 10000L;
        this.timeoutForClosingClamps = 10000L;
        this.rotationTimeout = 20000L;
        this.updateCarouselPositionTimeout = 1000L;
        this.openHooksTimeout = 0L;
        this.closeHooksTimeout = 0L;
        this.clampHooksTimeout = 0L;
        this.homingHooksTimeout = 0L;
        this.goToHandoffTimeout = 0L;
        this.goToStorageTimeout = 0L;
        this.abortTimeout = 1000L;
        this.quickStopTimeout = 1000L;
        this.updateStateWithSensorsTimeout = 1000L;
        this.updateCarrierPositionTimeout = 1000L;
    }

    @Override
    public void setLoGoToHandoffTimeout(int aInt) {
        this.goToHandoffTimeout = aInt;
    }

    @Override
    public void setLoGoToStorageTimeout(int aInt) {
        this.goToStorageTimeout = aInt;
    }

    @Override
    public void setLoGoToEngagedTimeout(int goToEngagedTimeout) {
        this.goToEngagedTimeout = goToEngagedTimeout;
    }

    @Override
    public void setOpenHooksTimeout(long openHooksTimeout) {
        this.openHooksTimeout = openHooksTimeout;
    }

    @Override
    public void setCloseHooksTimeout(long closeHooksTimeout) {
        this.closeHooksTimeout = closeHooksTimeout;
    }

    @Override
    public void setClampHooksTimeout(long clampHooksTimeout) {
        this.clampHooksTimeout = clampHooksTimeout;
    }

    @Override
    public void setHomingHooksTimeout(long homingHooksTimeout) {
        this.homingHooksTimeout = homingHooksTimeout;
    }

    @Override
    public void checkFiltersLocation() {
        new GeneralGUI.CommandSwingWorker("checkFiltersLocation", this.updateStateWithSensorsTimeout).execute();
    }

    @Override
    public void rotate(int socketID) {
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + " bad socket ID; enter a digit between 1 and 5");
        }
        new GeneralGUI.CommandSwingWorker("rotateSocketToStandby socket" + socketID, this.rotationTimeout, "carousel").execute();
    }

    @Override
    public void updatePosition() {
        new GeneralGUI.CommandSwingWorker("carousel/updatePosition", this.updateCarouselPositionTimeout).execute();
    }

    @Override
    public void unlockClamps() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }

    @Override
    public void setTimeoutForOnlineClampMotion(long timeoutForOnlineClampMotion) {
        this.timeoutForOnlineClampMotion = timeoutForOnlineClampMotion;
    }

    @Override
    public void closeLatch(String latchName) {
        FCSCst.FCSLOG.info((Object)("Autochanger locking latch: " + latchName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker("close", this.timeoutForClosingLatches, latchName).execute();
    }

    @Override
    public void openLatch(String latchName) {
        FCSCst.FCSLOG.info((Object)("Autochanger unlocking latch: " + latchName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker("open", this.timeoutForClosingLatches, latchName).execute();
    }

    @Override
    public void closeLatches() {
        FCSCst.FCSLOG.info((Object)"Autochanger locking latches.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker("close", this.timeoutForClosingLatches, "latches").execute();
    }

    @Override
    public void openLatches() {
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking latches.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker("open", this.timeoutForClosingLatches, "latches").execute();
    }

    @Override
    public void unlockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking online clamps");
        new GeneralGUI.CommandSwingWorker("unlockClamps", this.timeoutForOnlineClampMotion, "onlineClamps").execute();
    }

    @Override
    public void lockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger locking online clamps");
        new GeneralGUI.CommandSwingWorker("lockClamps", this.timeoutForOnlineClampMotion, "onlineClamps").execute();
    }

    @Override
    public void closeOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger closing online clamps");
        new GeneralGUI.CommandSwingWorker("closeClamps", this.timeoutForOnlineClampMotion, "onlineClamps").execute();
    }

    @Override
    public void openOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger opening online clamps");
        new GeneralGUI.CommandSwingWorker("openClamps", this.timeoutForOnlineClampMotion, "onlineClamps").execute();
    }

    @Override
    public void unlockAndOpenOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking and opening online clamps");
        new GeneralGUI.CommandSwingWorker("unlockAndOpenClamps", this.timeoutForOnlineClampMotion, "onlineClamps").execute();
    }

    @Override
    public void closeAndLockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger closing and locking online clamps");
        new GeneralGUI.CommandSwingWorker("closeAndLockClamps", this.timeoutForOnlineClampMotion, "onlineClamps").execute();
    }

    @Override
    public void homingOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger homing online clamp: " + clampName));
        new GeneralGUI.CommandSwingWorker("openInCurrentModeAndHoming", this.timeoutForOnlineClampMotion, clampName).execute();
    }

    @Override
    public void openOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger opening clamp: " + clampName));
        new GeneralGUI.CommandSwingWorker("open", this.timeoutForClosingClamps, clampName).execute();
    }

    @Override
    public void closeOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger closing clamp: " + clampName));
        new GeneralGUI.CommandSwingWorker("close", this.timeoutForClosingClamps, clampName).execute();
    }

    @Override
    public void lockOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger clamping clamp: " + clampName));
        new GeneralGUI.CommandSwingWorker("lock", this.timeoutForClosingClamps, clampName).execute();
    }

    @Override
    public void unlockOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger unclamping clamp: " + clampName));
        new GeneralGUI.CommandSwingWorker("unlock", this.timeoutForClosingClamps, clampName).execute();
    }

    @Override
    public void acUpdateTrucksPosition() {
        FCSCst.FCSLOG.info((Object)"Autochanger updating Trucks position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.updateTrucksPositionTimeout));
        new GeneralGUI.CommandSwingWorker("updatePosition", this.updateTrucksPositionTimeout, "autochangerTrucks").execute();
    }

    @Override
    public void acGoToHandOff() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Handoff Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("goToHandOff", this.timeoutForTrucksMotion, "autochangerTrucks").execute();
    }

    @Override
    public void acGoToOnline() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to ONLINE Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("goToOnline", this.timeoutForTrucksMotion, "autochangerTrucks").execute();
    }

    @Override
    public void acGoToStandby() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Standby Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("goToStandby", this.timeoutForTrucksMotion, "autochangerTrucks").execute();
    }

    @Override
    public void acMoveAndClampFilterOnline() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks moving to Online Position, and clamping");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("moveAndClampFilterOnline", this.timeoutForTrucksMotion, "autochangerTrucks").execute();
    }

    @Override
    public void loLoadFilter() {
        System.out.println(this.destination + "loadFilterInCamera with timeout=" + this.goToHandoffTimeout);
        FCSCst.FCSLOG.info((Object)"Loading filter in camera");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToHandoffTimeout));
        new GeneralGUI.CommandSwingWorker("loadFilterInCamera", this.goToHandoffTimeout).execute();
    }

    @Override
    public void loUnloadFilter() {
        System.out.println(this.destination + "unloadFilterFromCamera with timeout=" + this.goToStorageTimeout);
        FCSCst.FCSLOG.info((Object)"Loading filter in camera");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToStorageTimeout));
        new GeneralGUI.CommandSwingWorker("unloadFilterFromCamera", this.goToStorageTimeout).execute();
    }

    @Override
    public void loUpdateCarrierPosition() {
        System.out.println(this.destination + "updateCarrierPosition with updateCarrierPositionTimeout=" + this.updateCarrierPositionTimeout);
        FCSCst.FCSLOG.info((Object)"Updating carrier position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.updateCarrierPositionTimeout));
        new GeneralGUI.CommandSwingWorker("updatePosition", this.updateCarrierPositionTimeout, carrierModuleName).execute();
    }

    @Override
    public void loOpenHooks() {
        FCSCst.FCSLOG.info((Object)"Opening Hooks");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.openHooksTimeout));
        new GeneralGUI.CommandSwingWorker("openHooks", this.openHooksTimeout).execute();
    }

    @Override
    public void loCloseHooks() {
        FCSCst.FCSLOG.info((Object)"Closing Hooks");
        System.out.println("/timeout=" + this.closeHooksTimeout);
        new GeneralGUI.CommandSwingWorker("closeHooks", this.closeHooksTimeout).execute();
    }

    @Override
    public void loClampHooks() {
        FCSCst.FCSLOG.info((Object)"Clamping Hooks");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.clampHooksTimeout));
        new GeneralGUI.CommandSwingWorker("clampHooks", this.clampHooksTimeout).execute();
    }

    @Override
    public void loUnclampHooks() {
        FCSCst.FCSLOG.info((Object)"Unclamping Hooks");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.clampHooksTimeout));
        new GeneralGUI.CommandSwingWorker("unclamp", this.clampHooksTimeout, clampModuleName).execute();
    }

    @Override
    public void loClampHoming() {
        FCSCst.FCSLOG.info((Object)"Clamp going to Home Position or CLAMPED position.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.homingHooksTimeout));
        new GeneralGUI.CommandSwingWorker("initializeHardware", this.homingHooksTimeout, clampModuleName).execute();
    }

    @Override
    public void loGoToHandOff() {
        FCSCst.FCSLOG.info((Object)"Carrier going to Handoff Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToHandoffTimeout));
        new GeneralGUI.CommandSwingWorker("goToHandOff", this.goToHandoffTimeout, carrierModuleName).execute();
    }

    @Override
    public void loGoToStorage() {
        System.out.println(this.destination + "goToStorage with goToStorageTimeout=" + this.goToStorageTimeout);
        FCSCst.FCSLOG.info((Object)"Carrier going to Storage Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToStorageTimeout));
        new GeneralGUI.CommandSwingWorker("goToStorage", this.goToStorageTimeout, carrierModuleName).execute();
    }

    @Override
    public void loGoToEngaged() {
        FCSCst.FCSLOG.info((Object)("Carrier going to Engaged Position with timeout=" + this.goToEngagedTimeout));
        new GeneralGUI.CommandSwingWorker("goToEngaged", this.goToEngagedTimeout, carrierModuleName).execute();
    }

    public static void main(String[] args) {
        Agent agent = new Agent("FcsGUI", AgentInfo.AgentType.CONSOLE);
        FcsGUI t = new FcsGUI(agent.getName(), "fcs", agent.getMessagingAccess());
        agent.startAgent();
        JFrame frame = new JFrame("Fcs View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }
}

