/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class LoaderGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 8834267363875256916L;
    private InterfaceLoaderGUI subs;
    private final JLabel onCameraLabel = new JLabel("ON CAMERA SENSOR");
    private final JPanel fakeSensorsPanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final JPanel cpsPanel = new JPanel();
    private final JPanel keysPanel = new JPanel();
    private final DigitalSwitch onCameraDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch ap2Switch = new DigitalSwitch();
    private final DigitalSwitch af0Switch = new DigitalSwitch();
    private final DigitalSwitch af1Switch = new DigitalSwitch();
    private final DigitalSwitch af3Switch = new DigitalSwitch();
    private final DigitalSwitch keyLockSwitch = new DigitalSwitch();
    private final DigitalSwitch keyEngSwitch = new DigitalSwitch();
    private final JPanel homingPanel = new JPanel();
    private final JLabel clhomLabel = new JLabel("Clamp controller homing:");
    private final JLabel cahomLabel = new JLabel("Carrier controller homing:");
    private final JLabel clampHomingLabel = new JLabel();
    private final JLabel carrierHomingLabel = new JLabel();
    private final JButton loadFilterButton = new JButton("loadFilterInCamera");
    private final JButton unloadFilterButton = new JButton("unloadFilterFromCamera");

    public LoaderGeneralViewPanel() {
        this.initComponents();
    }

    public LoaderGeneralViewPanel(InterfaceLoaderGUI subs) {
        this.subs = subs;
        this.initComponents();
    }

    public void setSubsystem(InterfaceLoaderGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
    }

    public void updateLoaderGeneral(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateLoaderGeneral(status));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "LOADER"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        this.homingPanel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 2));
        this.homingPanel.setLayout(new GridBagLayout());
        this.clampHomingLabel.setFont(Tools.BIG_FONT);
        this.carrierHomingLabel.setFont(Tools.BIG_FONT);
        GridBagConstraints gbc6 = new GridBagConstraints();
        gbc6.insets = Tools.insets_std;
        gbc6.gridx = 0;
        gbc6.gridy = 0;
        this.homingPanel.add((Component)this.clhomLabel, gbc6);
        ++gbc6.gridx;
        this.homingPanel.add((Component)this.clampHomingLabel, gbc6);
        gbc6.gridx = 0;
        ++gbc6.gridy;
        this.homingPanel.add((Component)this.cahomLabel, gbc6);
        ++gbc6.gridx;
        this.homingPanel.add((Component)this.carrierHomingLabel, gbc6);
        this.loadFilterButton.addActionListener(evt -> this.loadFilterActionPerformed(evt));
        this.unloadFilterButton.addActionListener(evt -> this.unloadFilterActionPerformed(evt));
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.fill = 2;
        this.controlPanel.add((Component)this.loadFilterButton, gbc0);
        ++gbc0.gridy;
        this.controlPanel.add((Component)this.unloadFilterButton, gbc0);
        this.fakeSensorsPanel.setBorder(BorderFactory.createTitledBorder("On camera"));
        this.fakeSensorsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = 2;
        this.fakeSensorsPanel.add((Component)this.onCameraLabel, gbc1);
        ++gbc1.gridx;
        this.fakeSensorsPanel.add((Component)this.onCameraDigitalSwitch, gbc1);
        this.cpsPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.cpsPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = 17;
        gbc0.insets = Tools.insets_std;
        this.cpsPanel.add((Component)new JLabel("AP2 (AC at handoff)"), gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)new JLabel("AF0 (AC latches opened)"), gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)new JLabel("AF1 (filter detected in AC)"), gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)new JLabel("AF3 (filter locked in AC)"), gbc0);
        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = 13;
        this.cpsPanel.add((Component)this.ap2Switch, gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)this.af0Switch, gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)this.af1Switch, gbc0);
        ++gbc0.gridy;
        this.cpsPanel.add((Component)this.af3Switch, gbc0);
        this.keysPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.keysPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = 17;
        gbc0.insets = Tools.insets_std;
        this.keysPanel.add((Component)new JLabel("keyLock/lockOut"), gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)new JLabel("Engineering key"), gbc0);
        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = 13;
        this.keysPanel.add((Component)this.keyLockSwitch, gbc0);
        ++gbc0.gridy;
        this.keysPanel.add((Component)this.keyEngSwitch, gbc0);
        GridBagConstraints gbc = new GridBagConstraints();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "LOADER General View"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        gbc.anchor = 512;
        gbc.insets = Tools.insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.cpsPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.keysPanel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        this.add((Component)this.homingPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.controlPanel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.add((Component)this.fakeSensorsPanel, gbc);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.onCameraDigitalSwitch.setColor(Color.gray);
        this.ap2Switch.setColor(Color.gray);
        this.af0Switch.setColor(Color.gray);
        this.af1Switch.setColor(Color.gray);
        this.af3Switch.setColor(Color.gray);
        this.keyLockSwitch.setColor(Color.gray);
        this.keyEngSwitch.setColor(Color.gray);
        this.clampHomingLabel.setText("TO BE DONE");
        this.clampHomingLabel.setForeground(Color.red);
        this.carrierHomingLabel.setText("TO BE DONE");
        this.carrierHomingLabel.setForeground(Color.red);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    private void loadFilterActionPerformed(ActionEvent evt) {
        this.subs.loLoadFilter();
    }

    private void unloadFilterActionPerformed(ActionEvent evt) {
        this.subs.loUnloadFilter();
    }

    @Override
    public String toString() {
        return "Loader General View Panel";
    }

    public static void main(String[] args) {
        LoaderGeneralViewPanel d = new LoaderGeneralViewPanel();
        JFrame frame = new JFrame("LoaderGeneralViewPanel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateClamp
    implements Runnable {
        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            if (this.s.isHomingDone()) {
                LoaderGeneralViewPanel.this.clampHomingLabel.setText("DONE");
                LoaderGeneralViewPanel.this.clampHomingLabel.setForeground(Tools.greenColor);
            } else {
                LoaderGeneralViewPanel.this.clampHomingLabel.setText("NOT DONE");
                LoaderGeneralViewPanel.this.clampHomingLabel.setForeground(Color.red);
            }
        }
    }

    class UpdateLoaderGeneral
    implements Runnable {
        private final StatusDataPublishedByLoader s;

        UpdateLoaderGeneral(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isLoaderOnCameraSensorsInError()) {
                LoaderGeneralViewPanel.this.onCameraDigitalSwitch.setColor(Color.RED);
            } else {
                LoaderGeneralViewPanel.this.onCameraDigitalSwitch.setColor(this.s.isLoaderOnCameraSensorValue() ? Tools.greenColor : Color.gray);
            }
            if (this.s.isAf0InError()) {
                LoaderGeneralViewPanel.this.af0Switch.setColor(Color.RED);
            } else if (this.s.isAf0()) {
                LoaderGeneralViewPanel.this.af0Switch.setColor(Tools.greenColor);
            } else {
                LoaderGeneralViewPanel.this.af0Switch.setColor(Color.gray);
            }
            if (this.s.isAf1InError()) {
                LoaderGeneralViewPanel.this.af1Switch.setColor(Color.RED);
            } else if (this.s.isAf1()) {
                LoaderGeneralViewPanel.this.af1Switch.setColor(Tools.greenColor);
            } else {
                LoaderGeneralViewPanel.this.af1Switch.setColor(Color.gray);
            }
            if (this.s.isAf3InError()) {
                LoaderGeneralViewPanel.this.af3Switch.setColor(Color.RED);
            } else if (this.s.isAf3()) {
                LoaderGeneralViewPanel.this.af3Switch.setColor(Tools.greenColor);
            } else {
                LoaderGeneralViewPanel.this.af3Switch.setColor(Color.gray);
            }
            if (this.s.isAp2InError()) {
                LoaderGeneralViewPanel.this.ap2Switch.setColor(Color.RED);
            } else if (this.s.isAp2()) {
                LoaderGeneralViewPanel.this.ap2Switch.setColor(Tools.greenColor);
            } else {
                LoaderGeneralViewPanel.this.ap2Switch.setColor(Color.gray);
            }
            if (this.s.isKeyEngInError()) {
                LoaderGeneralViewPanel.this.keyEngSwitch.setColor(Color.RED);
            } else if (this.s.isKeyEng()) {
                LoaderGeneralViewPanel.this.keyEngSwitch.setColor(Tools.greenColor);
            } else {
                LoaderGeneralViewPanel.this.keyEngSwitch.setColor(Color.gray);
            }
            if (this.s.isKeyLockInError()) {
                LoaderGeneralViewPanel.this.keyLockSwitch.setColor(Color.RED);
            } else if (this.s.isKeyLock()) {
                LoaderGeneralViewPanel.this.keyLockSwitch.setColor(Tools.greenColor);
            } else {
                LoaderGeneralViewPanel.this.keyLockSwitch.setColor(Color.gray);
            }
        }
    }
}

