/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCanOpenDevice;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderCarrierPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderClampPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGeneralViewPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;

public class LoaderGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = 4741041603580940956L;
    private final String carrierControllerName = "carrierController";
    private final String clampControllerName = "hooksController";
    private InterfaceLoaderGUI subs;
    private EPOSControllerPanel hooksControllerPanel;
    private EPOSControllerPanel carrierControllerPanel;
    private PlutoGatewayPanel plutoGatewayPanel;
    private LoaderGeneralViewPanel loaderGeneralViewPanel;
    private LoaderClampPanel loaderClampPanel;
    private LoaderCarrierPanel loaderCarrierPanel;

    public LoaderGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
        this.setName("LoaderGatherPanel");
    }

    public LoaderGatherPanel(InterfaceLoaderGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
        this.subs = subs;
        this.loaderGeneralViewPanel.setSubsystem(subs);
        this.loaderCarrierPanel.setSubsystem(subs);
        this.loaderClampPanel.setSubsystem(subs);
        this.hooksControllerPanel.setSubsystem(subs);
        this.carrierControllerPanel.setSubsystem(subs);
        this.setName("LoaderGatherPanel");
    }

    public EPOSControllerPanel getHooksControllerPanel() {
        return this.hooksControllerPanel;
    }

    public EPOSControllerPanel getCarrierControllerPanel() {
        return this.carrierControllerPanel;
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return this.plutoGatewayPanel;
    }

    public LoaderGeneralViewPanel getLoaderGeneralViewPanel() {
        return this.loaderGeneralViewPanel;
    }

    public LoaderClampPanel getLoaderClampPanel() {
        return this.loaderClampPanel;
    }

    public LoaderCarrierPanel getLoaderCarrierPanel() {
        return this.loaderCarrierPanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        this.updatePanelsFromConfigInfo(configInfo);
    }

    private void updatePanelsFromConfigInfo(ConfigurationInfo configInfo) {
        this.hooksControllerPanel.initializeGui(configInfo);
        this.carrierControllerPanel.initializeGui(configInfo);
        this.plutoGatewayPanel.initializeGui(configInfo);
        this.loaderGeneralViewPanel.initializeGui(configInfo);
        this.loaderClampPanel.initializeGui(configInfo);
        this.loaderCarrierPanel.initializeGui(configInfo);
    }

    private void updateLoaderGeneral(StatusDataPublishedByLoader statusDataPublishedByLoader) {
        this.loaderGeneralViewPanel.updateLoaderGeneral(statusDataPublishedByLoader);
        this.loaderClampPanel.updateClamp(statusDataPublishedByLoader);
    }

    private void updateClamp(StatusDataPublishedByLoaderClamp statusDataPublishedByLoaderClamp) {
        this.loaderClampPanel.updateClamp(statusDataPublishedByLoaderClamp);
        this.loaderGeneralViewPanel.updateClamp(statusDataPublishedByLoaderClamp);
    }

    private void updateCarrier(StatusDataPublishedByLoaderCarrier statusDataPublishedByLoaderCarrier) {
        this.loaderCarrierPanel.updateCarrier(statusDataPublishedByLoaderCarrier);
    }

    private void updateCarrierController(String name, StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateCarrierController(name, status));
    }

    private void updateClampController(String name, StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateClampController(name, status));
    }

    private void updateController(String controllerName, StatusDataPublishedByEPOSController controllerStatus) {
        if ("carrierController".equals(controllerName)) {
            this.updateCarrierController(controllerName, controllerStatus);
        } else if ("hooksController".equals(controllerName)) {
            this.updateClampController(controllerName, controllerStatus);
        }
    }

    @Override
    public void updateFromStatusData(KeyValueData data) {
        if ("loaderTcpProxy".equals(data.getKey())) {
            this.updateCanOpenHardwarePanel((Integer)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByLoader) {
            this.updateLoaderGeneral((StatusDataPublishedByLoader)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByLoaderClamp) {
            this.updateClamp((StatusDataPublishedByLoaderClamp)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByLoaderCarrier) {
            this.updateCarrier((StatusDataPublishedByLoaderCarrier)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByEPOSController) {
            this.updateController(data.getKey(), (StatusDataPublishedByEPOSController)data.getValue());
            this.updateCanOpenHardwarePanel(data.getKey(), (StatusDataPublishedByHardware)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByPlutoGateway) {
            this.updateCanOpenHardwarePanel(data.getKey(), (StatusDataPublishedByHardware)data.getValue());
            this.plutoGatewayPanel.updatePlutoGateway(data.getKey(), (StatusDataPublishedByPlutoGateway)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByCanOpenDevice) {
            this.updateCanOpenHardwarePanel(data.getKey(), (StatusDataPublishedByHardware)((StatusDataPublishedByCanOpenDevice)data.getValue()));
        }
    }

    @Override
    public void updateFromConfigurationInfo(ConfigurationInfo configInfo) {
        this.updatePanelsFromConfigInfo(configInfo);
    }

    private void initPanels() {
        this.hooksControllerPanel = new EPOSControllerPanel("hooksController");
        this.carrierControllerPanel = new EPOSControllerPanel("carrierController");
        this.plutoGatewayPanel = new PlutoGatewayPanel("loaderPlutoGateway");
        this.loaderGeneralViewPanel = new LoaderGeneralViewPanel();
        this.loaderClampPanel = new LoaderClampPanel("clamp");
        this.loaderCarrierPanel = new LoaderCarrierPanel("carrier");
    }

    @Override
    public void resetPanel() {
        super.resetPanel();
        this.hooksControllerPanel.resetPanel();
        this.carrierControllerPanel.resetPanel();
        this.loaderGeneralViewPanel.resetPanel();
        this.loaderClampPanel.resetPanel();
        this.loaderCarrierPanel.resetPanel();
        this.plutoGatewayPanel.resetPanel();
    }

    public static void main(String[] argv) {
        LoaderGatherPanel d = new LoaderGatherPanel("loaderTcpProxy");
        JFrame frame = new JFrame("Loader High Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateClampController
    implements Runnable {
        private final String name;
        private final StatusDataPublishedByEPOSController s;

        public UpdateClampController(String name, StatusDataPublishedByEPOSController s) {
            this.name = name;
            this.s = s;
        }

        @Override
        public void run() {
            LoaderGatherPanel.this.hooksControllerPanel.updateController(this.name, this.s);
        }
    }

    class UpdateCarrierController
    implements Runnable {
        private final String name;
        private final StatusDataPublishedByEPOSController s;

        public UpdateCarrierController(String name, StatusDataPublishedByEPOSController s) {
            this.name = name;
            this.s = s;
        }

        @Override
        public void run() {
            LoaderGatherPanel.this.carrierControllerPanel.updateController(this.name, this.s);
        }
    }
}

