/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderBottomPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

public class LoaderGUI
extends GeneralGUI
implements InterfaceLoaderGUI {
    private static final long serialVersionUID = 5516615814565445162L;
    private static final String clampModuleName = "clamp";
    private static final String carrierModuleName = "carrier";
    protected long updateCarrierPositionTimeout;
    protected long openHooksTimeout;
    protected long closeHooksTimeout;
    protected long clampHooksTimeout;
    protected long homingHooksTimeout;
    protected long goToHandoffTimeout;
    protected long goToEngagedTimeout;
    protected long goToStorageTimeout;
    protected long quickStopTimeout;

    public LoaderGUI(String name, String role, AgentMessagingLayer agentMessagingLayer) {
        super(name, role, agentMessagingLayer);
        LoaderGatherPanel loaderGatherPanel = new LoaderGatherPanel(this, "loaderTcpProxy");
        LoaderBottomPanel loaderBottomPanel = new LoaderBottomPanel(loaderGatherPanel, "LOADER");
        this.generalPanel = new GeneralPanel(this, loaderBottomPanel);
        this.pane = new JScrollPane(this.generalPanel);
        this.openHooksTimeout = 0L;
        this.closeHooksTimeout = 0L;
        this.clampHooksTimeout = 0L;
        this.homingHooksTimeout = 0L;
        this.goToHandoffTimeout = 0L;
        this.goToEngagedTimeout = 0L;
        this.goToStorageTimeout = 0L;
        this.abortTimeout = 1000L;
        this.quickStopTimeout = 1000L;
        this.updateStateWithSensorsTimeout = 1000L;
        this.updateCarrierPositionTimeout = 1000L;
    }

    @Override
    public void setLoGoToHandoffTimeout(int aInt) {
        this.goToHandoffTimeout = aInt;
    }

    @Override
    public void setLoGoToStorageTimeout(int aInt) {
        this.goToStorageTimeout = aInt;
    }

    @Override
    public void setLoGoToEngagedTimeout(int goToEngagedTimeout) {
        this.goToEngagedTimeout = goToEngagedTimeout;
    }

    @Override
    public void setOpenHooksTimeout(long openHooksTimeout) {
        this.openHooksTimeout = openHooksTimeout;
    }

    @Override
    public void setCloseHooksTimeout(long closeHooksTimeout) {
        this.closeHooksTimeout = closeHooksTimeout;
    }

    @Override
    public void setClampHooksTimeout(long clampHooksTimeout) {
        this.clampHooksTimeout = clampHooksTimeout;
    }

    @Override
    public void setHomingHooksTimeout(long homingHooksTimeout) {
        this.homingHooksTimeout = homingHooksTimeout;
    }

    @Override
    public JComponent getGuiLayout() {
        return this.pane;
    }

    @Override
    public String getName() {
        return "LoaderGUIModule";
    }

    @Override
    public void loLoadFilter() {
        System.out.println(this.destination + "loadFilterInCamera with timeout=" + this.goToHandoffTimeout);
        FCSCst.FCSLOG.info((Object)"Loading filter in camera");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToHandoffTimeout));
        new GeneralGUI.CommandSwingWorker(this, "loadFilterInCamera", this.goToHandoffTimeout).execute();
    }

    @Override
    public void loUnloadFilter() {
        System.out.println(this.destination + "unloadFilterFromCamera with timeout=" + this.goToStorageTimeout);
        FCSCst.FCSLOG.info((Object)"Loading filter in camera");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToStorageTimeout));
        new GeneralGUI.CommandSwingWorker(this, "unloadFilterFromCamera", this.goToStorageTimeout).execute();
    }

    @Override
    public void loUpdateCarrierPosition() {
        System.out.println(this.destination + "updateCarrierPosition with updateCarrierPositionTimeout=" + this.updateCarrierPositionTimeout);
        FCSCst.FCSLOG.info((Object)"Updating carrier position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.updateCarrierPositionTimeout));
        new GeneralGUI.CommandSwingWorker(this, "updatePosition", this.updateCarrierPositionTimeout, carrierModuleName).execute();
    }

    @Override
    public void loOpenHooks() {
        FCSCst.FCSLOG.info((Object)"Opening Hooks");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.openHooksTimeout));
        new GeneralGUI.CommandSwingWorker(this, "open", this.openHooksTimeout, clampModuleName).execute();
    }

    @Override
    public void loCloseHooks() {
        FCSCst.FCSLOG.info((Object)"Closing Hooks");
        System.out.println("/timeout=" + this.closeHooksTimeout);
        new GeneralGUI.CommandSwingWorker(this, "close", this.closeHooksTimeout, clampModuleName).execute();
    }

    @Override
    public void loClampHooks() {
        FCSCst.FCSLOG.info((Object)"Clamping Hooks");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.clampHooksTimeout));
        new GeneralGUI.CommandSwingWorker(this, clampModuleName, this.clampHooksTimeout, clampModuleName).execute();
    }

    @Override
    public void loUnclampHooks() {
        FCSCst.FCSLOG.info((Object)"Unclamping Hooks");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.clampHooksTimeout));
        new GeneralGUI.CommandSwingWorker(this, "unclamp", this.clampHooksTimeout, clampModuleName).execute();
    }

    @Override
    public void loGoToHandOff() {
        FCSCst.FCSLOG.info((Object)"Carrier going to Handoff Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToHandoffTimeout));
        new GeneralGUI.CommandSwingWorker(this, "goToHandOff", this.goToHandoffTimeout, carrierModuleName).execute();
    }

    @Override
    public void loGoToEngaged() {
        FCSCst.FCSLOG.info((Object)"Carrier going to Engaged Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToEngagedTimeout));
        new GeneralGUI.CommandSwingWorker(this, "goToEngaged", this.goToEngagedTimeout, carrierModuleName).execute();
    }

    @Override
    public void loGoToStorage() {
        System.out.println(this.destination + "goToStorage with goToStorageTimeout=" + this.goToStorageTimeout);
        FCSCst.FCSLOG.info((Object)"Carrier going to Storage Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToStorageTimeout));
        new GeneralGUI.CommandSwingWorker(this, "goToStorage", this.goToStorageTimeout, carrierModuleName).execute();
    }

    @Override
    public void loClampHoming() {
        FCSCst.FCSLOG.info((Object)"Clamp homing");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.homingHooksTimeout));
        new GeneralGUI.CommandSwingWorker(this, "homing", this.homingHooksTimeout, clampModuleName).execute();
    }

    public static void main(String[] args) {
        Agent agent = new Agent("LoaderGUIModule", AgentInfo.AgentType.CONSOLE);
        LoaderGUI t = new LoaderGUI(agent.getName(), "loader-standalone", agent.getMessagingAccess());
        agent.startAgent();
        t.initGui();
        JFrame frame = new JFrame("Loader View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

