/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselBottomPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGatherPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

public class CarouselGUI
extends GeneralGUI
implements InterfaceCarouselGUI {
    private static final long serialVersionUID = 3716082311687590505L;
    private final long timeoutForOpeningClamps = 10000L;
    private final long timeoutForRotation = 10000L;
    private final long timeoutForCheckingFilterLocation = 2000L;
    private final long timeoutForCANbus = 500L;

    public CarouselGUI(String name, String role, AgentMessagingLayer aml) {
        super(name, role, aml);
        this.updateStateWithSensorsTimeout = 5000L;
        CarouselGatherPanel carouselGatherPanel = new CarouselGatherPanel(this, "tcpProxy");
        CarouselBottomPanel carouselBottomPanel = new CarouselBottomPanel(carouselGatherPanel, "CAROUSEL");
        this.generalPanel = new GeneralPanel(this, carouselBottomPanel);
        this.pane = new JScrollPane(this.generalPanel);
    }

    @Override
    public String getName() {
        return "CarouselGUIModule";
    }

    @Override
    public void checkFiltersLocation() {
        new GeneralGUI.CommandSwingWorker("checkFiltersLocation", this.timeoutForCheckingFilterLocation).execute();
    }

    @Override
    public void rotate(int socketID) {
        FCSCst.FCSLOG.info((Object)"Carousel rotating");
        StringBuilder stringBuilder = new StringBuilder().append("/timeout=");
        this.getClass();
        FCSCst.FCSLOG.info((Object)stringBuilder.append(10000L).toString());
        String string = "rotateSocketToStandby socket" + socketID;
        this.getClass();
        new GeneralGUI.CommandSwingWorker(string, 10000L, "carousel").execute();
    }

    @Override
    public void updatePosition() {
        FCSCst.FCSLOG.info((Object)"Carousel updating position");
        StringBuilder stringBuilder = new StringBuilder().append("/timeout=");
        this.getClass();
        FCSCst.FCSLOG.info((Object)stringBuilder.append(10000L).toString());
        new GeneralGUI.CommandSwingWorker("updatePosition", this.timeoutForCANbus, "carousel").execute();
    }

    @Override
    public void unlockClamps() {
        FCSCst.FCSLOG.info((Object)"Carousel unlocking clamps");
        FCSCst.FCSLOG.info((Object)"/timeout=10000");
        this.getClass();
        new GeneralGUI.CommandSwingWorker("unlockClamps", 10000L).execute();
    }

    public static void main(String[] args) {
        Agent agent = new Agent("CarouselGUI", AgentInfo.AgentType.CONSOLE);
        CarouselGUI t = new CarouselGUI(agent.getName(), "carousel", agent.getMessagingAccess());
        agent.startAgent();
        JFrame frame = new JFrame("Carousel View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }
}

