
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

/**
 * 
 * @author virieux
 */
public interface InterfaceAutochangerGUI extends InterfaceGeneralGUI {
    

    void setTimeoutForTrucksMotion(long timeoutForTrucksMotion);
    
    void setTimeoutForOnlineClampMotion(long timeoutForOnlineClampMotion);
    
    /**
     ******************************************************************************
     ** Latches Actions
     * *****************************************************************************
     * @param latchName
     */
    void closeLatch(String latchName);

    void closeLatches();

    void openLatch(String latchName);

    void openLatches();




    /**
     ******************************************************************************
     ** Clamps Actions
     * *****************************************************************************
     */
    void unlockOnlineClamps();
    void lockOnlineClamps();
    void closeOnlineClamps();
    void openOnlineClamps();    
    void unlockAndOpenOnlineClamps();
    void closeAndLockOnlineClamps();

    void homingOnlineClamp(String clampName);
    void openOnlineClamp(String clampName);
    void closeOnlineClamp(String clampName);
    void lockOnlineClamp(String clampName);
    void unlockOnlineClamp(String clampName);
    
    /**
     ******************************************************************************
     ** end of Clamps Actions
     * *****************************************************************************
     */    
    

    /**
     ******************************************************************************
     ** Trucks Actions
     * *****************************************************************************
     */
    void acUpdateTrucksPosition();
    
    void acGoToHandOff();

    void acGoToOnline();

    void acGoToStandby();
    
    void acMoveAndClampFilterOnline();
    
    /**
     ******************************************************************************
     ** end of Trucks Actions
     * *****************************************************************************
     */    
    
}
