/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.StatisticsBlock;
import jas.util.JASDialog;
import jas.util.JASState;
import jas.util.SciFormatPanel;
import jas.util.ScientificFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Format;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class StatsWindow
extends JASDialog
implements ActionListener {
    public static JFrame frame;
    private JButton all;
    private JButton none;
    private JRadioButton alltitles;
    private JRadioButton notitles;
    private JRadioButton sometitles;
    private JRadioButton leftalign;
    private JRadioButton rightalign;
    private JRadioButton noalign;
    private JRadioButton alwaysall;
    private JRadioButton subset;
    private String[] names;
    private JLabel selectlabel;
    private SciFormatPanel scipanel;
    private ScientificFormat f;
    private StatisticsBlock statblock;
    private JList list;
    private int showtitles;
    private int splitalign;

    public StatsWindow(StatisticsBlock b) {
        super((Frame)frame, "Statistic Display Options", true, 15);
        this.statblock = b;
        Format sf = b.getFormat();
        this.f = sf instanceof ScientificFormat ? (ScientificFormat)sf : new ScientificFormat();
    }

    public void showStatsWindow() {
        super.setHelpTopic("userInterface.Statistics");
        Container c = this.getContentPane();
        c.removeAll();
        this.scipanel = new SciFormatPanel(this.f);
        ButtonGroup allways_subset_group = new ButtonGroup();
        this.alwaysall = new JRadioButton("Always show all statistics");
        this.alwaysall.addActionListener(this);
        this.alwaysall.setActionCommand("alwaysall");
        this.subset = new JRadioButton("Show selection of current statistics");
        this.subset.addActionListener(this);
        this.subset.setActionCommand("subset");
        allways_subset_group.add(this.alwaysall);
        allways_subset_group.add(this.subset);
        Box allways_subset_box = new Box(0);
        allways_subset_box.add(this.alwaysall);
        allways_subset_box.add(this.subset);
        this.names = this.statblock.getStatNames();
        this.list = new JList<CheckableItem>(this.createData(this.names));
        this.list.setVisibleRowCount(3);
        this.list.setCellRenderer(new CheckListRenderer());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = StatsWindow.this.list.locationToIndex(e.getPoint());
                if (index != -1 && StatsWindow.this.list.getModel().getSize() > index) {
                    CheckableItem item;
                    item.setSelected(!(item = (CheckableItem)StatsWindow.this.list.getModel().getElementAt(index)).isSelected());
                    Rectangle rect = StatsWindow.this.list.getCellBounds(index, index);
                    StatsWindow.this.list.repaint(rect);
                }
            }
        });
        JScrollPane checkbuttonspanel = new JScrollPane(this.list);
        Box subsetbuttons = new Box(1);
        this.all = new JButton("All");
        this.none = new JButton("None");
        this.all.setActionCommand("all");
        this.all.addActionListener(this);
        this.none.setActionCommand("none");
        this.none.addActionListener(this);
        subsetbuttons.add(this.all);
        subsetbuttons.add(this.none);
        JPanel statselection = new JPanel();
        statselection.setLayout(new BorderLayout());
        this.selectlabel = new JLabel("Choose selection of current statistics for display");
        statselection.add((Component)this.selectlabel, "North");
        statselection.add((Component)subsetbuttons, "East");
        statselection.add((Component)checkbuttonspanel, "Center");
        Box statoptionsbox = new Box(1);
        statoptionsbox.add(allways_subset_box);
        statoptionsbox.add(statselection);
        JPanel statoptions = new JPanel();
        statoptions.setBorder(BorderFactory.createTitledBorder("Choose a statistics display options"));
        statoptions.add(statoptionsbox);
        this.showtitles = this.statblock.getShowTitles();
        this.alltitles = new JRadioButton("Always show title");
        this.notitles = new JRadioButton("Never show title");
        this.sometitles = new JRadioButton("Show if multiple plots");
        this.alltitles.setActionCommand("alltitles");
        this.alltitles.addActionListener(this);
        this.notitles.setActionCommand("notitles");
        this.notitles.addActionListener(this);
        this.sometitles.setActionCommand("sometitles");
        this.sometitles.addActionListener(this);
        Box titlebox = new Box(0);
        titlebox.add(this.alltitles);
        titlebox.add(this.notitles);
        titlebox.add(this.sometitles);
        ButtonGroup titlegroup = new ButtonGroup();
        titlegroup.add(this.alltitles);
        titlegroup.add(this.notitles);
        titlegroup.add(this.sometitles);
        if (this.showtitles == 1) {
            this.alltitles.setSelected(true);
        } else if (this.showtitles == 2) {
            this.notitles.setSelected(true);
        } else if (this.showtitles == 3) {
            this.sometitles.setSelected(true);
        }
        JPanel titleoptions = new JPanel();
        titleoptions.setBorder(BorderFactory.createTitledBorder("Select a title display option for plots with statistics"));
        titleoptions.add(titlebox);
        this.splitalign = this.statblock.getSplitStringAlign();
        this.leftalign = new JRadioButton("Left align numbers");
        this.rightalign = new JRadioButton("Right align numbers");
        this.noalign = new JRadioButton("Do not align numbers");
        this.leftalign.setActionCommand("leftalign");
        this.leftalign.addActionListener(this);
        this.rightalign.setActionCommand("rightalign");
        this.rightalign.addActionListener(this);
        this.noalign.setActionCommand("noalign");
        this.noalign.addActionListener(this);
        ButtonGroup aligngroup = new ButtonGroup();
        Box alignbox = new Box(0);
        aligngroup.add(this.leftalign);
        aligngroup.add(this.rightalign);
        aligngroup.add(this.noalign);
        alignbox.add(this.leftalign);
        alignbox.add(this.rightalign);
        alignbox.add(this.noalign);
        JPanel alignoptions = new JPanel();
        alignoptions.setBorder(BorderFactory.createTitledBorder("Select an alignment display option for the statistics values"));
        alignoptions.add(alignbox);
        if (this.splitalign == 1) {
            this.leftalign.setSelected(true);
        } else if (this.splitalign == 2) {
            this.rightalign.setSelected(true);
        } else if (this.splitalign == 3) {
            this.noalign.setSelected(true);
        }
        JPanel scioptions = this.scipanel.getPanel();
        scioptions.setBorder(BorderFactory.createTitledBorder("Set number formating parameters for numerical statistics"));
        if (this.statblock.get_AllwaysAll_Subset()) {
            this.alwaysall.setSelected(true);
            this.enableStatSelections(false);
        } else {
            this.subset.setSelected(true);
        }
        Box box = new Box(1);
        box.add(statoptions);
        box.add(titleoptions);
        box.add(alignoptions);
        box.add(scioptions);
        c.add(box);
        this.pack();
        this.show();
    }

    @Override
    public void onOK() {
        this.scipanel.updateSciFormat();
        ListModel model = this.list.getModel();
        if (this.alwaysall.isSelected()) {
            String[] s = null;
            this.statblock.setSelectedEntries(null);
            this.statblock.set_AllwaysAll_Subset(true);
        } else if (model.getSize() > 0) {
            String[] s;
            int n = model.getSize();
            int j = 0;
            for (int i = 0; i < n; ++i) {
                CheckableItem item = (CheckableItem)model.getElementAt(i);
                if (!item.isSelected()) continue;
                ++j;
            }
            if (j > 0) {
                s = new String[j];
                int k = 0;
                for (int i = 0; i < n; ++i) {
                    CheckableItem item = (CheckableItem)model.getElementAt(i);
                    if (!item.isSelected()) continue;
                    s[k] = item.toString();
                    ++k;
                }
            } else {
                s = new String[]{"\none"};
            }
            this.statblock.setSelectedEntries(s);
            this.statblock.set_AllwaysAll_Subset(false);
        } else {
            String[] s = null;
            this.statblock.setSelectedEntries(null);
            this.statblock.set_AllwaysAll_Subset(false);
        }
        this.statblock.setShowTitles(this.showtitles);
        this.statblock.setSplitStringAlign(this.splitalign);
        this.statblock.setFormat(this.f);
        this.dispose();
    }

    @Override
    protected void enableApply(JASState state) {
        state.setEnabled(true);
    }

    @Override
    protected void enableHelp(JASState state) {
        state.setEnabled(true);
    }

    @Override
    public void onCancel() {
        this.dispose();
    }

    @Override
    public void onApply() {
        this.scipanel.updateSciFormat();
        ListModel model = this.list.getModel();
        if (this.alwaysall.isSelected()) {
            String[] s = null;
            this.statblock.setSelectedEntries(null);
            this.statblock.set_AllwaysAll_Subset(true);
        } else if (model.getSize() > 0) {
            String[] s;
            int n = model.getSize();
            int j = 0;
            for (int i = 0; i < n; ++i) {
                CheckableItem item = (CheckableItem)model.getElementAt(i);
                if (!item.isSelected()) continue;
                ++j;
            }
            if (j > 0) {
                s = new String[j];
                int k = 0;
                for (int i = 0; i < n; ++i) {
                    CheckableItem item = (CheckableItem)model.getElementAt(i);
                    if (!item.isSelected()) continue;
                    s[k] = item.toString();
                    ++k;
                }
            } else {
                s = new String[]{"\none"};
            }
            this.statblock.setSelectedEntries(s);
            this.statblock.set_AllwaysAll_Subset(false);
        } else {
            String[] s = null;
            this.statblock.setSelectedEntries(null);
            this.statblock.set_AllwaysAll_Subset(false);
        }
        this.statblock.setShowTitles(this.showtitles);
        this.statblock.setSplitStringAlign(this.splitalign);
        this.statblock.setFormat(this.f);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "all") {
            ListModel model = this.list.getModel();
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                CheckableItem item = (CheckableItem)model.getElementAt(i);
                item.setSelected(true);
            }
            this.list.repaint();
        } else if (e.getActionCommand() == "none") {
            ListModel model = this.list.getModel();
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                CheckableItem item = (CheckableItem)model.getElementAt(i);
                item.setSelected(false);
            }
            this.list.repaint();
        } else if (e.getActionCommand() == "alwaysall") {
            this.enableStatSelections(false);
        } else if (e.getActionCommand() == "subset") {
            this.enableStatSelections(true);
        } else if (e.getActionCommand() == "alltitles") {
            this.showtitles = 1;
        } else if (e.getActionCommand() == "notitles") {
            this.showtitles = 2;
        } else if (e.getActionCommand() == "sometitles") {
            this.showtitles = 3;
        } else if (e.getActionCommand() == "leftalign") {
            this.splitalign = 1;
        } else if (e.getActionCommand() == "rightalign") {
            this.splitalign = 2;
        } else if (e.getActionCommand() == "noalign") {
            this.splitalign = 3;
        }
    }

    private void enableStatSelections(boolean toggleable) {
        this.all.setEnabled(toggleable);
        this.none.setEnabled(toggleable);
        this.selectlabel.setEnabled(toggleable);
        this.list.setEnabled(toggleable);
    }

    private CheckableItem[] createData(String[] strs) {
        int n = strs.length;
        CheckableItem[] items = new CheckableItem[n];
        for (int i = 0; i < n; ++i) {
            items[i] = new CheckableItem(strs[i]);
        }
        return items;
    }

    class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CheckListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.setEnabled(list.isEnabled());
            this.setSelected(((CheckableItem)value).isSelected());
            this.setText(value.toString());
            this.setBackground(Color.white);
            return this;
        }
    }

    class CheckableItem {
        private String str;
        private boolean isSelected;

        public CheckableItem(String str) {
            this.str = str;
            this.isSelected = false;
            this.initializeSelection();
        }

        private void initializeSelection() {
            String[] oldselections = StatsWindow.this.statblock.getSelectedEntries();
            if (oldselections == null) {
                this.setSelected(true);
            }
            if (oldselections != null) {
                for (int i = 0; i < oldselections.length; ++i) {
                    if (!this.str.equals(oldselections[i])) continue;
                    this.setSelected(true);
                }
            }
        }

        public void setSelected(boolean b) {
            this.isSelected = b;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public String toString() {
            return this.str;
        }
    }
}

