package org.lsst.ccs.subsystems.fcs.ui;

import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

/**
 *
 * @author virieux
 */
public interface InterfaceFcsGUI extends InterfaceGeneralGUI {

    long connectLoaderTimeout = 3000;

    long setFilterTimeout = 180000;

    long loadFilterTimout = 240000;

    default void setFilter(int filterID) {
        System.out.println("setFilter with timeout=" + setFilterTimeout);
        FCSLOG.info("Setting filter");
        sendCommand("setFilter " + filterID, setFilterTimeout);
    }

    default void loadFilter() {
        System.out.println("loadFilter with timeout=" + loadFilterTimout);
        FCSLOG.info("Loading filter in camera");
        sendCommand("loadFilter", loadFilterTimout);
    }

    default void unloadFilter() {
        System.out.println("unloadFilter with timeout=" + loadFilterTimout);
        FCSLOG.info("Unloading filter in camera");
        sendCommand("unloadFilter", loadFilterTimout);
    }

    default void connectLoader() {
        System.out.println("connect loader with timeout=" + connectLoaderTimeout);
        FCSLOG.info("connecting loader CANbus");
        sendCommand("connectLoaderCANbus", connectLoaderTimeout);
    }

    default void disconnectLoader() {
        System.out.println("disconnect loader with timeout=" + connectLoaderTimeout);
        FCSLOG.info("disconnecting loader CANbus");
        sendCommand("disconnectLoaderCANbus", connectLoaderTimeout);
    }

}
