
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class FilterPresenceSensorPanel extends AnalogicSensorPanel {

    private static final long serialVersionUID = 1L;

    public FilterPresenceSensorPanel(String clampName, String sensorName, int orientation) {
        super(clampName, sensorName, orientation);
    }

    /**
     * Initialize the GUI with the configuration data.
     *
     * @param configInfo
     */
    @Override
    public void initializeGui(ConfigurationInfo configInfo) {
        Map<String, String> config = configInfo.getCurrentValuesFor(clampName);
        String[] words = sensorName.split("X");
        minLockValueLabel.setText("0");
        valueALabel.setText("0");
        offset3Label.setText(config.get("filterPresenceOffset3"));
        valueBLabel.setText(config.get(words[0] + "ValueB"));
        maxLockValueLabel.setText(config.get(words[0] + "MaxValue"));
    }

    protected void updateOffset1(int value) {
        minLockValueLabel.setText(Integer.toString(value));
    }

    protected void updateOffset2(int value) {
        valueALabel.setText(Integer.toString(value));
    }

    @Override
    protected void initParamsPanel() {
        /**
         ******************************************************************************
         ** FilterPresence Sensor Parameters Panels
         * *****************************************************************************
         */
        paramsPanel = new JPanel();
        paramsPanel.setBorder(BorderFactory.createLineBorder(Color.blue));
        paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;

        /*first columm*/
        gbcp.anchor = GridBagConstraints.LINE_START;
        paramsPanel.add(new JLabel("offset1:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("offset2:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("offset3:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("minNoFilter:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("maxValue:"), gbcp);

        /*second columm*/
        gbcp.gridx++;
        gbcp.anchor = GridBagConstraints.LINE_END;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        paramsPanel.add(minLockValueLabel, gbcp);
        gbcp.gridy++;
        paramsPanel.add(valueALabel, gbcp);
        gbcp.gridy++;
        paramsPanel.add(offset3Label, gbcp);
        gbcp.gridy++;
        paramsPanel.add(valueBLabel, gbcp);
        gbcp.gridy++;
        paramsPanel.add(maxLockValueLabel, gbcp);
        /**
         ******************************************************************************
         ** end of General Parameters Panels
         * *****************************************************************************
         */
    }

    /**
     * Just to test the Panel.
     *
     * @param argv
     */
    public static void main(String[] argv) {

        AnalogicSensorPanel d = new FilterPresenceSensorPanel("clampToto", "leBoCapteur", 1);
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
