/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.pluginmanager.AvailablePluginPanel;
import org.freehep.application.studio.pluginmanager.InstalledPluginPanel;
import org.freehep.application.studio.pluginmanager.PluginManager;

class PluginManagerDialog
extends JDialog {
    private PluginManager manager;
    private JTabbedPane tabs;
    private JDialog waitDialog;
    private ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PluginManagerDialog.this.dispose();
        }
    };
    private ChangeListener cl = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            PluginManagerDialog.this.setTabLabels();
            if (PluginManagerDialog.this.waitDialog != null) {
                PluginManagerDialog.this.waitDialog.dispose();
            }
        }
    };

    @Override
    public void addNotify() {
        super.addNotify();
        this.manager.addChangeListener(this.cl);
    }

    @Override
    public void removeNotify() {
        this.manager.removeChangeListener(this.cl);
        super.removeNotify();
    }

    PluginManagerDialog(JFrame frame, PluginManager manager) {
        super(frame);
        this.manager = manager;
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tabs = new JTabbedPane(){

            @Override
            public void setSelectedIndex(int index) {
                if (index == 1 && !PluginManagerDialog.this.manager.isPluginListIsReady()) {
                    final JOptionPane option = new JOptionPane();
                    option.setMessage("Please wait while plugin list is downloaded");
                    JButton cancel = new JButton("Cancel"){

                        @Override
                        protected void fireActionPerformed(ActionEvent e) {
                            option.setValue(this);
                        }
                    };
                    cancel.setMnemonic('C');
                    option.setOptions(new JButton[]{cancel});
                    PluginManagerDialog.this.waitDialog = option.createDialog(this, "Waiting");
                    PluginManagerDialog.this.waitDialog.setVisible(true);
                    PluginManagerDialog.this.waitDialog = null;
                    if (option.getValue() == cancel) {
                        return;
                    }
                }
                super.setSelectedIndex(index);
            }
        };
        InstalledPluginPanel availablePanel = new InstalledPluginPanel(manager);
        this.tabs.add(availablePanel);
        AvailablePluginPanel installPanel = new AvailablePluginPanel(manager);
        this.tabs.add(installPanel);
        this.setTabLabels();
        panel.add((Component)this.tabs, "Center");
        JPanel buttons = new JPanel();
        JButton close = new JButton("Close");
        close.addActionListener(this.al);
        buttons.add(close);
        panel.add((Component)buttons, "South");
        this.setContentPane(panel);
    }

    private void setTabLabels() {
        int n = this.manager.getActivePlugins().size();
        String title = "Installed (" + n + ")";
        this.tabs.setTitleAt(0, title);
        title = "Available";
        List<PluginInfo> available = this.manager.getInstallablePlugins();
        if (available != null) {
            n = available.size();
            title = title + " (" + n + ")";
            this.tabs.setEnabledAt(1, n > 0);
        }
        this.tabs.setTitleAt(1, title);
    }
}

