/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTruck;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerTruckPanel
extends JPanel {
    private static final long serialVersionUID = 6421842448844475453L;
    private final String truckName;
    private final DigitalSwitch standbyDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inTravelDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch handoffDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch onlineDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inErrorDigitalSwitch = new DigitalSwitch();
    private final JLabel cajLabel = new JLabel("Truck position");
    private final JLabel standbyjLabel = new JLabel("STANDBY");
    private final JLabel inTraveljLabel = new JLabel("In Travel");
    private final JLabel handoffjLabel = new JLabel("HAND-OFF");
    private final JLabel onlinejLabel = new JLabel("ONLINE");
    private final JLabel inErrorjLabel = new JLabel();
    private final JLabel handoffSensorsErrorjLabel = new JLabel();
    private final JLabel onlineSensorsErrorjLabel = new JLabel();
    private final JLabel standbySensorsErrorjLabel = new JLabel();
    private static final String ERROR_IN_SENSORS = "SENSORS ERROR";
    private static final String NO_ERROR_IN_SENSORS = "NO ERROR";
    private final JProgressBar positionProgressBar = new JProgressBar(1, 0, 500);
    private final JLabel ctlNameJLabel = new JLabel();
    private final JLabel actualPositionjLabel = new JLabel("0");
    private final JLabel currentjLabel = new JLabel("0");
    private JPanel faultCtlPanel;
    private final DigitalSwitch faultCtlSwitch = new DigitalSwitch();

    public AutochangerTruckPanel(String truckName) {
        this.truckName = truckName;
        this.initComponents();
    }

    public void initializeGui(int standbyPosition, int onlinePosition) {
        this.positionProgressBar.setMinimum(standbyPosition);
        this.positionProgressBar.setMaximum(onlinePosition);
    }

    public void updateTruck(StatusDataPublishedByAutochangerTruck status) {
        SwingUtilities.invokeLater(new UpdateTruck(status));
    }

    private void initComponents() {
        this.setDefaultValues();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.YELLOW, 2), this.truckName));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.cajLabel.setFont(Tools.BIG_FONT);
        this.cajLabel.setText("<HTML><CENTER>" + this.truckName + "<BR>position</CENTER></HTML>");
        this.add((Component)this.cajLabel, gbc);
        gbc.anchor = 12;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.standbyjLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.standbyDigitalSwitch, gbc);
        gbc.anchor = 13;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.inTraveljLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.inTravelDigitalSwitch, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.handoffjLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.handoffDigitalSwitch, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.onlinejLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.onlineDigitalSwitch, gbc);
        gbc.anchor = 10;
        gbc.gridwidth = 1;
        gbc.gridheight = 4;
        gbc.fill = 3;
        gbc.gridx = 2;
        gbc.gridy = 1;
        this.positionProgressBar.setBorderPainted(true);
        this.positionProgressBar.setValue(0);
        this.positionProgressBar.setStringPainted(true);
        this.add((Component)this.positionProgressBar, gbc);
        gbc.gridheight = 1;
        JPanel errorjPanel = new JPanel();
        errorjPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        this.inErrorDigitalSwitch.setSize(30);
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        errorjPanel.add((Component)this.inErrorDigitalSwitch, gbc1);
        ++gbc1.gridy;
        errorjPanel.add((Component)this.inErrorjLabel, gbc1);
        ++gbc1.gridy;
        errorjPanel.add((Component)this.standbySensorsErrorjLabel, gbc1);
        ++gbc1.gridy;
        errorjPanel.add((Component)this.handoffSensorsErrorjLabel, gbc1);
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.anchor = 10;
        gbc.gridheight = 1;
        this.add((Component)errorjPanel, gbc);
        JPanel paramPanel = new JPanel();
        paramPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 10;
        gbc2.gridwidth = 2;
        this.ctlNameJLabel.setFont(Tools.BIG_FONT);
        paramPanel.add((Component)this.ctlNameJLabel, gbc2);
        ++gbc2.gridy;
        gbc2.anchor = 21;
        gbc2.gridwidth = 1;
        paramPanel.add((Component)new JLabel("<HTML>Position :<BR>(in um)</HTML>"), gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)new JLabel("<HTML>Current : <BR>(in mA) </HTML>"), gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 1;
        gbc2.anchor = 22;
        paramPanel.add((Component)this.actualPositionjLabel, gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)this.currentjLabel, gbc2);
        gbc.gridx = 3;
        gbc.gridy = 2;
        this.add((Component)paramPanel, gbc);
        this.faultCtlPanel = new JPanel();
        String controllerTitle = "Controller";
        this.faultCtlPanel.setBorder(BorderFactory.createTitledBorder(controllerTitle));
        this.faultCtlPanel.setLayout(new GridBagLayout());
        this.faultCtlPanel.setPreferredSize(new Dimension(100, 100));
        this.faultCtlSwitch.setSize(50);
        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = Tools.insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = 10;
        this.faultCtlPanel.add((Component)this.faultCtlSwitch, gbcf);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        this.add((Component)this.faultCtlPanel, gbc);
    }

    private void setDefaultValues() {
        this.standbyDigitalSwitch.setColor(Color.gray);
        this.inTravelDigitalSwitch.setColor(Color.gray);
        this.handoffDigitalSwitch.setColor(Color.gray);
        this.onlineDigitalSwitch.setColor(Color.gray);
        this.faultCtlSwitch.setColor(Color.GRAY);
        this.inErrorDigitalSwitch.setColor(Color.GRAY);
        this.actualPositionjLabel.setText("0");
        this.currentjLabel.setText("0");
        this.inErrorjLabel.setText(NO_ERROR_IN_SENSORS);
        this.ctlNameJLabel.setText("UNKNOWN CTL NAME");
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    public static void main(String[] argv) {
        AutochangerTruckPanel d = new AutochangerTruckPanel("acTruckXminus");
        JFrame frame = new JFrame("Autochanger Truck Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateTruck
    implements Runnable {
        private final StatusDataPublishedByAutochangerTruck s;

        public UpdateTruck(StatusDataPublishedByAutochangerTruck status) {
            this.s = status;
        }

        private void updateErrorComponents() {
            if (this.s.isHandoffInError() || this.s.isOnlineInError() || this.s.isStandbyInError()) {
                AutochangerTruckPanel.this.inErrorDigitalSwitch.setColor(Color.RED);
                AutochangerTruckPanel.this.inErrorjLabel.setText(AutochangerTruckPanel.ERROR_IN_SENSORS);
            } else {
                AutochangerTruckPanel.this.inErrorDigitalSwitch.setColor(Tools.greenColor);
                AutochangerTruckPanel.this.inErrorjLabel.setText(AutochangerTruckPanel.NO_ERROR_IN_SENSORS);
            }
            AutochangerTruckPanel.this.handoffSensorsErrorjLabel.setText(this.s.isHandoffInError() ? "<HTML>Handoff sensors<BR>in error</HTML>" : null);
            AutochangerTruckPanel.this.onlineSensorsErrorjLabel.setText(this.s.isOnlineInError() ? "<HTML>Online sensors<BR>in error</HTML>" : null);
            AutochangerTruckPanel.this.standbySensorsErrorjLabel.setText(this.s.isStandbyInError() ? "<HTML>Standby sensors<BR>in error</HTML>" : null);
        }

        @Override
        public void run() {
            AutochangerTruckPanel.this.handoffDigitalSwitch.updateColor(this.s.isHandoffInError(), this.s.getHandoffSensorValue());
            AutochangerTruckPanel.this.onlineDigitalSwitch.updateColor(this.s.isOnlineInError(), this.s.getOnlineSensorValue());
            AutochangerTruckPanel.this.standbyDigitalSwitch.updateColor(this.s.isStandbyInError(), this.s.getStandbySensorValue());
            AutochangerTruckPanel.this.inTravelDigitalSwitch.setColor(!this.s.getHandoffSensorValue() && !this.s.getOnlineSensorValue() && !this.s.getStandbySensorValue() ? Color.YELLOW : Color.gray);
            this.updateErrorComponents();
            AutochangerTruckPanel.this.positionProgressBar.setValue(this.s.getPosition());
            AutochangerTruckPanel.this.positionProgressBar.setForeground(Color.PINK);
            AutochangerTruckPanel.this.actualPositionjLabel.setText(Integer.toString(this.s.getPosition()));
            AutochangerTruckPanel.this.ctlNameJLabel.setText(this.s.getControllerName());
            AutochangerTruckPanel.this.currentjLabel.setText(Integer.toString(this.s.getCurrent()));
            AutochangerTruckPanel.this.faultCtlSwitch.setColor(this.s.isControllerInFault() ? Color.RED : Tools.greenColor);
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map configForName = this.configInfo.getCurrentValuesFor(AutochangerTruckPanel.this.truckName);
            FCSCst.FCSLOG.fine((Object)(AutochangerTruckPanel.this.truckName + " configForName=" + configForName));
        }
    }
}

