/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.lsst.ccs.localdb.configdb.model.ConfigurationRun;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.GlobalConfiguration;
import org.lsst.ccs.localdb.statusdb.model.StatusMessageData;

@Entity
@Table(indexes={@Index(columnList="time")})
public class ConfigurationInfoData
extends StatusMessageData {
    private static final long serialVersionUID = -2820317181512754760L;
    private Description description;
    private Map<String, ConfigurationRun> configurationRuns = new HashMap<String, ConfigurationRun>();

    @ManyToOne
    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description desc) {
        this.description = desc;
    }

    @ManyToMany(fetch=FetchType.EAGER)
    public Map<String, ConfigurationRun> getConfigurationRuns() {
        return this.configurationRuns;
    }

    public void setConfigurationRuns(Map<String, ConfigurationRun> runs) {
        this.configurationRuns.putAll(runs);
    }

    @Transient
    public String getConfigurationDescriptionString() {
        StringBuilder sb = new StringBuilder(this.description.getAgentDesc().getAgentName());
        GlobalConfiguration globalConfiguration = null;
        for (ConfigurationRun cr : this.configurationRuns.values()) {
            if (cr.getGlobalConfiguration() == null) break;
            if (globalConfiguration != null) {
                if (globalConfiguration.getId() == cr.getGlobalConfiguration().getId()) continue;
                break;
            }
            globalConfiguration = cr.getGlobalConfiguration();
        }
        if (globalConfiguration != null) {
            sb.append("[").append(globalConfiguration.getName()).append("(").append(globalConfiguration.getVersion()).append(")").append("]");
        }
        sb.append("[");
        TreeMap<String, ConfigurationRun> orderedMap = new TreeMap<String, ConfigurationRun>(this.configurationRuns);
        for (Map.Entry e : orderedMap.entrySet()) {
            sb.append(((ConfigurationRun)e.getValue()).getConfigurationDescriptionString()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1).append("]");
        return sb.toString();
    }
}

