/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * A panel which contains a ProgressBar, a value, a minimun value and a maximum
 * value.
 *
 * @author virieux
 */
public class VerticalProgressBarPanel extends JPanel {
    private static final long serialVersionUID = -2994272988748620616L;

    // Variables declaration
    public int value = 0;
    public int maxValue = 10000;
    public int minValue = -2000;
    public String valueName = "Value";
    public Color color = Color.BLUE;
    private int orientation;

    private JLabel valueLabel;
    private JLabel valueNameLabel;
    private JLabel maxValueLabel;
    private JLabel maxValueNameLabel;
    private JLabel minValueLabel;
    private JLabel minValueNameLabel;
    private JProgressBar jProgressBar;
    // End of variables declaration

    /**
     * Create a new form *
     */
    public VerticalProgressBarPanel() {
        initComponents();
    }

    public VerticalProgressBarPanel(String valueName, int minValue, int maxValue, int value, int orientation) {
        this.value = value;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.valueName = valueName;
        this.orientation = orientation;
        initComponents();
    }

    public void setColor(Color c) {
        this.color = c;
        this.jProgressBar.setForeground(c);
    }

    public void setValue(int value) {
        this.value = value;
        this.jProgressBar.setValue(value);
        this.valueLabel.setText(Integer.toString(value));
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        this.jProgressBar.setMaximum(maxValue);
        this.maxValueLabel.setText(Integer.toString(maxValue));
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
        this.jProgressBar.setMinimum(minValue);
        this.minValueLabel.setText(Integer.toString(minValue));
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public void setStringPainted(boolean b) {
        this.jProgressBar.setStringPainted(b);
    }

    private void initComponents() {
        valueNameLabel = new JLabel(valueName);
        valueLabel = new JLabel(Integer.toString(value));
        maxValueLabel = new JLabel(Integer.toString(maxValue));
        minValueLabel = new JLabel(Integer.toString(minValue));
        maxValueNameLabel = new JLabel("Max " + valueName);
        minValueNameLabel = new JLabel("Min " + valueName);
        valueNameLabel.setFont(BIG_FONT);
        minValueNameLabel.setFont(BIG_FONT);
        maxValueNameLabel.setFont(BIG_FONT);

        jProgressBar = new javax.swing.JProgressBar();
        jProgressBar.setBackground(new java.awt.Color(255, 0, 153));
        jProgressBar.setForeground(new java.awt.Color(255, 0, 204));
        jProgressBar.setMinimum(minValue);
        jProgressBar.setMaximum(maxValue);
        jProgressBar.setValue(value);
        //jProgressBar.setOrientation(1);
        jProgressBar.setOrientation(orientation);
        jProgressBar.setStringPainted(true);

        setBorder(javax.swing.BorderFactory.createEtchedBorder());
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = java.awt.GridBagConstraints.CENTER;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        add(valueNameLabel, gbc);
        gbc.gridy++;
        add(valueLabel, gbc);
        gbc.gridy++;
        add(jProgressBar, gbc);
        gbc.gridy++;
        gbc.gridwidth = 1;
        add(minValueNameLabel, gbc);
        gbc.gridy++;
        add(maxValueNameLabel, gbc);
        gbc.anchor = java.awt.GridBagConstraints.EAST;
        gbc.gridx++;
        gbc.gridy--;
        add(minValueLabel, gbc);
        gbc.gridy++;
        add(maxValueLabel, gbc);
    }

    public static void main(String[] argv) {

        VerticalProgressBarPanel p = new VerticalProgressBarPanel("Position", 0, 5000, 500, 0);
        //VerticalProgressBarPanel p = new VerticalProgressBarPanel();
        JFrame frame = new JFrame("Vertical Progress Bar Panel");
        p.setColor(Color.red);
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
