
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import static org.lsst.ccs.subsystems.fcs.FCSCst.UNKNOWN;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.ColoredObject;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.ZERO_VALUE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * A Panel to represent an analogic sensor like those are used for Carousel clamps.
 * @author virieux
 */
public class AnalogicSensorPanel extends JPanel {
    private static final long serialVersionUID = -1531790094506697510L;

    String clampName = "clampName";
    String sensorName = "sensorName";
    private final int orientation;
    private JLabel nameLabel;
    private JLabel stateLabel;
    private JLabel valueLabel;
    private JProgressBar progressBar;
    private DigitalSwitch sensorSwitch;
    protected JPanel paramsPanel;

    final JLabel valueALabel = new JLabel(ZERO_VALUE);
    final JLabel valueBLabel = new JLabel(ZERO_VALUE);
    final JLabel offset3Label = new JLabel(ZERO_VALUE);

    final JLabel minLockValueLabel = new JLabel(ZERO_VALUE);
    final JLabel maxLockValueLabel = new JLabel(ZERO_VALUE);

    public AnalogicSensorPanel(String clampName, String sensorName, int orientation) {
        this.clampName = clampName;
        this.sensorName = sensorName;
        this.orientation = orientation;
        initComponents();
    }

    /**
     * Initialize the GUI with the configuration data.
     *
     * @param configInfo
     */
    public void initializeGui(ConfigurationInfo configInfo) {
        Map<String, String> config = configInfo.getCurrentValuesFor(clampName);
        String[] words = sensorName.split("X");
        minLockValueLabel.setText(config.get(words[0] + "MinValue"));
        valueALabel.setText(config.get(words[0] + "ValueA"));
        valueBLabel.setText(config.get(words[0] + "ValueB"));
        maxLockValueLabel.setText(config.get(words[0] + "MaxValue"));
    }

    /**
     * Update this panel from a value and a sensorStatus.
     * @param value
     * @param sensorStatus
     */
    protected void update(int value, ColoredObject sensorStatus) {
        progressBar.setValue(value);
        valueLabel.setText(Integer.toString(value));
        Color lockSensorColor = sensorStatus.getColor();
        //progressBar.setValueAndColor(value, lockSensorColor);
        sensorSwitch.setColor(lockSensorColor);
        stateLabel.setText(sensorStatus.toString());
        stateLabel.setForeground(lockSensorColor);
    }


    protected void initParamsPanel() {
        /**
         ******************************************************************************
         ** Lock Sensor Parameters Panels
         * *****************************************************************************
         */
        paramsPanel = new JPanel();
        paramsPanel.setBorder(BorderFactory.createLineBorder(Color.blue));
        paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;

        /*first columm*/
        gbcp.anchor = GridBagConstraints.LINE_START;
        paramsPanel.add(new JLabel("minValue:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("Value A:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("Value B:"), gbcp);
        gbcp.gridy++;
        paramsPanel.add(new JLabel("maxValue:"), gbcp);

        /*second columm*/
        gbcp.gridx++;
        gbcp.anchor = GridBagConstraints.LINE_END;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        paramsPanel.add(minLockValueLabel, gbcp);
        gbcp.gridy++;
        paramsPanel.add(valueALabel, gbcp);
        gbcp.gridy++;
        paramsPanel.add(valueBLabel, gbcp);
        gbcp.gridy++;
        paramsPanel.add(maxLockValueLabel, gbcp);
        /**
         ******************************************************************************
         ** end of General Parameters Panels
         * *****************************************************************************
         */
    }

    // <editor-fold defaultstate="collapsed" desc="Form description">
    private void initComponents() {
        progressBar = new JProgressBar(orientation);
        sensorSwitch = new DigitalSwitch();
        sensorSwitch.setColor(Color.gray);
        stateLabel = new JLabel(UNKNOWN);
        nameLabel = new JLabel(sensorName);
        valueLabel = new JLabel(ZERO_VALUE);

        initParamsPanel();

        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.gridx=0;
        gbc.gridy=0;
        add(valueLabel, gbc);
        gbc.gridy++;
        add(progressBar,gbc);
        gbc.gridy++;
        add(sensorSwitch,gbc);
        gbc.gridy++;
        add(stateLabel,gbc);
        gbc.gridy++;
        add(nameLabel,gbc);
        gbc.gridy++;
        add(paramsPanel,gbc);
        /**
         ******************************************************************************
         ** end Whole Panel
         * *****************************************************************************
         */
    }

    /**
     * Reset panel to default values when subsystem is shutdown for example.
     */
    public void resetPanel() {
        progressBar.setValue(0);
        valueLabel.setText(ZERO_VALUE);
        sensorSwitch.setColor(Color.gray);
        stateLabel.setText(UNKNOWN_STATE);
        stateLabel.setForeground(Color.gray);
        valueALabel.setText(ZERO_VALUE);
        valueBLabel.setText(ZERO_VALUE);
        maxLockValueLabel.setText(ZERO_VALUE);
        minLockValueLabel.setText(ZERO_VALUE);
        offset3Label.setText(ZERO_VALUE);
    }

    /**
     * Just to test the Panel.
     * @param argv
     */
    public static void main(String[] argv) {

        AnalogicSensorPanel d = new AnalogicSensorPanel("clampToto", "leBoCapteur", 0);
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
}
