/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AttributeSelector;
import org.lsst.ccs.gconsole.services.aggregator.PathPattern;

public interface ChannelSelector {
    public static final Pattern pRegEx = Pattern.compile("[/+.*?(){}|\\\\]");
    public static final ChannelSelector ALL = new ChannelSelector(){

        @Override
        public String getAgent() {
            return null;
        }

        @Override
        public boolean match(AgentChannel channel) {
            return true;
        }
    };

    public static ChannelSelector compile(String rawSelector) {
        if (pRegEx.matcher(rawSelector).find()) {
            return PathPattern.compile(rawSelector);
        }
        return AttributeSelector.compile(rawSelector);
    }

    public static List<ChannelSelector> compile(Collection<String> rawSelectors) {
        return rawSelectors == null ? null : rawSelectors.stream().map(cs -> ChannelSelector.compile(cs)).filter(s -> s != null).collect(Collectors.toList());
    }

    public static boolean accept(List<String> agents, List<ChannelSelector> channelSelectors, AgentChannel channel) {
        boolean watchAgent;
        String agentName = channel.getAgentName();
        boolean bl = watchAgent = agents == null || agents.contains(agentName);
        if (channelSelectors == null) {
            return watchAgent;
        }
        for (ChannelSelector s : channelSelectors) {
            if (!watchAgent && !agentName.equals(s.getAgent())) continue;
            return s.match(channel);
        }
        return false;
    }

    public static <T extends AgentChannel> List<T> filter(List<String> agents, List<ChannelSelector> channelSelectors, Collection<T> channels) {
        return channels.stream().filter(ch -> ChannelSelector.accept(agents, channelSelectors, ch)).collect(Collectors.toList());
    }

    public static <T extends AgentChannel> List<T> filter(List<String> agents, List<ChannelSelector> channelSelectors, Collection<T> channels, List<T> out) {
        if (out == null) {
            out = new ArrayList<T>();
        }
        if (!channels.isEmpty()) {
            boolean watchedAgent;
            String agentName = ((AgentChannel)channels.iterator().next()).getAgentName();
            boolean bl = watchedAgent = agents == null || agents.contains(agentName);
            if (channelSelectors == null) {
                if (watchedAgent) {
                    out.addAll(channels);
                }
            } else {
                block0: for (AgentChannel ch : channels) {
                    for (ChannelSelector s : channelSelectors) {
                        if (!watchedAgent && !agentName.equals(s.getAgent()) || !s.match(ch)) continue;
                        out.add(ch);
                        continue block0;
                    }
                }
            }
        }
        return out;
    }

    public String getAgent();

    public boolean match(AgentChannel var1);
}

