/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

public interface InterfaceLoaderGUI
extends InterfaceGeneralGUI {
    public static final String loaderClampName = "clamp";
    public static final String loaderCarrierName = "carrier";

    public long getLoGoToHandoffTimeout();

    public long getLoGoToStorageTimeout();

    public long getLoGoToEngagedTimeout();

    public long getOpenHooksTimeout();

    public long getCloseHooksTimeout();

    public long getClampHooksTimeout();

    public void setLoGoToHandoffTimeout(int var1);

    public void setLoGoToStorageTimeout(int var1);

    public void setLoGoToEngagedTimeout(int var1);

    public void setClampHooksTimeout(long var1);

    public void setCloseHooksTimeout(long var1);

    public void setOpenHooksTimeout(long var1);

    default public void loLoadFilter() {
        System.out.println("loadFilterInCamera with timeout=" + this.getLoGoToHandoffTimeout());
        FCSCst.FCSLOG.info((Object)"Loading filter in camera");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getLoGoToHandoffTimeout()));
        this.sendCommand("loadFilterInCamera", this.getLoGoToHandoffTimeout());
    }

    default public void loUnloadFilter() {
        System.out.println("unloadFilterFromCamera with timeout=" + this.getLoGoToHandoffTimeout());
        FCSCst.FCSLOG.info((Object)"Loading filter in camera");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getLoGoToHandoffTimeout()));
        this.sendCommand("unloadFilterFromCamera", this.getLoGoToHandoffTimeout());
    }

    default public void loGoToHandOff() {
        FCSCst.FCSLOG.info((Object)"Carrier going to Handoff Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getLoGoToHandoffTimeout()));
        this.sendCommand("goToHandOff", this.getLoGoToHandoffTimeout(), loaderCarrierName);
    }

    default public void loGoToEngaged() {
        FCSCst.FCSLOG.info((Object)"Carrier going to Engaged Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getLoGoToEngagedTimeout()));
        this.sendCommand("goToEngaged", this.getLoGoToEngagedTimeout(), loaderCarrierName);
    }

    default public void loGoToStorage() {
        FCSCst.FCSLOG.info((Object)"Carrier going to Storage Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getLoGoToStorageTimeout()));
        this.sendCommand("goToStorage", this.getLoGoToStorageTimeout(), loaderCarrierName);
    }

    default public void loUpdateCarrierPosition() {
        System.out.println("updateCarrierPosition with UPDATE_POSITION_TIMEOUT=1000");
        FCSCst.FCSLOG.info((Object)"Updating carrier position");
        FCSCst.FCSLOG.info((Object)"/timeout=1000");
        this.sendCommand("updatePosition", 1000L, loaderCarrierName);
    }

    default public void loClampHooks() {
        FCSCst.FCSLOG.info((Object)"Clamping Hooks");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getClampHooksTimeout()));
        this.sendCommand(loaderClampName, this.getClampHooksTimeout(), loaderClampName);
    }

    default public void loCloseHooks() {
        FCSCst.FCSLOG.info((Object)"Closing Hooks");
        System.out.println("/timeout=" + this.getCloseHooksTimeout());
        this.sendCommand("close", this.getCloseHooksTimeout(), loaderClampName);
    }

    default public void loUnclampHooks() {
        FCSCst.FCSLOG.info((Object)"Unclamping Hooks");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getClampHooksTimeout()));
        this.sendCommand("unclamp", this.getClampHooksTimeout(), loaderClampName);
    }

    default public void loOpenHooks() {
        FCSCst.FCSLOG.info((Object)"Opening Hooks");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getOpenHooksTimeout()));
        this.sendCommand("open", this.getOpenHooksTimeout(), loaderClampName);
    }

    default public void loClampHoming() {
        FCSCst.FCSLOG.info((Object)"Clamp homing");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.getOpenHooksTimeout()));
        this.sendCommand("homing", this.getOpenHooksTimeout(), loaderClampName);
    }
}

