
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class FcsGeneralViewPanel extends JPanel {
    private static final long serialVersionUID = 1L;
    
    private final String title = "FCS OVERVIEW";
    
    private JPanel autochangerPanel;
    private JPanel carouselPanel;
    private JPanel loaderPanel;
    
    /*autochanger information*/
    private final JLabel filterONLINELabel = new JLabel("NONE");
    private final JLabel onlineClampsStateLabel = new JLabel("UNKNOWN");
    private final JLabel latchesStateLabel = new JLabel("UNKNOWN");
    private final JLabel truksPositionLabel = new JLabel("UNKNOWN");

    public FcsGeneralViewPanel() {
        initComponents();
    }
    
    

    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {
        
        /**
         ******************************************************************************
         ** Autochanger Panel
         * *****************************************************************************
         */
        autochangerPanel = new JPanel();
        autochangerPanel.setBorder(BorderFactory.createTitledBorder("autochanger"));
        autochangerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;
        //first colomn
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = GridBagConstraints.LINE_START;
        autochangerPanel.add(new JLabel("Filter ONLINE: "),gbc1);
        gbc1.gridy++;
        autochangerPanel.add(new JLabel("ONLINE clamps state: "),gbc1); 
        gbc1.gridy++;
        autochangerPanel.add(new JLabel("Latches state: "),gbc1);        
        gbc1.gridy++;
        autochangerPanel.add(new JLabel("Trucks Position: "),gbc1); 
        //second colomn
        gbc1.gridx++;
        gbc1.gridy = 0;
        gbc1.anchor = GridBagConstraints.LINE_END;
        autochangerPanel.add(filterONLINELabel, gbc1);
        gbc1.gridy++;
        autochangerPanel.add(onlineClampsStateLabel, gbc1);
        gbc1.gridy++;
        autochangerPanel.add(latchesStateLabel, gbc1);        
        gbc1.gridy++;
        autochangerPanel.add(truksPositionLabel, gbc1);        
         /**
         ******************************************************************************
         ** Carousel Panel
         * *****************************************************************************
         */
        carouselPanel = new JPanel();
        carouselPanel.setBorder(BorderFactory.createTitledBorder("carousel"));    
        
         /**
         ******************************************************************************
         ** Loader Panel
         * *****************************************************************************
         */
        loaderPanel = new JPanel();
        loaderPanel.setBorder(BorderFactory.createTitledBorder("loader"));         
        
        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        /*General Information Panel*/
        setBorder(BorderFactory.createTitledBorder(title));
        setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.NORTHWEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(autochangerPanel, gbc); 
        
        gbc.gridx++;
        add(carouselPanel);
        
        gbc.gridx++;
        add(loaderPanel);
        /**
         ******************************************************************************
         ** end of Whole Panel
         * *****************************************************************************
         */    
    }
    
    @Override
    public String toString() {
        return title;
    }    
    
}
