package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.awt.*;
import java.awt.geom.*;
//import java.util.Random;
import java.security.SecureRandom;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class AnalogMeter extends JPanel {
    private static final long serialVersionUID = -7901080249812120527L;

    int radius = 100;
    int insets = 30;
    Color backgroundColor = new Color(212, 208, 200);
    Color fillColor = new Color(204, 205, 255);

    int minValue = 0, maxValue = 100;
    int value = 0;

    static SecureRandom r = new SecureRandom();

    public AnalogMeter() {
        setPreferredSize(new Dimension(radius + 2 * insets, radius / 2 + (int) (1.5 * insets)));
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        backgroundColor = bg;
        repaint();
    }

    public void setValue(int value) {
        this.value = value;
        repaint();
    }

    public void setLimits(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);

        g2.setColor(fillColor);
        g2.fillArc(insets, insets, radius, radius, 0, 180);

//        g2.setColor(Color.green);
//        g2.fillArc(insets, insets, radius, radius, 0, 43);
        g2.setColor(backgroundColor);
        g2.fillArc(insets + radius / 4, insets + radius / 4, radius / 2, radius / 2, 0, 180);

        g2.setColor(Color.black);
        g2.drawArc(insets, insets, radius, radius, 0, 180);
        g2.drawArc(insets + radius / 4, insets + radius / 4, radius / 2, radius / 2, 0, 180);
        g2.drawLine(insets, insets + radius / 2, insets + radius / 4, insets + radius / 2);
        g2.drawLine(insets + radius * 3 / 4, insets + radius / 2, insets + radius, insets + radius / 2);

        Point center = new Point(insets + radius / 2, insets + radius / 2);
        Point tip = new Point(insets + radius - 1, insets + radius / 2);

        double rotationAngle = 0;
        if (value <= minValue) {
            rotationAngle = 180;
        } else {
            int span = Math.abs(maxValue - minValue);
            int v = value - minValue;
            rotationAngle = 180d - v * 180d / span;
        }

        g2.rotate(-rotationAngle * Math.PI / 180d, insets + radius / 2d, insets + radius / 2d);

        g2.draw(new Line2D.Double(center, tip));
        int[] x = new int[]{insets + radius, insets + radius - 8, insets + radius - 8};
        int[] y = new int[]{insets + radius / 2, insets + radius / 2 + 4, insets + radius / 2 - 4};

        g2.fillPolygon(x, y, 3);

        g2.rotate(rotationAngle * Math.PI / 180d, insets + radius / 2d, insets + radius / 2d);

        int count = 0;
        for (int i = 15; i < 175; i += 15) {
            count++;

            int lenght = count % 3 == 0 ? 7 : 3;
            Point start = new Point(insets + radius - lenght, insets + radius / 2);
            Point end = new Point(insets + radius - 1, insets + radius / 2);

            g2.rotate(-i * Math.PI / 180d, insets + radius / 2d, insets + radius / 2d);
            g2.draw(new Line2D.Double(start, end));
            g2.rotate(i * Math.PI / 180d, insets + radius / 2d, insets + radius / 2d);
        }

        g2.setFont(new Font("system", Font.BOLD, 15));

        String valueStr = String.valueOf(value);

        int middleX = insets + radius / 2;
        Rectangle2D bounds = g2.getFontMetrics().getStringBounds(valueStr, g2);

        g2.drawString(valueStr, (int) (middleX - bounds.getWidth() / 3), (int) (insets - 3));

        g2.setFont(new Font("system", Font.BOLD, 10));
        valueStr = String.valueOf(minValue);
        bounds = g2.getFontMetrics().getStringBounds(valueStr, g2);
        g2.drawString(valueStr, (int) (insets - bounds.getWidth() - 4), (int) (insets + radius / 2 + bounds.getHeight() / 4));

        valueStr = String.valueOf(maxValue);
        bounds = g2.getFontMetrics().getStringBounds(valueStr, g2);
        g2.drawString(valueStr, (int) (insets + radius + 4), (int) (insets + radius / 2 + bounds.getHeight() / 4));

    }

    public static void main(String[] argv) {

        AnalogMeter d = new AnalogMeter();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
}
