/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderHookPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalProgressBarPanel;

public class LoaderClampPanel
extends JPanel {
    private static final long serialVersionUID = -6313746913674371727L;
    private final String clampName;
    private InterfaceLoaderGUI subs;
    private final JLabel clampState = new JLabel();
    private final JLabel clampStateLabel = new JLabel("Clamp State :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinuxLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private final DecimalFormat formatter = new DecimalFormat("000.000");
    private final JLabel forceSensor0Label = new JLabel();
    private final JLabel forceSensor1Label = new JLabel();
    private final JLabel fs0Label = new JLabel("ForceSensor0 voltage (in mV):");
    private final JLabel fs1Label = new JLabel("ForceSensor1 voltage (in mV):");
    private final DigitalSwitch forceClampedStatusSwitch = new DigitalSwitch();
    private final DigitalSwitch forceUnclampedStatusSwitch = new DigitalSwitch();
    private final DigitalSwitch forceUnderClampedStatusSwitch = new DigitalSwitch();
    private final DigitalSwitch forceOverClampedStatusSwitch = new DigitalSwitch();
    private final JLabel forceStatusLabel = new JLabel();
    private final JPanel homingPanel = new JPanel();
    private final JLabel homLabel = new JLabel("Homing of the clamp controller:");
    private final JLabel homingLabel = new JLabel();
    private LoaderHookPanel hookPanel1;
    private LoaderHookPanel hookPanel2;
    private LoaderHookPanel hookPanel3;
    private LoaderHookPanel hookPanel4;
    private final JPanel forceSensorPanel = new JPanel();
    private final FilterPanel filterPanel = new FilterPanel();
    private VerticalProgressBarPanel positionProgressBarPanel;
    private VerticalProgressBarPanel currentProgressBarPanel;
    private JButton closeHooksButton;
    private JButton openHooksButton;
    private JButton unclampHooksPositionButton;
    private JButton clampHooksButton;
    private JButton updateStateWithSensorsButton;
    private JButton abortButton;

    public LoaderClampPanel(String clampName) {
        this.clampName = clampName;
        this.initComponents();
    }

    public void setSubsystem(InterfaceLoaderGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateClamp(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateFilterPanel(status));
    }

    private void initComponents() {
        Font xFont = new Font("Tahoma", 1, 18);
        this.xMinusLabel.setFont(xFont);
        this.xMinuxLabel2.setFont(xFont);
        this.xPlusLabel2.setFont(xFont);
        this.xPlusLabel.setFont(xFont);
        JPanel hooksPanel = new JPanel();
        JPanel clampStatePanel = new JPanel();
        JPanel controlPanel = new JPanel();
        this.hookPanel1 = new LoaderHookPanel("hook1");
        this.hookPanel2 = new LoaderHookPanel("hook2");
        this.hookPanel3 = new LoaderHookPanel("hook3");
        this.hookPanel4 = new LoaderHookPanel("hook4");
        this.currentProgressBarPanel = new VerticalProgressBarPanel("Current", -300, 500, 0, 1);
        this.currentProgressBarPanel.setStringPainted(false);
        this.positionProgressBarPanel = new VerticalProgressBarPanel("Position", 5000, 480000, 0, 1);
        this.updateStateWithSensorsButton = new JButton("Read sensors and update state");
        this.openHooksButton = new JButton("Open");
        this.clampHooksButton = new JButton("Clamp");
        this.closeHooksButton = new JButton("Close");
        this.unclampHooksPositionButton = new JButton("Unclamp");
        this.abortButton = new JButton("Abort");
        this.updateStateWithSensorsButton.addActionListener(evt -> this.updateStateWithSensorsButtonActionPerformed(evt));
        this.openHooksButton.addActionListener(evt -> this.openHooksButtonActionPerformed(evt));
        this.clampHooksButton.addActionListener(evt -> this.clampHooksButtonActionPerformed(evt));
        this.closeHooksButton.addActionListener(evt -> this.closeHooksButtonActionPerformed(evt));
        this.unclampHooksPositionButton.addActionListener(evt -> this.unclampHooksButtonActionPerformed(evt));
        this.abortButton.addActionListener(evt -> this.abortActionPerformed(evt));
        this.clampState.setFont(Tools.BIG_FONT);
        this.clampState.setBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(255, 255, 255)));
        clampStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        clampStatePanel.add((Component)this.clampStateLabel, gbc2);
        ++gbc2.gridx;
        clampStatePanel.add((Component)this.clampState, gbc2);
        this.forceSensorPanel.setLayout(new GridBagLayout());
        this.forceSensorPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 1), "Force Sensors"));
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.insets = Tools.insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        gbc4.anchor = 21;
        this.forceSensorPanel.add((Component)this.fs0Label, gbc4);
        ++gbc4.gridx;
        gbc4.anchor = 22;
        this.forceSensor0Label.setFont(Tools.BIG_FONT);
        this.forceSensorPanel.add((Component)this.forceSensor0Label, gbc4);
        gbc4.gridx = 0;
        gbc4.gridy = 1;
        gbc4.anchor = 21;
        this.forceSensorPanel.add((Component)this.fs1Label, gbc4);
        ++gbc4.gridx;
        gbc4.anchor = 22;
        this.forceSensor1Label.setFont(Tools.BIG_FONT);
        this.forceSensorPanel.add((Component)this.forceSensor1Label, gbc4);
        gbc4.gridx = 4;
        gbc4.gridy = 0;
        gbc4.anchor = 10;
        gbc4.insets = new Insets(1, 12, 1, 1);
        this.forceSensorPanel.add((Component)this.forceUnclampedStatusSwitch, gbc4);
        ++gbc4.gridy;
        this.forceSensorPanel.add((Component)new JLabel("<HTML><CENTER>Unclamped<br>Status</CENTER></HTML>"), gbc4);
        ++gbc4.gridx;
        gbc4.gridy = 0;
        this.forceSensorPanel.add((Component)this.forceUnderClampedStatusSwitch, gbc4);
        ++gbc4.gridy;
        this.forceSensorPanel.add((Component)new JLabel("<HTML><CENTER>UnderClamped<br>Status</CENTER></HTML>"), gbc4);
        ++gbc4.gridx;
        gbc4.gridy = 0;
        this.forceSensorPanel.add((Component)this.forceClampedStatusSwitch, gbc4);
        ++gbc4.gridy;
        this.forceSensorPanel.add((Component)new JLabel("<HTML><CENTER>Clamped<br>Status</CENTER></HTML>"), gbc4);
        ++gbc4.gridx;
        gbc4.gridy = 0;
        this.forceSensorPanel.add((Component)this.forceOverClampedStatusSwitch, gbc4);
        ++gbc4.gridy;
        this.forceSensorPanel.add((Component)new JLabel("<HTML><CENTER>OverClamped<br>Status</CENTER></HTML>"), gbc4);
        ++gbc4.gridx;
        gbc4.gridy = 0;
        this.forceSensorPanel.add((Component)new JLabel("Force Status"), gbc4);
        ++gbc4.gridy;
        this.forceSensorPanel.add((Component)this.forceStatusLabel, gbc4);
        this.forceStatusLabel.setFont(Tools.BIG_FONT);
        this.homingPanel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 2));
        this.homingPanel.setLayout(new GridBagLayout());
        this.homingLabel.setFont(Tools.BIG_FONT);
        GridBagConstraints gbc6 = new GridBagConstraints();
        gbc6.insets = Tools.insets_big;
        gbc6.gridx = 0;
        gbc6.gridy = 0;
        this.homingLabel.setFont(Tools.BIG_FONT);
        this.homingPanel.add((Component)this.homLabel, gbc6);
        ++gbc6.gridx;
        this.homingPanel.add((Component)this.homingLabel, gbc6);
        hooksPanel.setLayout(new GridBagLayout());
        hooksPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE), "Hooks State"));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        this.hookPanel2.setHookLocation(0);
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        hooksPanel.add((Component)this.hookPanel2, gbc1);
        this.hookPanel1.setHookLocation(0);
        ++gbc1.gridx;
        hooksPanel.add((Component)this.hookPanel1, gbc1);
        this.hookPanel3.setHookLocation(0);
        gbc1.gridx = 0;
        gbc1.gridy = 1;
        hooksPanel.add((Component)this.hookPanel3, gbc1);
        this.hookPanel4.setHookLocation(0);
        ++gbc1.gridx;
        hooksPanel.add((Component)this.hookPanel4, gbc1);
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = 23;
        gbc3.fill = 2;
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add((Component)this.updateStateWithSensorsButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.openHooksButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.closeHooksButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.clampHooksButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.unclampHooksPositionButton, gbc3);
        ++gbc3.gridy;
        controlPanel.add((Component)this.abortButton, gbc3);
        this.setBorder(BorderFactory.createTitledBorder("LOADER CLAMP"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.add((Component)this.homingPanel, gbc);
        ++gbc.gridy;
        gbc.anchor = 17;
        this.add((Component)this.xMinusLabel, gbc);
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.gridx = 3;
        this.add((Component)this.xPlusLabel, gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.anchor = 10;
        this.add((Component)clampStatePanel, gbc);
        gbc.anchor = 17;
        ++gbc.gridy;
        this.add((Component)hooksPanel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 4;
        this.add((Component)this.forceSensorPanel, gbc);
        gbc.insets = new Insets(14, 30, 6, 30);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.positionProgressBarPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.currentProgressBarPanel, gbc);
        ++gbc.gridx;
        gbc.anchor = 10;
        this.add((Component)this.filterPanel, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        this.add((Component)controlPanel, gbc);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.filterPanel.setColor(Color.gray);
        this.clampState.setText("UNKNOWN STATE");
        this.forceSensor0Label.setText(Integer.toString(9999));
        this.forceSensor1Label.setText(Integer.toString(9999));
        this.forceClampedStatusSwitch.setColor(Color.gray);
        this.forceUnclampedStatusSwitch.setColor(Color.gray);
        this.forceUnderClampedStatusSwitch.setColor(Color.gray);
        this.forceOverClampedStatusSwitch.setColor(Color.gray);
        this.forceStatusLabel.setText("UNKNOWN");
        this.homingLabel.setText("TO BE DONE");
        this.homingLabel.setForeground(Color.red);
        this.positionProgressBarPanel.setValue(0);
        this.positionProgressBarPanel.setColor(Color.gray);
        this.currentProgressBarPanel.setValue(0);
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.hookPanel1.resetPanel();
        this.hookPanel2.resetPanel();
        this.hookPanel3.resetPanel();
        this.hookPanel4.resetPanel();
    }

    private void updateStateWithSensorsButtonActionPerformed(ActionEvent evt) {
        this.subs.updateStateWithSensors();
    }

    private void openHooksButtonActionPerformed(ActionEvent evt) {
        this.subs.loOpenHooks();
    }

    private void closeHooksButtonActionPerformed(ActionEvent evt) {
        this.subs.loCloseHooks();
    }

    private void clampHooksButtonActionPerformed(ActionEvent evt) {
        this.subs.loClampHooks();
    }

    private void unclampHooksButtonActionPerformed(ActionEvent evt) {
        this.subs.loUnclampHooks();
    }

    private void abortActionPerformed(ActionEvent evt) {
        this.subs.abortAction();
    }

    @Override
    public String toString() {
        return "Clamp Panel";
    }

    public static void main(String[] argv) {
        LoaderClampPanel d = new LoaderClampPanel("myClamp");
        JFrame frame = new JFrame("New Loader Clamp Panel");
        d.currentProgressBarPanel.setValueName("Current");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateFilterPanel
    implements Runnable {
        private final StatusDataPublishedByLoader s;

        public UpdateFilterPanel(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isFilterPresenceSensorsInError()) {
                LoaderClampPanel.this.filterPanel.setColor(Color.red);
            } else {
                LoaderClampPanel.this.filterPanel.setIsFilterInHouse(this.s.getFilterPresenceSensorValue(), "dummyFilter");
            }
        }
    }

    private class UpdateClamp
    implements Runnable {
        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            Color clampStateColor = this.s.getClampState().getColor();
            int clampPosition = this.s.getPosition();
            LoaderClampPanel.this.clampState.setText(this.s.getClampState().getText());
            LoaderClampPanel.this.clampState.setForeground(clampStateColor);
            LoaderClampPanel.this.positionProgressBarPanel.setValue(clampPosition);
            LoaderClampPanel.this.positionProgressBarPanel.setColor(clampStateColor);
            LoaderClampPanel.this.currentProgressBarPanel.setValue(this.s.getCurrent());
            LoaderClampPanel.this.hookPanel1.updateHook(this.s.getStatusPublishedByHook1());
            LoaderClampPanel.this.hookPanel2.updateHook(this.s.getStatusPublishedByHook2());
            LoaderClampPanel.this.hookPanel3.updateHook(this.s.getStatusPublishedByHook3());
            LoaderClampPanel.this.hookPanel4.updateHook(this.s.getStatusPublishedByHook4());
            LoaderClampPanel.this.forceSensor0Label.setText(LoaderClampPanel.this.formatter.format(this.s.getForceSensorVoltage0()));
            LoaderClampPanel.this.forceSensor1Label.setText(LoaderClampPanel.this.formatter.format(this.s.getForceSensorVoltage1()));
            LoaderClampPanel.this.forceStatusLabel.setText(this.s.getForceStatus().toString());
            if (this.s.isForceClampedStatus()) {
                LoaderClampPanel.this.forceClampedStatusSwitch.setColor(Tools.greenColor);
            } else {
                LoaderClampPanel.this.forceClampedStatusSwitch.setColor(Color.GRAY);
            }
            if (this.s.isForceUnclampedStatus()) {
                LoaderClampPanel.this.forceUnclampedStatusSwitch.setColor(Tools.greenColor);
            } else {
                LoaderClampPanel.this.forceUnclampedStatusSwitch.setColor(Color.GRAY);
            }
            if (this.s.isForceOverClampedStatus()) {
                LoaderClampPanel.this.forceOverClampedStatusSwitch.setColor(Color.RED);
            } else {
                LoaderClampPanel.this.forceOverClampedStatusSwitch.setColor(Color.GRAY);
            }
            if (this.s.isForceUnderClampedStatus()) {
                LoaderClampPanel.this.forceUnderClampedStatusSwitch.setColor(Color.ORANGE);
            } else {
                LoaderClampPanel.this.forceUnderClampedStatusSwitch.setColor(Color.GRAY);
            }
            if (this.s.isHomingDone()) {
                LoaderClampPanel.this.homingLabel.setText("DONE");
                LoaderClampPanel.this.homingLabel.setForeground(Tools.greenColor);
            } else {
                LoaderClampPanel.this.homingLabel.setText("NOT DONE");
                LoaderClampPanel.this.homingLabel.setForeground(Color.red);
            }
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map configForClamp = this.configInfo.getCurrentValuesFor(LoaderClampPanel.this.clampName);
            LoaderClampPanel.this.positionProgressBarPanel.setMinValue(Tools.toInt(configForClamp, "targetPositionToOpen"));
            LoaderClampPanel.this.positionProgressBarPanel.setMaxValue(Tools.toInt(configForClamp, "absolutePositionToClose"));
            LoaderClampPanel.this.positionProgressBarPanel.setValue(0);
            LoaderClampPanel.this.currentProgressBarPanel.setMinValue(Tools.toInt(configForClamp, "currentToOpen"));
            LoaderClampPanel.this.currentProgressBarPanel.setMaxValue(Tools.toInt(configForClamp, "currentToClamp"));
            LoaderClampPanel.this.currentProgressBarPanel.setValue(0);
            LoaderClampPanel.this.subs.setOpenHooksTimeout(Tools.toInt(configForClamp, "timeoutForOpeningHooks"));
            LoaderClampPanel.this.subs.setCloseHooksTimeout(Tools.toInt(configForClamp, "timeoutForClosingHooks"));
            LoaderClampPanel.this.subs.setClampHooksTimeout(Tools.toInt(configForClamp, "timeoutForClampingHooks"));
            LoaderClampPanel.this.subs.setHomingHooksTimeout(Tools.toInt(configForClamp, "timeoutForOpeningHooks"));
        }
    }
}

