
package org.lsst.ccs.subsystems.fcs.autochanger.ui.jas;

import java.io.IOException;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.Agent;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGUI;

/**
 * This class defines the JAS pluggin for the autochnager GUI.
 * @author virieux
 */
public class AutochangerJasPlugin extends Plugin {

    private AutochangerGUI autochangerGUI;
    private FreeHEPLookup lookup;

    @Override
    protected void init() throws IOException {
        // Do nothing here because nothing to be done.
    }

    @Override
    protected void postInit() {
        super.postInit();
        autochangerGUI = new AutochangerGUI("AutochangerGUI",
                "org.lsst.ccs.subsystem.fcs.autochanger",
                Agent.getEnvironmentMessagingAccess());
        autochangerGUI.initGui();
        this.getApplication().getPageManager().openPage(autochangerGUI.getGuiLayout(), 
                "Autochanger GUI", null);
        Studio studio = (Studio) Studio.getApplication();
        lookup = studio.getLookup();
        lookup.add(this);
    }
}
