/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.gconsole.plugins.monitor.LsstMonitorPlugin;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorPanel;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingTable;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingTree;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingView;

public class MonitorAssembly
extends JPanel {
    private MonitorTrendingView table;
    private final MonitorPanel panel;
    private final CommandSender sender;
    private static final long serialVersionUID = 1L;

    public MonitorAssembly(CommandSender sender) {
        this.sender = sender;
        this.setLayout(new BorderLayout());
        try {
            LsstMonitorPlugin mp = (LsstMonitorPlugin)((Studio)Application.getApplication()).getLookup().lookup(LsstMonitorPlugin.class);
            boolean useTree = (Boolean)mp.getServices().getProperty("displayAsTree");
            this.table = useTree ? new MonitorTrendingTree(sender, null) : new MonitorTrendingTable(sender);
        }
        catch (Exception x) {
            this.table = new MonitorTrendingTable(sender);
        }
        this.add((Component)((JComponent)((Object)this.table)), "Center");
        this.panel = new MonitorPanel(sender);
        this.add((Component)this.panel, "South");
    }

    public MonitorTrendingTable getTrendingTable() {
        try {
            return (MonitorTrendingTable)this.table;
        }
        catch (ClassCastException x) {
            this.remove((JComponent)((Object)this.table));
            this.table = new MonitorTrendingTable(this.sender);
            this.add((Component)((JComponent)((Object)this.table)), "Center");
            return (MonitorTrendingTable)this.table;
        }
    }

    public MonitorPanel getControlPanel() {
        return this.panel;
    }

    public void setSubsystems(String ... sNames) {
        this.table.setSubsystems(sNames);
        this.panel.setSubsystems(sNames);
    }

    public void handleData(String source, String key, Object o) {
        if (key.equals("MonitorState")) {
            MonitorState ms = (MonitorState)((KeyValueData)o).getValue();
            this.table.updateTableState(source, ms);
            this.panel.updatePanel(source, this.areLimitsChanged(ms));
        } else if (o instanceof KeyValueDataList) {
            boolean trending = false;
            for (KeyValueData data : (KeyValueDataList)o) {
                if (data.getType() == KeyValueData.KeyValueDataType.KeyValueTrendingData) {
                    this.table.updateTableValue(source, data.getKey(), (Double)data.getValue());
                    trending = true;
                    continue;
                }
                if (data.getType() != KeyValueData.KeyValueDataType.KeyValueMetaData) continue;
                this.table.updateTableLimit(source, key, data.getKey(), (String)((Object)data.getValue()));
            }
            if (trending) {
                this.panel.updateTime();
            }
        }
    }

    public void updateTableModel(String sName, MonitorFullState status) {
        this.table.updateTableModel(sName, status);
        this.panel.updateTime();
        this.panel.updatePanel(sName, this.areLimitsChanged(status.getMonitorState()));
    }

    public void disableSystem(String sName) {
        this.table.disableSystem(sName);
        this.panel.disableSystem(sName);
    }

    private boolean areLimitsChanged(MonitorState status) {
        return !status.getLowLimitChange().isEmpty() | !status.getHighLimitChange().isEmpty();
    }
}

