/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import java.awt.HeadlessException;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.jas.JAS3;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

public class ConsoleApplication
extends JAS3 {
    public ConsoleApplication() {
        super("CCS_Console");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            try {
                new ConsoleApplication().createFrame(args).setVisible(true);
            }
            catch (HeadlessException x) {
                System.out.println("Fatal Error: " + x.getMessage());
            }
            catch (Throwable t) {
                System.out.println("Fatal Error: " + t.getMessage());
                ConsoleApplication.error(null, (String)"Fatal Error", (Throwable)t);
                System.exit(1);
            }
        });
    }

    protected Properties createAppProperties() throws Application.InitializationException {
        String appName;
        Properties appProp = super.createAppProperties();
        Properties ccsProp = BootstrapResourceUtils.getBootstrapProperties((String)"gui.properties");
        String prefName = ccsProp.getProperty("org.lsst.ccs.gui.preferences", appName = ccsProp.getProperty("org.lsst.ccs.application.name"));
        if (prefName != null) {
            if (!prefName.endsWith(".properties")) {
                prefName = prefName + ".properties";
            }
            appProp.setProperty("userPrefDir", appProp.getProperty("org.lsst.ccs.gui.home") + "/" + prefName);
        }
        ccsProp.stringPropertyNames().forEach(key -> appProp.setProperty((String)key, ccsProp.getProperty((String)key)));
        return appProp;
    }
}

