/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.canopenjni.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Level;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.lsst.ccs.drivers.canopenjni.CanFestivalJNI;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.canopenjni.rmi.BootMessageRemoteListener;
import org.lsst.ccs.drivers.canopenjni.rmi.CanOpenRemoteInterface;
import org.lsst.ccs.drivers.canopenjni.rmi.EmergencyMessageRemoteListener;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.utilities.logging.Logger;

public class CanOpenRMIServer
implements CanOpenRemoteInterface {
    private final CanOpenInterface delegate;

    public CanOpenRMIServer(CanOpenInterface coi) {
        this.delegate = coi;
    }

    @Override
    public void init(int master, String baud, String busName, int nodeID) throws DriverException {
        this.delegate.init(master, baud, busName, nodeID);
    }

    @Override
    public void addReceivedPDO(int cobId) throws DriverException {
        this.delegate.addReceivedPDO(cobId);
    }

    @Override
    public PDOData sync() throws DriverException {
        return this.delegate.sync();
    }

    @Override
    public int scan() throws DriverException {
        return this.delegate.scan();
    }

    @Override
    public String info(int nodeID) throws DriverException {
        return this.delegate.info(nodeID);
    }

    @Override
    public void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException {
        this.delegate.wsdo(nodeId, index, subindex, size, data);
    }

    @Override
    public long rsdo(int nodeId, int index, int subindex) throws DriverException {
        return this.delegate.rsdo(nodeId, index, subindex);
    }

    @Override
    public void ssta(int nodeId) throws DriverException {
        this.delegate.ssta(nodeId);
    }

    @Override
    public void ssto(int nodeId) throws DriverException {
        this.delegate.ssto(nodeId);
    }

    @Override
    public void reset(int nodeId) throws DriverException {
        this.delegate.reset(nodeId);
    }

    @Override
    public void quit() throws DriverException {
        this.delegate.quit();
    }

    @Override
    public void init() throws DriverException {
        this.delegate.init();
    }

    @Override
    public void start() throws DriverException {
        this.delegate.start();
    }

    @Override
    public void stop() throws DriverException {
        this.delegate.stop();
    }

    @Override
    public boolean isReady() throws DriverException {
        return this.delegate.isReady();
    }

    @Override
    public void setEmergencyMessageListener(EmergencyMessageRemoteListener eml) throws DriverException {
        this.delegate.setEmergencyMessageListener((int nodeId, int errCode, int errReg) -> {
            try {
                eml.onEmergencyMessage(nodeId, errCode, errReg);
            }
            catch (RemoteException ex) {
                Logger.getLogger((String)CanOpenRMIServer.class.getName()).log(Level.SEVERE, "cannot call back emergency message listener", (Throwable)ex);
            }
        });
    }

    @Override
    public void setBootMessageListener(BootMessageRemoteListener bml) throws DriverException {
        this.delegate.setBootMessageListener((int nodeId) -> {
            try {
                bml.onBootMessage(nodeId);
            }
            catch (RemoteException ex) {
                Logger.getLogger((String)CanOpenRMIServer.class.getName()).log(Level.SEVERE, "cannot call back boot message listener", (Throwable)ex);
            }
        });
    }

    public static void main(String[] args) throws Exception {
        Options rmiOptions = new Options();
        rmiOptions.addOption("h", "help", false, "Print the help message");
        rmiOptions.addOption("bn", "bindName", true, "The name used to bind this server to the registry");
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(rmiOptions, args, true);
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(80, "RMIServer", "", rmiOptions, "", true);
        } else {
            try {
                System.out.println(args);
                Registry registry = LocateRegistry.getRegistry();
                CanOpenRMIServer coiRMI = new CanOpenRMIServer(new CanFestivalJNI());
                CanOpenRemoteInterface stub = (CanOpenRemoteInterface)UnicastRemoteObject.exportObject((Remote)coiRMI, 0);
                String bindName = line.getOptionValue("bindName", "CanOpen");
                registry.bind(bindName, stub);
                System.err.println("Server ready for " + bindName);
            }
            catch (Exception e) {
                System.err.println("Server exception: " + e.toString());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void clearReceivedPDOs() throws DriverException, RemoteException {
        this.delegate.clearReceivedPDOs();
    }

    @Override
    public void setTimeoutMillis(long to) throws DriverException, RemoteException {
        this.delegate.setTimeoutMillis(to);
    }
}

