/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.utilities.logging.Logger;

public class CanOpenHardwareListPanel
extends JPanel {
    private final String tcpProxyName;
    private List<String> hardwareNames;
    protected static final Logger FCSLOG = FCSCst.FCSLOG;
    private static final long serialVersionUID = 4473630289328745341L;
    private JLabel tcpProxyLabel;
    private JLabel bootedNodesNBLabel;
    private JLabel expectedNodesNBLabel;
    private JLabel hardwareBootTimeoutLabel;
    private JPanel hardwarePanel;
    private JTable hardwareTable;
    private JScrollPane jScrollPane;

    public CanOpenHardwareListPanel(String tcpProxyName) {
        this.tcpProxyName = tcpProxyName;
        this.initComponents();
    }

    public void setHardwareNames(List<String> hardwareNamesList) {
        this.hardwareNames = new ArrayList<String>();
        this.hardwareNames.addAll(hardwareNamesList);
    }

    public List<String> getHardwareNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.hardwareNames);
        return list;
    }

    public void initializeGui(ConfigurationInfo configInfo, List<String> hardwareList) {
        SwingUtilities.invokeLater(new GuiInitializationWithConfigInfo(configInfo, hardwareList));
    }

    public void resetPanel() {
        this.expectedNodesNBLabel.setText("0.0");
        this.hardwareBootTimeoutLabel.setText("0.0");
        this.bootedNodesNBLabel.setText("0");
        DefaultTableModel hardwareTableModel = (DefaultTableModel)this.hardwareTable.getModel();
        int rowNB = hardwareTableModel.getRowCount();
        while (hardwareTableModel.getRowCount() > 0) {
            hardwareTableModel.removeRow(hardwareTableModel.getRowCount() - 1);
        }
        hardwareTableModel.fireTableRowsDeleted(0, rowNB - 1);
    }

    public void updateCanOpenHardwarePanel(String deviceToUpdateName, StatusDataPublishedByHardware status) {
        SwingUtilities.invokeLater(new UpdateCanOpenHardwarePanel(deviceToUpdateName, status));
    }

    public void updateCanOpenHardwarePanel(int nbBootedNodes) {
        SwingUtilities.invokeLater(new UpdateTcpProxy(nbBootedNodes));
    }

    private void initComponents() {
        this.hardwarePanel = new JPanel();
        this.tcpProxyLabel = new JLabel(this.tcpProxyName);
        this.bootedNodesNBLabel = new JLabel("0");
        this.hardwareBootTimeoutLabel = new JLabel("0");
        this.expectedNodesNBLabel = new JLabel("0");
        this.jScrollPane = new JScrollPane();
        this.hardwareTable = new JTable();
        this.hardwareTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Node ID", "Serial NB", "Booted", "Initialized"}){
            private static final long serialVersionUID = 1L;
            private final Class[] types;
            private final boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Object.class, Boolean.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        for (int i = 0; i < 5; ++i) {
            TableColumn column = this.hardwareTable.getColumnModel().getColumn(i);
            if (i != 0) continue;
            column.setPreferredWidth(150);
        }
        this.jScrollPane.setViewportView(this.hardwareTable);
        JPanel generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.insets = Tools.insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        gbc4.anchor = 21;
        generalInfoPanel.add((Component)new JLabel("Tcp Proxy name:"), gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)new JLabel("Hardware boot timeout:"), gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)new JLabel("Number of expected CANopen Nodes:"), gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)new JLabel("Number of booted CANopen Nodes:"), gbc4);
        ++gbc4.gridx;
        gbc4.gridy = 0;
        gbc4.anchor = 22;
        generalInfoPanel.add((Component)this.tcpProxyLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.hardwareBootTimeoutLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.expectedNodesNBLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.bootedNodesNBLabel, gbc4);
        this.hardwarePanel.setBorder(BorderFactory.createLineBorder(new Color(255, 0, 255)));
        this.hardwarePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.anchor = 18;
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        this.hardwarePanel.add((Component)generalInfoPanel, gbc0);
        gbc0.gridx = 0;
        ++gbc0.gridy;
        this.hardwarePanel.add((Component)this.jScrollPane, gbc0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.hardwarePanel, gbc);
    }

    @Override
    public String toString() {
        return "CANopen hardware list";
    }

    public static void main(String[] argv) {
        CanOpenHardwareListPanel p = new CanOpenHardwareListPanel("fakeTcpProxy");
        JFrame frame = new JFrame("CANopen Hardware");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateTcpProxy
    implements Runnable {
        private final int nbBootedNodes;

        public UpdateTcpProxy(int nbBootedNodes) {
            this.nbBootedNodes = nbBootedNodes;
        }

        @Override
        public void run() {
            CanOpenHardwareListPanel.this.bootedNodesNBLabel.setText(Integer.toString(this.nbBootedNodes));
        }
    }

    private class UpdateCanOpenHardwarePanel
    implements Runnable {
        private final String deviceToUpdateName;
        private final StatusDataPublishedByHardware s;

        public UpdateCanOpenHardwarePanel(String deviceToUpdateName, StatusDataPublishedByHardware status) {
            this.deviceToUpdateName = deviceToUpdateName;
            this.s = status;
        }

        @Override
        public void run() {
            DefaultTableModel hardwareTableModel = (DefaultTableModel)CanOpenHardwareListPanel.this.hardwareTable.getModel();
            int rowNB = hardwareTableModel.getRowCount();
            for (int i = 0; i < rowNB; ++i) {
                if (!hardwareTableModel.getValueAt(i, 0).equals(this.deviceToUpdateName)) continue;
                hardwareTableModel.setValueAt(this.s.isBooted(), i, 3);
                hardwareTableModel.setValueAt(this.s.isInitialized(), i, 4);
            }
            hardwareTableModel.fireTableDataChanged();
        }
    }

    private class GuiInitializationWithConfigInfo
    implements Runnable {
        private final ConfigurationInfo configInfo;
        private final List<String> hardwareList;

        public GuiInitializationWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) {
            this.configInfo = configInfo;
            this.hardwareList = new ArrayList<String>();
            this.hardwareList.addAll(hardwareList);
        }

        @Override
        public void run() {
            int nodesNB = this.hardwareList.size();
            Map config = this.configInfo.getCurrentValuesFor(CanOpenHardwareListPanel.this.tcpProxyName);
            CanOpenHardwareListPanel.this.expectedNodesNBLabel.setText(Integer.toString(nodesNB));
            CanOpenHardwareListPanel.this.hardwareBootTimeoutLabel.setText((String)config.get("hardwareBootTimeout"));
            DefaultTableModel hardwareTableModel = (DefaultTableModel)CanOpenHardwareListPanel.this.hardwareTable.getModel();
            for (String hardwareName : this.hardwareList) {
                Map hardwareConfig = this.configInfo.getCurrentValuesFor(hardwareName);
                String nodeID = "0x" + Integer.toHexString(Integer.parseInt((String)hardwareConfig.get("nodeID")));
                String serialNB = (String)hardwareConfig.get("serialNB");
                Object[] tab = new Object[]{hardwareName, nodeID, serialNB, false, false};
                hardwareTableModel.addRow(tab);
            }
            hardwareTableModel.fireTableDataChanged();
        }
    }
}

