/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.util.List;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.SingleFilterTestExchangePanel;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.SingleFilterTestGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;

public class SingleFilterTestGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = 7457785896732960334L;
    private static final String CLAMPXMINUS_NAME = "clampXminus";
    private static final String CLAMPXPLUS_NAME = "clampXplus";
    private CanOpenDevicePanel ai814Panel;
    private CanOpenDevicePanel ao412Panel;
    private CanOpenDevicePanel dio8n1Panel;
    private CanOpenDevicePanel dio8n2Panel;
    private EPOSControllerPanel clampXminusControllerPanel;
    private EPOSControllerPanel clampXplusControllerPanel;
    SingleFilterTestExchangePanel sftExchangePanel;

    public SingleFilterTestGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        this.setName("SingleFilterTestGatherPanel");
        this.initPanels();
    }

    public SingleFilterTestGatherPanel(SingleFilterTestGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.setName("SingleFilterTestGatherPanel");
        this.initPanels();
    }

    public CanOpenDevicePanel getAi814Panel() {
        return this.ai814Panel;
    }

    public CanOpenDevicePanel getAo412Panel() {
        return this.ao412Panel;
    }

    public CanOpenDevicePanel getDio8n1Panel() {
        return this.dio8n1Panel;
    }

    public CanOpenDevicePanel getDio8n2Panel() {
        return this.dio8n2Panel;
    }

    public EPOSControllerPanel getClampXminusControllerPanel() {
        return this.clampXminusControllerPanel;
    }

    public EPOSControllerPanel getClampXplusControllerPanel() {
        return this.clampXplusControllerPanel;
    }

    public SingleFilterTestExchangePanel getSftExchangePanel() {
        return this.sftExchangePanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        this.sftExchangePanel.initializeGui(configInfo);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateClamp(String clampName, StatusDataPublishedByCarouselClamp status) {
        this.sftExchangePanel.updateClamp(clampName, status);
    }

    public void updateLatch(String latchName, StatusDataPublishedByAutochangerLatch status) {
        this.sftExchangePanel.updateLatch(latchName, status);
    }

    public void updateAutoChanger(StatusDataPublishedByBasicAutoChanger status) {
        this.sftExchangePanel.updateAutoChanger(status);
    }

    public void updateCarousel(StatusDataPublishedByCarousel status) {
        this.sftExchangePanel.updateCarousel(status);
    }

    public void updateActuator(String actuatorName, StatusDataPublishedByClampActuator status) {
        this.sftExchangePanel.updateActuator(actuatorName, status);
    }

    @Override
    public void updateFromStatusData(KeyValueData data) {
        if ("tcpProxy".equals(data.getKey())) {
            this.updateCanOpenHardwarePanel((Integer)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByClampActuator) {
            this.updateActuator(data.getKey(), (StatusDataPublishedByClampActuator)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByHardware) {
            this.updateCanOpenHardwarePanel(data.getKey(), (StatusDataPublishedByHardware)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerLatch) {
            this.updateLatch(data.getKey(), (StatusDataPublishedByAutochangerLatch)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByCarouselClamp) {
            this.updateClamp(data.getKey(), (StatusDataPublishedByCarouselClamp)data.getValue());
        } else {
            switch (data.getKey()) {
                case "carousel": {
                    FCSLOG.debug((Object)(this.getName() + " read data dataType:carousel"));
                    this.updateCarousel((StatusDataPublishedByCarousel)data.getValue());
                    break;
                }
                case "autochanger": {
                    FCSLOG.debug((Object)(this.getName() + " read data dataType:autochanger"));
                    this.updateAutoChanger((StatusDataPublishedByBasicAutoChanger)data.getValue());
                    break;
                }
                default: {
                    FCSLOG.warning((Object)(this.getName() + " An unexpected dataType was read on the status bus:" + data.getKey()));
                }
            }
        }
    }

    @Override
    public void updateFromConfigurationInfo(ConfigurationInfo configInfo) {
        this.sftExchangePanel.initializeGui(configInfo);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    private void initPanels() {
        this.ai814Panel = new CanOpenDevicePanel("ai814");
        this.ao412Panel = new CanOpenDevicePanel("ao412");
        this.dio8n1Panel = new CanOpenDevicePanel("dio8n1");
        this.dio8n2Panel = new CanOpenDevicePanel("dio8n2");
        this.clampXminusControllerPanel = new EPOSControllerPanel("clampXminusController");
        this.clampXplusControllerPanel = new EPOSControllerPanel("clampXplusController");
        this.sftExchangePanel = new SingleFilterTestExchangePanel();
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            SingleFilterTestGatherPanel.this.clampXminusControllerPanel.initializeGui(this.configInfo);
            SingleFilterTestGatherPanel.this.clampXplusControllerPanel.initializeGui(this.configInfo);
            SingleFilterTestGatherPanel.this.ai814Panel.initializeGui(this.configInfo);
            SingleFilterTestGatherPanel.this.ao412Panel.initializeGui(this.configInfo);
            SingleFilterTestGatherPanel.this.dio8n1Panel.initializeGui(this.configInfo);
            SingleFilterTestGatherPanel.this.dio8n2Panel.initializeGui(this.configInfo);
        }
    }
}

