/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselClampPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class CarouselSocketPanel
extends JPanel {
    private static final long serialVersionUID = 6352712511682293959L;
    private InterfaceCarouselGUI subs;
    private String socketName;
    private String clampXminusName;
    private String clampXplusName;
    private JPanel sensorsPanel;
    private CarouselClampPanel clampXminusPanel;
    private CarouselClampPanel clampXplusPanel;
    private FilterPanel filterPanel;
    private JPanel clampsStatePanel;
    private final JLabel clampsState = new JLabel("UNKNOWN STATE");
    private final JLabel clampsStateLabel = new JLabel("Clamps State :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinusLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private JPanel generalInfoPanel;
    private final JLabel nLabel = new JLabel("Name: ");
    private final JLabel nameLabel = new JLabel("socketXXX");
    private final JLabel positionOnCarouselLabel = new JLabel("0.0");
    private final JLabel sLabel = new JLabel("Carousel position at STANDBY: ");
    private final JLabel standbyPositionLabel = new JLabel("999.99");
    private JPanel actualPositionPanel;
    private final JLabel homingLabel = new JLabel("NOT DONE");
    private final JLabel actualPositionLabel = new JLabel("999.99");
    private final JLabel standbyLabel = new JLabel("NOT AT STANDBY position");
    private final DigitalSwitch standbySwitch = new DigitalSwitch();
    private final JLabel slaveModuleStatusLabel = new JLabel();

    public CarouselSocketPanel() {
        this.socketName = "socket99";
        this.clampXminusName = "clampXminus99";
        this.clampXplusName = "clampXplus99";
        this.initComponents();
    }

    public CarouselSocketPanel(String socketName) {
        this.socketName = socketName;
        this.nameLabel.setText(socketName);
        char num = socketName.charAt(socketName.length() - 1);
        this.clampXminusName = "clampXminus" + num;
        this.clampXplusName = "clampXplus" + num;
        this.initComponents();
    }

    public void setSubsystem(InterfaceCarouselGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        Map config = configInfo.getCurrentValuesFor(this.socketName);
        this.positionOnCarouselLabel.setText((String)config.get("positionOnCarousel"));
        this.standbyPositionLabel.setText((String)config.get("standbyPosition"));
        this.clampXminusPanel.initializeGui(configInfo);
        this.clampXplusPanel.initializeGui(configInfo);
    }

    public void updateSocket(StatusDataPublishedByCarouselSocket s) {
        SwingUtilities.invokeLater(new UpdateSocket(s));
    }

    public void updateSocketFromCarousel(StatusDataPublishedByCarousel s) {
        SwingUtilities.invokeLater(new UpdateSocketFromCarousel(s));
    }

    public void update(String clampName, StatusDataPublishedByCarouselClamp s) {
        if (clampName.contains("Xminus")) {
            this.clampXminusPanel.updateClamp(s);
        } else if (clampName.contains("Xplus")) {
            this.clampXplusPanel.updateClamp(s);
        } else {
            FCSCst.FCSLOG.error((Object)("Error in clamps name on STATUS bus. Unknown clamp name: " + clampName));
        }
    }

    private void initComponents() {
        this.setName(this.socketName + "Panel");
        this.xMinusLabel.setFont(Tools.VERY_BIG_FONT);
        this.xMinusLabel2.setFont(Tools.VERY_BIG_FONT);
        this.xPlusLabel2.setFont(Tools.VERY_BIG_FONT);
        this.xPlusLabel.setFont(Tools.VERY_BIG_FONT);
        this.generalInfoPanel = new JPanel();
        this.generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        this.generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        this.generalInfoPanel.add((Component)this.nLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.sLabel, gbc3);
        ++gbc3.gridx;
        gbc3.gridy = 0;
        gbc3.anchor = 22;
        this.generalInfoPanel.add((Component)this.nameLabel, gbc3);
        this.nameLabel.setFont(Tools.BIG_FONT);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.standbyPositionLabel, gbc3);
        this.actualPositionPanel = new JPanel();
        this.actualPositionPanel.setBorder(BorderFactory.createLineBorder(Color.yellow));
        this.actualPositionPanel.setLayout(new GridBagLayout());
        this.actualPositionPanel.setMinimumSize(new Dimension(150, 50));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 21;
        this.actualPositionPanel.add((Component)new JLabel("Homing"), gbc1);
        ++gbc1.gridy;
        this.actualPositionPanel.add((Component)new JLabel("Actual position: "), gbc1);
        ++gbc1.gridy;
        this.actualPositionPanel.add((Component)this.standbyLabel, gbc1);
        ++gbc1.gridy;
        this.actualPositionPanel.add((Component)new JLabel("Slave Status:"), gbc1);
        ++gbc1.gridx;
        gbc1.gridy = 0;
        gbc1.anchor = 22;
        this.actualPositionPanel.add((Component)this.homingLabel, gbc1);
        ++gbc1.gridy;
        this.actualPositionPanel.add((Component)this.actualPositionLabel, gbc1);
        ++gbc1.gridy;
        this.standbySwitch.setColor(Color.gray);
        this.actualPositionPanel.add((Component)this.standbySwitch, gbc1);
        ++gbc1.gridy;
        this.actualPositionPanel.add((Component)this.slaveModuleStatusLabel, gbc1);
        this.clampsStatePanel = new JPanel();
        this.clampsState.setFont(Tools.BIG_FONT);
        this.clampsState.setBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(255, 255, 255)));
        this.clampsStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        this.clampsStatePanel.add((Component)this.clampsStateLabel, gbc2);
        ++gbc2.gridx;
        this.clampsStatePanel.add((Component)this.clampsState, gbc2);
        this.clampXminusPanel = new CarouselClampPanel(this.clampXminusName);
        this.clampXplusPanel = new CarouselClampPanel(this.clampXplusName);
        JPanel clampsPanel = new JPanel();
        clampsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        clampsPanel.add((Component)this.xMinusLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        clampsPanel.add((Component)this.clampsStatePanel, gbc);
        gbc.anchor = 13;
        ++gbc.gridx;
        clampsPanel.add((Component)this.xPlusLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        clampsPanel.add((Component)this.clampXminusPanel, gbc);
        ++gbc.gridx;
        clampsPanel.add((Component)this.clampXplusPanel, gbc);
        gbc.anchor = 17;
        gbc.gridx = 0;
        ++gbc.gridy;
        clampsPanel.add((Component)this.xMinusLabel2, gbc);
        gbc.anchor = 13;
        ++gbc.gridx;
        ++gbc.gridx;
        clampsPanel.add((Component)this.xPlusLabel2, gbc);
        this.filterPanel = new FilterPanel();
        this.filterPanel.setSize(100);
        this.filterPanel.setIsFilterInHouse(false, "NO FILTER");
        this.setBorder(BorderFactory.createLineBorder(Color.PINK));
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.generalInfoPanel, gbc);
        ++gbc.gridx;
        this.add(this.actualPositionPanel);
        ++gbc.gridx;
        gbc.anchor = 10;
        this.add((Component)this.filterPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        this.add((Component)clampsPanel, gbc);
        this.setDefaultValues();
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.clampXminusPanel.resetPanel();
        this.clampXplusPanel.resetPanel();
    }

    private void setDefaultValues() {
        this.clampsState.setText("UNKNOWN STATE");
        this.clampsState.setForeground(Color.darkGray);
        this.homingLabel.setText("NOT DONE");
        this.actualPositionLabel.setText("999.99");
        this.standbyLabel.setText("UNKNOWN");
        this.standbySwitch.setColor(Color.darkGray);
        this.slaveModuleStatusLabel.setText("UNKNOWN");
        this.slaveModuleStatusLabel.setForeground(Color.darkGray);
        this.filterPanel.setIsFilterInHouse(false, "NO FILTER");
    }

    @Override
    public String toString() {
        if (this.socketName == null) {
            return "Unamed socket";
        }
        return this.socketName;
    }

    public static void main(String[] argv) {
        CarouselSocketPanel d = new CarouselSocketPanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateSocketFromCarousel
    implements Runnable {
        private StatusDataPublishedByCarousel s;

        public UpdateSocketFromCarousel(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isHomingDone()) {
                CarouselSocketPanel.this.homingLabel.setText("DONE");
                CarouselSocketPanel.this.homingLabel.setForeground(Tools.greenColor);
            } else {
                CarouselSocketPanel.this.homingLabel.setText("TO_BE_DONE");
                CarouselSocketPanel.this.homingLabel.setForeground(Color.RED);
            }
            CarouselSocketPanel.this.actualPositionLabel.setText(Double.toString(this.s.getPosition()));
        }
    }

    public class UpdateSocket
    implements Runnable {
        private StatusDataPublishedByCarouselSocket s;

        public UpdateSocket(StatusDataPublishedByCarouselSocket s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isAtStandby()) {
                CarouselSocketPanel.this.standbyLabel.setText("AT STANDBY position");
                CarouselSocketPanel.this.standbySwitch.setColor(Tools.greenColor);
            } else {
                CarouselSocketPanel.this.standbyLabel.setText("NOT AT STANDBY position");
                CarouselSocketPanel.this.standbySwitch.setColor(Color.darkGray);
            }
            CarouselSocketPanel.this.clampsState.setText(this.s.getClampState().toString());
            CarouselSocketPanel.this.clampsState.setForeground(this.s.getClampState().getColor());
            CarouselSocketPanel.this.filterPanel.setIsFilterInHouse(!this.s.isEmpty(), this.s.getFilterName());
            CarouselSocketPanel.this.slaveModuleStatusLabel.setText(this.s.getSlaveStatus().toString());
            CarouselSocketPanel.this.slaveModuleStatusLabel.setForeground(this.s.getSlaveStatus().getColor());
        }
    }
}

