
package org.lsst.ccs.subsystems.fcs.ui;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_CLAMPSNAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_LATCHES_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.AC_TRUCKS_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

/**
 * A GUI for the whole Filter Changer Subsystem.
 * 
 * @author virieux
 */
public class FcsGUI extends GeneralGUI implements InterfaceCarouselGUI, InterfaceAutochangerGUI, InterfaceLoaderGUI {
    private static final long serialVersionUID = -6702752740750789411L;
    
    private static final String clampModuleName = "clamp";
    private static final String carrierModuleName = "carrier";
    
    /*actions timeout for autochanger*/
    private long timeoutForTrucksMotion;
    private long updateTrucksPositionTimeout;
    private long timeoutForOnlineClampMotion;
    private final long timeoutForClosingClamps;
    private long timeoutForClosingLatches;

    //actions timeout for Loader
    protected long updateCarrierPositionTimeout;
    protected long openHooksTimeout;
    protected long closeHooksTimeout;
    protected long clampHooksTimeout;
    protected long homingHooksTimeout;
    protected long goToHandoffTimeout;
    protected long goToStorageTimeout;
    protected long goToEngagedTimeout;
    protected long quickStopTimeout;


    /**
     * A constructor with a name, a destination (subsystem name) and an AgentMessagingLayer.
     * @param name
     * @param role
     * @param aml 
     */
    public FcsGUI(String name, String role, AgentMessagingLayer aml) {
        super(name, role, aml);
        FcsGatherPanel fcsGatherPanel;
        fcsGatherPanel = new FcsGatherPanel(this);
        FcsBottomPanel fcsBottomPanel = new FcsBottomPanel(fcsGatherPanel, "FCS");
        this.generalPanel = new GeneralPanel(this, fcsBottomPanel);
        pane = new JScrollPane(generalPanel);
        
        /* Initialization of autochanger timeout */
        updateTrucksPositionTimeout = 1000;
        timeoutForClosingLatches = 10000;
        this.timeoutForClosingClamps = 10000;
        
        /* Initialization of loader timeout */
        openHooksTimeout = 0;
        closeHooksTimeout = 0;
        clampHooksTimeout = 0;
        homingHooksTimeout = 0;
        goToHandoffTimeout = 0;
        goToStorageTimeout = 0;
        abortTimeout = 1000;
        quickStopTimeout = 1000;
        updateStateWithSensorsTimeout = 1000;
        updateCarrierPositionTimeout = 1000;
    }

    @Override
    public void setLoGoToHandoffTimeout(int aInt) {
        this.goToHandoffTimeout = aInt;
    }

    @Override
    public void setLoGoToStorageTimeout(int aInt) {
        this.goToStorageTimeout = aInt;
    }
    
    @Override
    public void setLoGoToEngagedTimeout(int goToEngagedTimeout) {
        this.goToEngagedTimeout = goToEngagedTimeout;
    }

    @Override
    public void setOpenHooksTimeout(long openHooksTimeout) {
        this.openHooksTimeout = openHooksTimeout;
    }

    @Override
    public void setCloseHooksTimeout(long closeHooksTimeout) {
        this.closeHooksTimeout = closeHooksTimeout;
    }

    @Override
    public void setClampHooksTimeout(long clampHooksTimeout) {
        this.clampHooksTimeout = clampHooksTimeout;
    }

    @Override
    public void setHomingHooksTimeout(long homingHooksTimeout) {
        this.homingHooksTimeout = homingHooksTimeout;
    }
    

    
    /**
     ******************************************************************************
     ** Carousel commands
     ******************************************************************************
     */ 
    
    @Override
    public void checkFiltersLocation() {
        new CommandSwingWorker("checkFiltersLocation", updateStateWithSensorsTimeout).execute();
    }

    
    @Override
    public void rotate() {
        new CommandSwingWorker("carousel/rotate", this.goToHandoffTimeout).execute();
    }
    
    
    @Override
    public void updatePosition() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void unlockClamps() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
     /**
     ******************************************************************************
     ** END of Carousel commands
     ******************************************************************************
     */   
    
    /**
     ******************************************************************************
     ** Autochanger commands
     ******************************************************************************
     * 
     */
    
    /**
     * 
     * @param timeoutForTrucksMotion 
     */
    @Override
    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }
    
    @Override
    public void setTimeoutForOnlineClampMotion(long timeoutForOnlineClampMotion) {
        this.timeoutForOnlineClampMotion = timeoutForOnlineClampMotion;
    }    

    /**
     ******************************************************************************
     ** Latches Actions
     * *****************************************************************************
     * @param latchName
     */
    @Override
    public void closeLatch(String latchName) {
        FCSLOG.info("Autochanger locking latch: " + latchName);
        FCSLOG.info("/timeout=" + timeoutForClosingLatches);
        new CommandSwingWorker("close", this.timeoutForClosingLatches, latchName).execute();
    }

    @Override
    public void openLatch(String latchName) {
        FCSLOG.info("Autochanger unlocking latch: " + latchName);
        FCSLOG.info("/timeout=" + timeoutForClosingLatches);
        new CommandSwingWorker("open", this.timeoutForClosingLatches, latchName).execute();
    }

    @Override
    public void closeLatches() {
        FCSLOG.info("Autochanger locking latches.");
        FCSLOG.info("/timeout=" + timeoutForClosingLatches);
        new CommandSwingWorker("close", this.timeoutForClosingLatches, AC_LATCHES_NAME).execute();
    }

    @Override
    public void openLatches() {
        FCSLOG.info("Autochanger unlocking latches.");
        FCSLOG.info("/timeout=" + timeoutForClosingLatches);
        new CommandSwingWorker("open", this.timeoutForClosingLatches, AC_LATCHES_NAME).execute();
    }

    /**
     ******************************************************************************
     ** end of Latches Actions
     * *****************************************************************************
     */
    /**
     ******************************************************************************
     ** Clamps Actions
     * *****************************************************************************
     */
    @Override
    public void unlockOnlineClamps() {
        FCSLOG.info("Autochanger unlocking online clamps");
        new CommandSwingWorker("unlockClamps", timeoutForOnlineClampMotion, AC_CLAMPSNAME).execute();
    }

    @Override
    public void lockOnlineClamps() {
        FCSLOG.info("Autochanger locking online clamps");
        new CommandSwingWorker("lockClamps", timeoutForOnlineClampMotion, AC_CLAMPSNAME).execute();
    }
    

    @Override
    public void closeOnlineClamps() {
        FCSLOG.info("Autochanger closing online clamps");
        new CommandSwingWorker("closeClamps", timeoutForOnlineClampMotion, AC_CLAMPSNAME).execute();
    }

    @Override
    public void openOnlineClamps() {
        FCSLOG.info("Autochanger opening online clamps");
        new CommandSwingWorker("openClamps", timeoutForOnlineClampMotion, AC_CLAMPSNAME).execute();        
    }    
    
        @Override
    public void unlockAndOpenOnlineClamps() {
        FCSLOG.info("Autochanger unlocking and opening online clamps");
        new CommandSwingWorker("unlockAndOpenClamps", timeoutForOnlineClampMotion, AC_CLAMPSNAME).execute();
    }

    @Override
    public void closeAndLockOnlineClamps() {
        FCSLOG.info("Autochanger closing and locking online clamps");
        new CommandSwingWorker("closeAndLockClamps", timeoutForOnlineClampMotion, AC_CLAMPSNAME).execute();
    }
    
    @Override
    public void openOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger opening clamp: " + clampName);
        new CommandSwingWorker("open", this.timeoutForClosingClamps, clampName).execute();
    }

    @Override
    public void closeOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger closing clamp: " + clampName);
        new CommandSwingWorker("close", this.timeoutForClosingClamps, clampName).execute(); 
    }

    @Override
    public void lockOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger clamping clamp: " + clampName);
        new CommandSwingWorker("lock", this.timeoutForClosingClamps, clampName).execute();
    }

    @Override
    public void unlockOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger unclamping clamp: " + clampName);
        new CommandSwingWorker("unlock", this.timeoutForClosingClamps, clampName).execute();        
    }    


    /**
     ******************************************************************************
     ** end of Clamps Actions
     * *****************************************************************************
     */   
    
    /**
     ******************************************************************************
     ** Trucks Actions
     * *****************************************************************************
     */

    @Override
    public void acUpdateTrucksPosition() {
        FCSLOG.info("Autochanger updating Trucks position");
        FCSLOG.info("/timeout=" + updateTrucksPositionTimeout);
        new CommandSwingWorker("updatePosition", this.updateTrucksPositionTimeout, AC_TRUCKS_NAME).execute();
    }
    
    @Override
    public void acGoToHandOff() {
        FCSLOG.info("Autochanger Trucks going to Handoff Position");
        FCSLOG.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToHandOff", this.timeoutForTrucksMotion, AC_TRUCKS_NAME).execute();
    }

    @Override
    public void acGoToOnline() {
        FCSLOG.info("Autochanger Trucks going to ONLINE Position");
        FCSLOG.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToOnline", this.timeoutForTrucksMotion, AC_TRUCKS_NAME).execute();
    }

    @Override
    public void acGoToStandby() {
        FCSLOG.info("Autochanger Trucks going to Standby Position");
        FCSLOG.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToStandby", this.timeoutForTrucksMotion, AC_TRUCKS_NAME).execute();
    }
      
    @Override
    public void acMoveAndClampFilterOnline() {
        FCSLOG.info("Autochanger Trucks moving to Online Position, and clamping");
        FCSLOG.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("moveAndClampFilterOnline", this.timeoutForTrucksMotion, AC_TRUCKS_NAME).execute();
    } 
    
    /**
     ******************************************************************************
     ** end of Trucks Actions
     * *****************************************************************************
     */


    /**
     ******************************************************************************
     ** Loader commands
     ******************************************************************************
     */
    
    /**
     * 
     */
    @Override
    public void loLoadFilter() {
        System.out.println(destination + "loadFilterInCamera with timeout=" + goToHandoffTimeout);
        FCSLOG.info("Loading filter in camera");
        FCSLOG.info("/timeout=" + goToHandoffTimeout);
        new CommandSwingWorker("loadFilterInCamera", this.goToHandoffTimeout).execute();
    }

    @Override
    public void loUnloadFilter() {
        System.out.println(destination + "unloadFilterFromCamera with timeout=" + goToStorageTimeout);
        FCSLOG.info("Loading filter in camera");
        FCSLOG.info("/timeout=" + goToStorageTimeout);
        new CommandSwingWorker("unloadFilterFromCamera", this.goToStorageTimeout).execute();
    }

    @Override
    public void loUpdateCarrierPosition() {
        System.out.println(destination + "updateCarrierPosition with updateCarrierPositionTimeout=" + updateCarrierPositionTimeout);
        FCSLOG.info("Updating carrier position");
        FCSLOG.info("/timeout=" + updateCarrierPositionTimeout);
        new CommandSwingWorker("updatePosition", updateCarrierPositionTimeout, carrierModuleName).execute();
    }

    @Override
    public void loOpenHooks() {
        FCSLOG.info("Opening Hooks");
        FCSLOG.info("/timeout=" + openHooksTimeout);
        new CommandSwingWorker("openHooks", openHooksTimeout).execute();
    }

    @Override
    public void loCloseHooks() {
        FCSLOG.info("Closing Hooks");
        System.out.println("/timeout=" + closeHooksTimeout);
        new CommandSwingWorker("closeHooks", this.closeHooksTimeout).execute();
    }

    @Override
    public void loClampHooks() {
        FCSLOG.info("Clamping Hooks");
        FCSLOG.info("/timeout=" + clampHooksTimeout);
        new CommandSwingWorker("clampHooks", this.clampHooksTimeout).execute();
    }
    
    @Override
    public void loUnclampHooks() {
        FCSLOG.info("Unclamping Hooks");
        FCSLOG.info("/timeout=" + clampHooksTimeout);
        new CommandSwingWorker("unclamp", this.clampHooksTimeout, clampModuleName).execute();
    }
    
    @Override
    public void loClampHoming() {
        FCSLOG.info("Clamp going to Home Position or CLAMPED position.");
        FCSLOG.info("/timeout=" + homingHooksTimeout);
        new CommandSwingWorker("initializeHardware", this.homingHooksTimeout, clampModuleName).execute();
    }

    @Override
    public void loGoToHandOff() {
        FCSLOG.info("Carrier going to Handoff Position");
        FCSLOG.info("/timeout=" + goToHandoffTimeout);
        new CommandSwingWorker("goToHandOff", this.goToHandoffTimeout, carrierModuleName).execute();
    }

    @Override
    public void loGoToStorage() {
        System.out.println(destination + "goToStorage with goToStorageTimeout=" + goToStorageTimeout);
        FCSLOG.info("Carrier going to Storage Position");
        FCSLOG.info("/timeout=" + goToStorageTimeout);
        new CommandSwingWorker("goToStorage", this.goToStorageTimeout, carrierModuleName).execute();
    }
    
    @Override
    public void loGoToEngaged() {
        FCSLOG.info("Carrier going to Engaged Position with timeout=" + goToEngagedTimeout);
        new CommandSwingWorker("goToEngaged", this.goToEngagedTimeout, carrierModuleName).execute();
    }    
    
    



    
    
    /**
     ******************************************************************************
     ** END of Loader commands
     ******************************************************************************
     */
    
    /**
     * This main launches an GUI for the whole subsystem "fcs".
     * It's used only for tests.
     * 
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        Agent agent = new Agent("FcsGUI", AgentInfo.AgentType.CONSOLE);
        FcsGUI t = new FcsGUI(agent.getName(), "fcs", 
                agent.getMessagingAccess());
        agent.startAgent();

        JFrame frame = new JFrame("Fcs View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }


















    
}
