
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.util.List;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;

/**
 *
 * @author virieux
 */
public class SingleFilterTestGatherPanel extends GatherPanel {
    
    private static final long serialVersionUID = 7457785896732960334L;

    
    
    private static final String CLAMPXMINUS_NAME = "clampXminus";
    private static final String CLAMPXPLUS_NAME = "clampXplus";
    
    
    //CANopen devices panels
    private CanOpenDevicePanel ai814Panel;
    private CanOpenDevicePanel ao412Panel;
    private CanOpenDevicePanel dio8n1Panel;
    private CanOpenDevicePanel dio8n2Panel;
    private EPOSControllerPanel clampXminusControllerPanel;
    private EPOSControllerPanel clampXplusControllerPanel;
    
    //SFT Main Panel
    SingleFilterTestExchangePanel sftExchangePanel;




    /**
     * Initialization of the GUI for data stored in tcpConfiguration. *
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        /**
         * Create a new GuiInitialization from a ConfigurationInfo.
         * @param configInfo 
         */
        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo =configInfo;
        }

        @Override
        public void run() {
            /**
             * ClampXminus Controller Panel *
             */
            clampXminusControllerPanel.initializeGui(configInfo);
            
            /**
             * ClampXplus Controller Panel *
             */
            clampXplusControllerPanel.initializeGui(configInfo);
           
            /**
             * ai814 Panel *
             */
            ai814Panel.initializeGui(configInfo);
            
            /**
             * ao412*
             */
            ao412Panel.initializeGui(configInfo);
            
            /**
             * CANOpen DIO Panels*
             */
            dio8n1Panel.initializeGui(configInfo);
            dio8n2Panel.initializeGui(configInfo);
            
            
        }
    }
    
    

    public SingleFilterTestGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        setName("SingleFilterTestGatherPanel");
        initPanels();
    }
    
    public SingleFilterTestGatherPanel(SingleFilterTestGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        setName("SingleFilterTestGatherPanel");
        initPanels();


    }


    public CanOpenDevicePanel getAi814Panel() {
        return ai814Panel;
    }

    public CanOpenDevicePanel getAo412Panel() {
        return ao412Panel;
    }

    public CanOpenDevicePanel getDio8n1Panel() {
        return dio8n1Panel;
    }

    public CanOpenDevicePanel getDio8n2Panel() {
        return dio8n2Panel;
    }

    public EPOSControllerPanel getClampXminusControllerPanel() {
        return clampXminusControllerPanel;
    }

    public EPOSControllerPanel getClampXplusControllerPanel() {
        return clampXplusControllerPanel;
    }

    public SingleFilterTestExchangePanel getSftExchangePanel() {
        return sftExchangePanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, 
            List<String> hardwareNames)  {
        super.initializeGUIWithConfigInfo(configInfo,hardwareNames);
        sftExchangePanel.initializeGui(configInfo);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }
    

    public void updateClamp(String clampName, StatusDataPublishedByCarouselClamp status) {
        sftExchangePanel.updateClamp(clampName, status);
    }

    public void updateLatch(String latchName, StatusDataPublishedByAutochangerLatch status) {
        sftExchangePanel.updateLatch(latchName, status);
    }

    public void updateAutoChanger(StatusDataPublishedByBasicAutoChanger status) {
        sftExchangePanel.updateAutoChanger(status);
    }

    public void updateCarousel(StatusDataPublishedByCarousel status) {
        sftExchangePanel.updateCarousel(status);
    }

    public void updateActuator(String actuatorName, StatusDataPublishedByClampActuator status) {
        sftExchangePanel.updateActuator(actuatorName, status);
    }

    @Override
    public void updateFromStatusData(KeyValueData data) {
        
            if (CHANGER_TCPPROXY_NAME.equals(data.getKey())) {
                updateCanOpenHardwarePanel((int)data.getValue());
                
            } else if (data.getValue() instanceof StatusDataPublishedByClampActuator) {
                updateActuator(data.getKey(), (StatusDataPublishedByClampActuator) data.getValue()); 
                
            } else if (data.getValue() instanceof StatusDataPublishedByHardware) { 
                updateCanOpenHardwarePanel(data.getKey(),(StatusDataPublishedByHardware) data.getValue());                 
        
            } else if (data.getValue() instanceof StatusDataPublishedByAutochangerLatch) {
                updateLatch(data.getKey(), (StatusDataPublishedByAutochangerLatch) data.getValue());
                
            } else if (data.getValue() instanceof StatusDataPublishedByCarouselClamp) {
                updateClamp(data.getKey(), (StatusDataPublishedByCarouselClamp) data.getValue());
  
                
            } else {
 
                switch (data.getKey()) {   

                    case "carousel":
                        FCSLOG.debug(getName() + " read data dataType:carousel");
                        updateCarousel((StatusDataPublishedByCarousel) data.getValue());
                        break;

                    case "autochanger":
                        FCSLOG.debug(getName() + " read data dataType:autochanger");
                        updateAutoChanger((StatusDataPublishedByBasicAutoChanger) data.getValue());
                        break;

                    default:
                        FCSLOG.warning(getName() + " An unexpected dataType was read on the status bus:" + data.getKey());
                        break;

                }
            }
    }
    
    @Override
    public void updateFromConfigurationInfo(ConfigurationInfo configInfo) {
        sftExchangePanel.initializeGui(configInfo);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }
    
    private void initPanels() {
        //CANOpen CAN-CBX-AI420
        ai814Panel = new CanOpenDevicePanel("ai814");
        ao412Panel = new CanOpenDevicePanel("ao412");
        
        /** CANOpen DIO for the latches*/
        dio8n1Panel = new CanOpenDevicePanel("dio8n1");
        dio8n2Panel = new CanOpenDevicePanel("dio8n2");
        
        //controllers Panels
        clampXminusControllerPanel = new EPOSControllerPanel("clampXminusController");
        clampXplusControllerPanel = new EPOSControllerPanel("clampXplusController");

        /** Filter Exchange Panel*/
        this.sftExchangePanel = new SingleFilterTestExchangePanel();
    }
    
            

                        

    
}
