
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.BIG_FONT;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * A view to display a global view of the loader.
 * To be continued....
 * @author virieux
 */
public class LoaderGeneralViewPanel extends JPanel {
    private static final long serialVersionUID = 8834267363875256916L;
    private InterfaceLoaderGUI subs;

    private final JLabel onCameraLabel = new JLabel("ON CAMERA SENSOR");
    private final JPanel fakeSensorsPanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    /* camera protection panel */
    private final JPanel cpsPanel = new JPanel();
    private final JPanel keysPanel = new JPanel();
    private final DigitalSwitch onCameraDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch ap2Switch = new DigitalSwitch();
    private final DigitalSwitch af0Switch = new DigitalSwitch();
    private final DigitalSwitch af1Switch = new DigitalSwitch();
    private final DigitalSwitch af3Switch = new DigitalSwitch();
    private final DigitalSwitch keyLockSwitch = new DigitalSwitch();
    private final DigitalSwitch keyEngSwitch = new DigitalSwitch();
    /* Homing panel */
    private final JPanel homingPanel = new JPanel();
    private final JLabel clhomLabel = new JLabel("Clamp controller homing:");
    private final JLabel cahomLabel = new JLabel("Carrier controller homing:");
    private final JLabel clampHomingLabel = new JLabel();
    private final JLabel carrierHomingLabel = new JLabel();
    
    //control panel    
    private final JButton loadFilterButton = new JButton("loadFilterInCamera");
    private final JButton unloadFilterButton = new JButton("unloadFilterFromCamera");
    // End of variables declaration 
    
    /**
     * A Runnable To updateState the general items for loader.
     */
    class UpdateLoaderGeneral implements Runnable {

        private final StatusDataPublishedByLoader s;

        UpdateLoaderGeneral(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {

            if (s.isLoaderOnCameraSensorsInError()) {
                onCameraDigitalSwitch.setColor(Color.RED);
            } else {
                onCameraDigitalSwitch.setColor(s.isLoaderOnCameraSensorValue() ? greenColor : Color.gray);
            }
            if (s.isAf0InError()) {
                af0Switch.setColor(Color.RED);
            } else if (s.isAf0()) {
                af0Switch.setColor(greenColor);
            } else {
                af0Switch.setColor(Color.gray);
            }
            
            if (s.isAf1InError()) {
                af1Switch.setColor(Color.RED);
            } else if (s.isAf1()) {
                af1Switch.setColor(greenColor);
            } else {
                af1Switch.setColor(Color.gray);
            } 
            
            if (s.isAf3InError()) {
                af3Switch.setColor(Color.RED);
            } else if (s.isAf3()) {
                af3Switch.setColor(greenColor);
            } else {
                af3Switch.setColor(Color.gray);
            }   
            
            if (s.isAp2InError()) {
                ap2Switch.setColor(Color.RED);
            } else if (s.isAp2()) {
                ap2Switch.setColor(greenColor);
            } else {
                ap2Switch.setColor(Color.gray);
            }        
            
            
            if (s.isKeyEngInError() && !s.isKeyEng()) {
                //EngineringKey is not turn on, so we are in mode normal.
                //The 2 sensors returns value 0.
                keyEngSwitch.setColor(Color.BLUE);
            } else if (s.isKeyEngInError()) {
                keyEngSwitch.setColor(Color.RED);
            } else if (s.isKeyEng()) {
                keyEngSwitch.setColor(Color.ORANGE);
            } 
            
            if (s.isKeyLockInError()) {
                keyLockSwitch.setColor(Color.RED);
            } else if (s.isKeyLock()) {
                keyLockSwitch.setColor(greenColor);
            } else {
                keyLockSwitch.setColor(Color.gray);
            }            
        }
    }
    
    /**
     * A Runnable to update this panel from data published on the status bus from the Loader Clamp.
     */
    private class UpdateClamp implements Runnable {

        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {

            if (s.isHomingDone()) {
                clampHomingLabel.setText("DONE");
                clampHomingLabel.setForeground(greenColor);
            } else {
                clampHomingLabel.setText("NOT DONE");
                clampHomingLabel.setForeground(Color.red);
            }
        }
    }

    /**
     * A constructor without any argument for tests.
     */
    public LoaderGeneralViewPanel() {
        initComponents();
    }
    
    

    /**
     * A constructor with a LoaderGUI.
     * @param subs 
     */
    public LoaderGeneralViewPanel(InterfaceLoaderGUI subs) {
        this.subs = subs;
        initComponents();
    }

    public void setSubsystem(InterfaceLoaderGUI subs) {
        this.subs = subs;
    }
    
    /**
     * Initialize this Panel from Configuration Info data.
     * TODO : initialize timeouts for commands unloadFilter and loadFilter ?
     * @param configInfo 
     */
    public void initializeGui(ConfigurationInfo configInfo) {
        //TODO if needed : SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }
    
    
    /**
     * To update the Panel when the loader publishes on the bus its global status.
     * @param status 
     */
    public void updateLoaderGeneral(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateLoaderGeneral(status));
    }
        
    /**
     * To update the Homing Panel when the loader clamp publishes on the bus. 
     * @param status
     */
    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }
    
    /**
     * To initialize all the components of this Panel.
     */
    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "LOADER"));
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        
        /**********************/
        /* Homing Panel       */
        /**********************/
        homingPanel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 2));
        homingPanel.setLayout(new GridBagLayout());
        clampHomingLabel.setFont(BIG_FONT);
        carrierHomingLabel.setFont(BIG_FONT);
        GridBagConstraints gbc6 = new GridBagConstraints();
        gbc6.insets = insets_std;
        gbc6.gridx = 0;
        gbc6.gridy = 0; 
        homingPanel.add(clhomLabel, gbc6);
        gbc6.gridx++;
        homingPanel.add(clampHomingLabel, gbc6);
        gbc6.gridx = 0;
        gbc6.gridy++;
        homingPanel.add(cahomLabel, gbc6);
        gbc6.gridx++;
        homingPanel.add(carrierHomingLabel, gbc6);
        /**********************/
        /* end of Homing Panel*/
        /**********************/

        /**
         ******************************************************************************
         ** Control Panel
         * *****************************************************************************
         */
        loadFilterButton.addActionListener((ActionEvent evt) -> {
            loadFilterActionPerformed(evt);
        });

        unloadFilterButton.addActionListener((ActionEvent evt) -> {
            unloadFilterActionPerformed(evt);
        });
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.fill = GridBagConstraints.HORIZONTAL;
        controlPanel.add(loadFilterButton, gbc0);
        gbc0.gridy++;
        controlPanel.add(unloadFilterButton, gbc0);
         //end of Control Panel

        //Fake Sensors Panel 
        fakeSensorsPanel.setBorder(BorderFactory.createTitledBorder("On camera"));
        fakeSensorsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = GridBagConstraints.HORIZONTAL;
        fakeSensorsPanel.add(onCameraLabel, gbc1);

        gbc1.gridx++;
        fakeSensorsPanel.add(onCameraDigitalSwitch, gbc1);
        //end Fake Sensors Panel 
        
        //CameraProtectionPanel with status coming from autochanger
        cpsPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA,WIDTH + 5));
        cpsPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.WEST;
        gbc0.insets = insets_std;
        cpsPanel.add(new JLabel("AP2 (AC at handoff)"), gbc0);
        gbc0.gridy++;
        cpsPanel.add(new JLabel("AF0 (AC latches opened)"), gbc0);       
        gbc0.gridy++;
        cpsPanel.add(new JLabel("AF1 (filter detected in AC)"), gbc0); 
        gbc0.gridy++;
        cpsPanel.add(new JLabel("AF3 (filter locked in AC)"), gbc0);
        
        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.EAST;
        cpsPanel.add(ap2Switch, gbc0);
        gbc0.gridy++;
        cpsPanel.add(af0Switch, gbc0);
        gbc0.gridy++;
        cpsPanel.add(af1Switch, gbc0);
        gbc0.gridy++;
        cpsPanel.add(af3Switch, gbc0);
        
        //keys Panel : key lock/permit, engineering key ...
        keysPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA,WIDTH + 5));
        keysPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.WEST;
        gbc0.insets = insets_std;
        keysPanel.add(new JLabel("keyLock/permit"), gbc0);
        gbc0.gridy++;
        keysPanel.add(new JLabel("Engineering key"), gbc0);
        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.EAST;
        keysPanel.add(keyLockSwitch, gbc0);        
        gbc0.gridy++;
        keysPanel.add(keyEngSwitch, gbc0);
        
        //Whole Panel
        GridBagConstraints gbc = new GridBagConstraints();
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), 
                "LOADER General View"));
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(cpsPanel, gbc);
        gbc.gridx++;
        add(keysPanel,gbc);
        gbc.gridx--;
        gbc.gridy++;
        add(homingPanel, gbc);
        gbc.gridy++;
        add(controlPanel, gbc);
        gbc.gridy++;
        gbc.gridwidth = 2;
        add(fakeSensorsPanel, gbc);
        
        setDefaultValues();
    }
    
    private void setDefaultValues() {
        onCameraDigitalSwitch.setColor(Color.gray);
        ap2Switch.setColor(Color.gray);
        af0Switch.setColor(Color.gray);
        af1Switch.setColor(Color.gray);
        af3Switch.setColor(Color.gray);
        keyLockSwitch.setColor(Color.gray);
        keyEngSwitch.setColor(Color.gray);
        clampHomingLabel.setText("TO BE DONE");
        clampHomingLabel.setForeground(Color.red);
        carrierHomingLabel.setText("TO BE DONE");
        carrierHomingLabel.setForeground(Color.red);
    }
    
    /**
     * Reset components to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }
    
    private void loadFilterActionPerformed(ActionEvent evt) {
        subs.loadFilter();
    }

    private void unloadFilterActionPerformed(ActionEvent evt) {
        subs.unloadFilter();
    }
    
    /**
     * To be displayed on the GUI. 
     * @return 
     */
    @Override
    public String toString() {
        return "Loader General View Panel";
    }
    
    /**
     * Just for tests.
     * @param args 
     */
    public static void main(String[] args) {
        LoaderGeneralViewPanel d = new LoaderGeneralViewPanel();
        JFrame frame = new JFrame("LoaderGeneralViewPanel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
