
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import static java.awt.image.ImageObserver.WIDTH;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.ZERO_VALUE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_small;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class AutochangerGeneralViewPanel extends JPanel {
    private static final long serialVersionUID = -713173978095339372L;
    
    private InterfaceAutochangerGUI subs;

    //LoaderConnectedPanel
    private final JPanel loaderStatusPanel = new JPanel();
    private final DigitalSwitch loader_LPS_Switch = new DigitalSwitch();
    private final DigitalSwitch loader_LRH_Switch = new DigitalSwitch();
    private final DigitalSwitch carousel_CFC_Switch = new DigitalSwitch(); //Carousel_CFC
    private final DigitalSwitch carousel_CS_Switch = new DigitalSwitch(); //Carousel_CS
    private final DigitalSwitch carousel_CF0_Switch = new DigitalSwitch(); //Carousel_CF0
    private final DigitalSwitch carousel_CF1_Switch = new DigitalSwitch(); //Carousel_CF1
    
    //Local Protection Module
    private final JPanel lpmStatusPanel = new JPanel();
    private final DigitalSwitch enableRailLinMasterSwitch = new DigitalSwitch();
    private final DigitalSwitch enableRailLinSlaveSwitch = new DigitalSwitch();
    private final DigitalSwitch enableClampsSwitch = new DigitalSwitch();
    private final DigitalSwitch enableLatchesSwitch = new DigitalSwitch();
    
    private final JPanel latchesStatePanel = new JPanel();
    private final JPanel clampsStatePanel = new JPanel();
    private final FilterPanel filterPanel = new FilterPanel();
    private final JPanel inclinometersPanel = new JPanel();
    private final JPanel carouselStatusPanel = new JPanel();

    private JPanel trucksStatePanel;
    private final DigitalSwitch standbyDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inTravelDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch handoffDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch onlineDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inErrorDigitalSwitch = new DigitalSwitch();
    private final JLabel standbyjLabel = new JLabel("STANDBY");
    private final JLabel inTraveljLabel = new JLabel("In Travel");
    private final JLabel handoffjLabel = new JLabel("HAND-OFF");
    private final JLabel onlinejLabel = new JLabel("ONLINE");
    private final JLabel inErrorjLabel = new JLabel("IN ERROR");
    private final JButton moveAndClampButton = new JButton("moveAndClampFilterOnline");
    private final JButton goToStandbyButton = new JButton("goToStandby");
    private final JButton goToHandoffButton = new JButton("goToHandOff");
    private final JButton goToOnlineButton = new JButton("goToOnline");   

    /* Clamps Panel*/
    private final JLabel clampsStateLabel = new JLabel();
    
    /* Latches Panel*/
    private final JLabel latchesStateLabel = new JLabel();
    private final JButton closeLatchesButton = new JButton("Close Latches");
    private final JButton openLatchesButton = new JButton("Open Latches");    
    
    /* Trucks Panel*/
    private final JLabel trucksPositionLabel = new JLabel();
    
    /* Inclinometer Panel*/
    private final JLabel inclXminusLabel = new JLabel();
    private final JLabel inclXplusLabel = new JLabel();
    
    /* Control Panel*/
    private final JPanel clampsPanel = new JPanel();
    private final JButton closeAndLockClampsButton = new JButton("Close and Lock Clamps");
    private final JButton unlockAndOpenClampsButton = new JButton("Unlock and Open Clamps");


    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by the autochanger
     */
    private class UpdateAutochanger implements Runnable {

        private StatusDataPublishedByAutoChanger s;

        public UpdateAutochanger(StatusDataPublishedByAutoChanger status) {
            this.s = status;
        }

        @Override
        public void run() {
            /*Loader_LPS (=1 if loader is at Storage, loader connected) */
            loader_LPS_Switch.updateColor(s.isLoaderConnectedSensorsInError(), 
                    s.getLoaderConnectedSensorValue());

            /*Loader_LRH (=1 if loader is holding filter at HANDOFF) */
            loader_LRH_Switch.updateColor(false, s.isLoaderHoldingFilterAtHandoff());
            
            inclXminusLabel.setText(String.valueOf(s.getInclinaisonXminus()));
            inclXplusLabel.setText(String.valueOf(s.getInclinaisonXplus()));
            
            /*Carousel_CFC (=1 if if filter is clamped on carousel) */
            carousel_CFC_Switch.updateColor(s.isCarouselHoldingFilterInError(), 
                    s.isCarouselHoldingFilter());
            
            /*Carousel_CS (=1 if carousel is stopped at standby) */ 
            carousel_CS_Switch.updateColor(s.isCarousel_CS_InError(), s.isCarousel_CS());
            
            /*Carousel_CF0 (=1 if no filter in carousel socket) */
            carousel_CF0_Switch.updateColor(s.isCarousel_CF0_InError(), s.isCarousel_CF0());

            /*Carousel_CF1 (=1 if filter locked in carousel socket) */
            carousel_CF1_Switch.updateColor(s.isCarousel_CF1_InError(), s.isCarousel_CF1());
            
            /* Local Protection Signals generated by AC */
            /* 0 : motion forbidden, 1: motion permitted */
            enableRailLinMasterSwitch.updateColor(false, s.isEnableRailLin1());
            enableRailLinSlaveSwitch.updateColor(false, s.isEnableRailLin2());
            enableClampsSwitch.updateColor(false, s.isEnableClamps());
            enableLatchesSwitch.updateColor(false, s.isEnableLatches());
                
        }
    }

    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by autochanger trucks.
     */
    private class UpdateTrucks implements Runnable {

        private StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            trucksPositionLabel.setText(String.valueOf(s.getMasterPosition()));
            handoffDigitalSwitch.setColor(s.isAtHandoff() ? greenColor : Color.gray);

            onlineDigitalSwitch.setColor(s.isAtOnline() ? greenColor : Color.gray);

            standbyDigitalSwitch.setColor(s.isAtStandby() ? greenColor : Color.gray);
            
            //ERROR Digital Switch is red as soon as there is an error 
            //on the carrier position sensors.            
            inErrorDigitalSwitch.setColor(s.isInError() ? Color.RED : greenColor);
            inErrorjLabel.setText(s.isInError() ? "IN ERROR" : "NO ERROR");
            
            inTravelDigitalSwitch.setColor((!s.isAtHandoff()
                    && !s.isAtOnline() && !s.isAtStandby()) ? Color.YELLOW : Color.gray);
        }
    }

    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by autochanger latches.
     */
    class UpdateLatches implements Runnable {

        private StatusDataPublishedByAutochangerTwoLatches s;

        public UpdateLatches(StatusDataPublishedByAutochangerTwoLatches status) {
            this.s = status;
        }

        @Override
        public void run() {
            latchesStateLabel.setText(s.getLockStatus().toString());
            latchesStateLabel.setForeground(s.getLockStatus().getColor());
            filterPanel.setIsFilterInHouse(s.getFilterPresenceStatus().equals(FcsEnumerations.FilterPresenceStatus.ENGAGED),
                    s.getFilterName());
            if (s.getFilterPresenceStatus().equals(FcsEnumerations.FilterPresenceStatus.UNKNOWN)) {
                filterPanel.setColor(Color.YELLOW);
            }
        }
    }

    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by autochanger ONLINE clamps.
     */
    class UpdateClamps implements Runnable {

        private StatusDataPublishedByAutochangerThreeClamps s;

        public UpdateClamps(StatusDataPublishedByAutochangerThreeClamps status) {
            this.s = status;
        }

        @Override
        public void run() {
            clampsStateLabel.setText(s.getLockStatus().toString());
            clampsStateLabel.setForeground(s.getLockStatus().getColor());
        }
    }

    public AutochangerGeneralViewPanel() {
        initComponents();
    }
    
    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
    }

    //TODO
    void initializeGui(ConfigurationInfo configInfo) {
    }

    void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        SwingUtilities.invokeLater(new UpdateAutochanger(s));
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        SwingUtilities.invokeLater(new UpdateTrucks(s));
    }

    void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        SwingUtilities.invokeLater(new UpdateLatches(s));
    }

    void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        SwingUtilities.invokeLater(new UpdateClamps(s));
    }

    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {
        
        /**
         ******************************************************************************
         ** Buttons initialization
         * *****************************************************************************
         */

        closeAndLockClampsButton.addActionListener((ActionEvent evt) -> {
            closeAndLockClampsButtonActionPerformed(evt);
        });

        unlockAndOpenClampsButton.addActionListener((ActionEvent evt) -> {
            unlockAndOpenClampsButtonActionPerformed(evt);
        });
        
        closeLatchesButton.addActionListener((ActionEvent evt) -> {
            closeLatchesButtonActionPerformed(evt);
        });

        
        openLatchesButton.addActionListener((ActionEvent evt) -> {
            openLatchesButtonActionPerformed(evt);
        });
        
        goToHandoffButton.addActionListener(this::goToHandoffActionPerformed);

        goToOnlineButton.addActionListener(this::goToOnlineActionPerformed);

        goToStandbyButton.addActionListener(this::goToStandbyActionPerformed);
        
        moveAndClampButton.addActionListener(this::moveAndClampFilterOnlineActionPerformed);

        /**
         ******************************************************************************
         ** end of Buttons initialization
         * *****************************************************************************
         */        

        //LoaderConnectedPanel
        loaderStatusPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, WIDTH + 5));
        loaderStatusPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.WEST;
        gbc0.insets = insets_std;
        loaderStatusPanel.add(new JLabel("Loader_LPS (loader connected)"), gbc0);
        gbc0.gridy++;
        loaderStatusPanel.add(new JLabel("Loader_LRH (loader holds filter)"), gbc0);

        gbc0.gridy = 0;
        gbc0.gridx = 1;
        gbc0.anchor = GridBagConstraints.EAST;
        loaderStatusPanel.add(loader_LPS_Switch, gbc0);
        gbc0.gridy++;
        loaderStatusPanel.add(loader_LRH_Switch, gbc0);
        
        //CarouselHoldingFilterPanel
        carouselStatusPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA,WIDTH + 5));
        carouselStatusPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.insets = insets_std;
        gbc0.anchor = GridBagConstraints.WEST;
        carouselStatusPanel.add(new JLabel("Carousel_CFC (filter clamped)"), gbc0);
        gbc0.gridy++;
        carouselStatusPanel.add(new JLabel("Carousel_CS (socket stop at Standby)"), gbc0);       
        gbc0.gridy++;
        carouselStatusPanel.add(new JLabel("Carousel_CF0 (no filter)"), gbc0); 
        gbc0.gridy++;
        carouselStatusPanel.add(new JLabel("Carousel_CF1 (filter on socket)"), gbc0);
        
        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.EAST;
        carouselStatusPanel.add(carousel_CFC_Switch, gbc0); //CFC
        gbc0.gridy++;
        carouselStatusPanel.add(carousel_CS_Switch, gbc0);
        gbc0.gridy++;
        carouselStatusPanel.add(carousel_CF0_Switch, gbc0);
        gbc0.gridy++;
        carouselStatusPanel.add(carousel_CF1_Switch, gbc0);        
        
        //Local Protection Module Panel
        Border border = BorderFactory.createLineBorder(Color.BLUE,WIDTH + 5);
        lpmStatusPanel.setBorder(BorderFactory.createTitledBorder(border, "Local Protection Module"));
        lpmStatusPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.insets = insets_big;
        gbc0.anchor = GridBagConstraints.WEST;
        lpmStatusPanel.add(new JLabel("Enable Rail Linear1"), gbc0);
        gbc0.gridy++;
        lpmStatusPanel.add(new JLabel("Enable Rail Linear2"), gbc0);       

        
        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.EAST;
        lpmStatusPanel.add(enableRailLinMasterSwitch, gbc0);
        gbc0.gridy++;
        lpmStatusPanel.add(enableRailLinSlaveSwitch, gbc0);
 
        
        gbc0.gridx = 2;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.WEST;
        lpmStatusPanel.add(new JLabel("Enable Clamps"), gbc0); 
        gbc0.gridy++;
        lpmStatusPanel.add(new JLabel("Enable Latches"), gbc0);
        
        gbc0.gridx = 3;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.EAST;
        lpmStatusPanel.add(enableClampsSwitch, gbc0);
        gbc0.gridy++;
        lpmStatusPanel.add(enableLatchesSwitch, gbc0);        

        //latches state Panel
        latchesStatePanel.setBorder(BorderFactory.createTitledBorder("Latches"));
        latchesStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = GridBagConstraints.HORIZONTAL;
        latchesStatePanel.add(latchesStateLabel, gbc1);
        gbc1.gridy++;
        latchesStatePanel.add(closeLatchesButton, gbc1);
        gbc1.gridy++;
        latchesStatePanel.add(openLatchesButton, gbc1);
        
        //inclinometers Panel
        inclinometersPanel.setLayout(new GridBagLayout());
        inclinometersPanel.setBorder(BorderFactory.createTitledBorder("Inclinometers"));
        gbc0 = new GridBagConstraints();
        gbc0.insets = insets_small;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.WEST;
        inclinometersPanel.add(new JLabel("InclinometerXminus"), gbc0);
        gbc0.gridy++;
        gbc0.insets = insets_small;
        inclinometersPanel.add(this.inclXminusLabel, gbc0);   
        gbc0.gridy = 0;        
        gbc0.gridx++;
        gbc0.insets = new Insets(1,48,1,1);
        gbc0.anchor = GridBagConstraints.EAST;
        inclinometersPanel.add(new JLabel("InclinometerXplus"), gbc0);
        gbc0.gridy++;
        inclinometersPanel.add(this.inclXplusLabel, gbc0);

        //filter panel
        filterPanel.setSize(120);

        //trucks Panel
        trucksStatePanel = new JPanel();
        trucksStatePanel.setBorder(BorderFactory.createTitledBorder("Trucks State"));
        trucksStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_big;

        gbc2.gridx = 0;
        gbc2.gridy = 0;
        trucksStatePanel.add(new JLabel("Trucks position:"), gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(trucksPositionLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(inErrorDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(inErrorjLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(inTravelDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(inTraveljLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(standbyDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(standbyjLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(handoffDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(handoffjLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(onlineDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(onlinejLabel, gbc2);
        
        gbc2.gridx = 1;
        gbc2.insets = insets_small;
        gbc2.gridwidth = 5;
        gbc2.fill = GridBagConstraints.HORIZONTAL;
        gbc2.gridy++;
        trucksStatePanel.add(moveAndClampButton, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(goToOnlineButton, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(goToHandoffButton, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(goToStandbyButton, gbc2);
        //clamps state Panel
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        clampsStatePanel.add(new JLabel("LockStatus:"), gbc3);
        gbc3.gridx++;
        clampsStatePanel.add(clampsStateLabel, gbc3);
        
        /**
         ******************************************************************************
         ** Clamps Panel
         * *****************************************************************************
         */
        clampsPanel.setLayout(new GridBagLayout());
        clampsPanel.setBorder(BorderFactory.createTitledBorder("ONLINE clamps"));
        gbc3 = new GridBagConstraints();
        gbc3.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc3.fill = GridBagConstraints.HORIZONTAL;
        gbc3.insets = insets_small;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        clampsPanel.add(clampsStatePanel, gbc3);
        gbc3.gridy++;
        clampsPanel.add(closeAndLockClampsButton, gbc3);
        gbc3.gridy++;
        clampsPanel.add(unlockAndOpenClampsButton, gbc3);        
        /**
         ******************************************************************************
         ** End of Control Panel
         * *****************************************************************************
         */

        //Whole Panel
        GridBagConstraints gbc = new GridBagConstraints();
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), 
                "AUTOCHANGER General View"));
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(carouselStatusPanel, gbc);
        gbc.gridx++;
        gbc.gridwidth = 2;
        gbc.anchor = GridBagConstraints.EAST;
        add(loaderStatusPanel, gbc);
        
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 4;
        add(lpmStatusPanel, gbc);
        
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        gbc.gridx = 0;
        gbc.gridy++; 
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        add(inclinometersPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 1;
        
        add(latchesStatePanel, gbc);
        gbc.gridx++;
        add(filterPanel, gbc);
        gbc.gridx++;
        add(clampsPanel, gbc);
        
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        add(trucksStatePanel, gbc);
        setDefaultValues();
    }
    
    /**
     * set default values for components color and labels.
     */
    private void setDefaultValues() {
        //Inclinometers Panel
        inclXminusLabel.setText(ZERO_VALUE);
        inclXplusLabel.setText(ZERO_VALUE);
        //LoaderConnectedPanel
        loader_LPS_Switch.setColor(Color.GRAY);   
        loader_LRH_Switch.setColor(Color.GRAY);
        carousel_CFC_Switch.setColor(Color.GRAY);//CFC
        carousel_CS_Switch.setColor(Color.GRAY);
        carousel_CF0_Switch.setColor(Color.GRAY);
        carousel_CF1_Switch.setColor(Color.GRAY);
        //LPM status Panel
        enableRailLinMasterSwitch.setColor(Color.GRAY);
        enableRailLinSlaveSwitch.setColor(Color.GRAY);        
        enableClampsSwitch.setColor(Color.GRAY);
        enableLatchesSwitch.setColor(Color.GRAY);

        //filter panel
        filterPanel.setIsFilterInHouse(false,"NONE");
        filterPanel.setColor(Color.gray);
         //trucks Panel
        standbyDigitalSwitch.setColor(Color.gray);
        inTravelDigitalSwitch.setColor(Color.gray);
        handoffDigitalSwitch.setColor(Color.gray);
        onlineDigitalSwitch.setColor(Color.gray);
        inErrorDigitalSwitch.setColor(Color.gray);
        trucksPositionLabel.setText(ZERO_VALUE);
        
        clampsStateLabel.setText(UNKNOWN_STATE);
        latchesStateLabel.setText(UNKNOWN_STATE);

    }
    
    /**
     * Reset Panels to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    @Override
    public String toString() {
        return "General View";
    }
    
    private void closeAndLockClampsButtonActionPerformed(ActionEvent evt) {
        subs.closeAndLockOnlineClamps();
    }

    private void unlockAndOpenClampsButtonActionPerformed(ActionEvent evt) {
        subs.unlockAndOpenOnlineClamps();
    }
    
    private void closeLatchesButtonActionPerformed(ActionEvent evt) {
        subs.closeLatches();
    }

    
    private void openLatchesButtonActionPerformed(ActionEvent evt) {
        subs.openLatches();
    }
    
    private void goToHandoffActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acGoToHandOff();
    }

    private void goToOnlineActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acGoToOnline();
    }

    private void goToStandbyActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acGoToStandby();
    }    
    
    private void moveAndClampFilterOnlineActionPerformed(ActionEvent evt) {
        subs.acMoveAndClampFilterOnline();
    }

    public static void main(String[] argv) {

        AutochangerGeneralViewPanel d = new AutochangerGeneralViewPanel();
        JFrame frame = new JFrame("Autochanger GeneralView Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
