/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.gconsole.plugins.commandbrowser.HintTextField;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSParametersPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class EPOSControllerPanel
extends JPanel {
    private static final long serialVersionUID = 2482213337630248322L;
    private InterfaceGeneralGUI subs;
    private final String controllerName;
    private final CanOpenDevicePanel generalInfoPanel;
    private final JPanel faultPanel = new JPanel();
    private final DigitalSwitch faultSwitch = new DigitalSwitch();
    private final JLabel errorRegisterLabel = new JLabel("99=XXXXXXXX error");
    private final JLabel errorHistoryLabel = new JLabel();
    private final JPanel modePanel = new JPanel();
    private final JLabel modeLabel = new JLabel("UNKNOWN");
    private final JPanel controlPanel = new JPanel();
    private final JButton checkFaultButton = new JButton("CheckFault");
    private final JButton faultResetButton = new JButton("FaultReset");
    private final JButton refreshButton = new JButton("Refresh");
    private final JPanel changeParameterPanel = new JPanel();
    private final HintTextField keyArea = new HintTextField("String");
    private final HintTextField valueArea = new HintTextField("int");
    private final JLabel keyLabel = new JLabel("parameter name");
    private final JLabel valueLabel = new JLabel("parameter value");
    private final JButton changeParameterButton = new JButton("ChangeEPOSParameter");
    private final JButton saveParametersButton = new JButton("Save EPOSParameters in Controller CPU");
    private final JPanel enablePanel = new JPanel();
    private final JLabel enableLabel = new JLabel();
    private final DigitalSwitch enableSwitch = new DigitalSwitch();
    private final JButton enableButton = new JButton("Enable");
    private final JButton disableButton = new JButton("Disable");
    private final JLabel brakeLabel = new JLabel();
    private final EPOSParametersPanel currentParamsPanel = new EPOSParametersPanel();
    private final EPOSParametersPanel profile_positionParamsPanel = new EPOSParametersPanel();
    private final EPOSParametersPanel homingParamsPanel = new EPOSParametersPanel();

    public EPOSControllerPanel(String controllerName) {
        this.controllerName = controllerName;
        this.generalInfoPanel = new CanOpenDevicePanel(controllerName);
        this.initComponents();
    }

    public void setSubsystem(InterfaceGeneralGUI newSubs) {
        this.subs = newSubs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateController(String name, StatusDataPublishedByEPOSController status) {
        if (this.controllerName.equals(name)) {
            SwingUtilities.invokeLater(new UpdateController(status));
        }
    }

    private void initComponents() {
        this.setDefaultValues();
        this.checkFaultButton.addActionListener(evt -> this.checkFaultActionPerformed(evt));
        this.faultResetButton.addActionListener(evt -> this.faultResetActionPerformed(evt));
        this.refreshButton.addActionListener(evt -> this.refreshActionPerformed());
        this.changeParameterButton.addActionListener(evt -> this.changeParameterActionPerformed());
        this.saveParametersButton.addActionListener(evt -> this.saveParametersActionPerformed());
        this.enableButton.addActionListener(evt -> this.enableActionPerformed());
        this.disableButton.addActionListener(evt -> this.disableActionPerformed());
        this.modePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Tools.nicePink), "EPOS mode"));
        this.modePanel.setPreferredSize(new Dimension(160, 50));
        this.modePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 21;
        this.modeLabel.setFont(Tools.BIG_FONT);
        this.modePanel.add((Component)this.modeLabel, gbc2);
        this.faultPanel.setBorder(BorderFactory.createTitledBorder("Error"));
        this.faultPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 10;
        this.faultPanel.add((Component)this.faultSwitch, gbc1);
        ++gbc1.gridy;
        this.faultSwitch.setColor(Color.GRAY);
        this.errorRegisterLabel.setFont(Tools.BIG_FONT);
        this.faultPanel.add((Component)this.errorRegisterLabel, gbc1);
        ++gbc1.gridy;
        this.faultPanel.add((Component)new JLabel("Error History:"), gbc1);
        ++gbc1.gridy;
        this.faultPanel.add((Component)this.errorHistoryLabel, gbc1);
        this.enablePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE), "Enable/Disable"));
        this.enablePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc5 = new GridBagConstraints();
        gbc5.insets = Tools.insets_std;
        gbc5.gridx = 0;
        gbc5.gridy = 0;
        this.enablePanel.add((Component)this.enableSwitch, gbc5);
        ++gbc5.gridx;
        this.enablePanel.add((Component)this.enableLabel, gbc5);
        gbc5.gridx = 0;
        ++gbc5.gridy;
        gbc5.insets = Tools.insets_small;
        this.enablePanel.add((Component)this.enableButton, gbc5);
        ++gbc5.gridx;
        this.enablePanel.add((Component)this.brakeLabel, gbc5);
        gbc5.gridx = 0;
        ++gbc5.gridy;
        this.enablePanel.add((Component)this.disableButton, gbc5);
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.anchor = 23;
        gbc4.fill = 2;
        gbc4.insets = Tools.insets_small;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        this.controlPanel.add((Component)this.refreshButton, gbc4);
        ++gbc4.gridy;
        this.controlPanel.add((Component)this.checkFaultButton, gbc4);
        ++gbc4.gridy;
        this.controlPanel.add((Component)this.faultResetButton, gbc4);
        this.changeParameterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Tools.nicePink), "change EPOS parameters"));
        this.changeParameterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.fill = 2;
        gbc3.anchor = 21;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        this.changeParameterPanel.add((Component)this.keyLabel, gbc3);
        ++gbc3.gridx;
        this.keyArea.setColumns(20);
        gbc3.anchor = 22;
        this.changeParameterPanel.add((Component)this.keyArea, gbc3);
        gbc3.gridx = 0;
        ++gbc3.gridy;
        gbc3.anchor = 21;
        this.changeParameterPanel.add((Component)this.valueLabel, gbc3);
        ++gbc3.gridx;
        gbc3.anchor = 22;
        this.changeParameterPanel.add((Component)this.valueArea, gbc3);
        gbc3.gridx = 0;
        ++gbc3.gridy;
        gbc3.gridwidth = 2;
        gbc3.fill = 24;
        gbc3.insets = Tools.insets_small;
        this.changeParameterPanel.add((Component)this.changeParameterButton, gbc3);
        ++gbc3.gridy;
        this.changeParameterPanel.add((Component)this.saveParametersButton, gbc3);
        this.setBorder(BorderFactory.createLineBorder(Color.GREEN));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.add((Component)this.generalInfoPanel, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        this.add((Component)this.faultPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.modePanel, gbc);
        gbc.gridy = 2;
        this.add((Component)this.enablePanel, gbc);
        gbc.gridy = 1;
        ++gbc.gridx;
        gbc.gridwidth = 3;
        gbc.gridheight = 2;
        gbc.fill = 2;
        this.add((Component)this.changeParameterPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        this.add((Component)this.currentParamsPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.profile_positionParamsPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.homingParamsPanel, gbc);
    }

    private void setDefaultValues() {
        this.enableSwitch.setColor(Color.GRAY);
        this.faultSwitch.setColor(Color.GRAY);
        this.errorRegisterLabel.setText("UNKNOWN");
        this.errorHistoryLabel.setText("UNKNOWN");
        this.enableLabel.setText("UNKNOWN");
        this.modeLabel.setText("UNKNOWN");
        this.brakeLabel.setText("");
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.generalInfoPanel.resetPanel();
        this.currentParamsPanel.resetPanel();
        this.homingParamsPanel.resetPanel();
        this.profile_positionParamsPanel.resetPanel();
    }

    private void checkFaultActionPerformed(ActionEvent evt) {
        this.subs.sendCommandSwingWorker("checkFault", 1000L, this.controllerName);
    }

    private void faultResetActionPerformed(ActionEvent evt) {
        this.subs.sendCommandSwingWorker("faultReset", 1000L, this.controllerName);
    }

    private void refreshActionPerformed() {
        this.subs.sendCommandSwingWorker("publishData", 1000L, this.controllerName);
    }

    private void changeParameterActionPerformed() {
        if (this.valueArea.getText() == null) {
            throw new IllegalArgumentException(this.valueArea.getText() + " is not a valid value. Please enter a decimal value.");
        }
        this.subs.sendCommandSwingWorker("changeEPOSParameter " + this.keyArea.getText() + " " + this.valueArea.getText(), 1000L, this.controllerName);
    }

    private void saveParametersActionPerformed() {
        this.subs.sendCommandSwingWorker("saveParameters", 1000L, this.controllerName);
    }

    private void enableActionPerformed() {
        this.subs.sendCommandSwingWorker("enable", 1000L, this.controllerName);
    }

    private void disableActionPerformed() {
        this.subs.sendCommandSwingWorker("disableVoltage", 1000L, this.controllerName);
    }

    @Override
    public String toString() {
        if (this.controllerName == null) {
            return "Unamed Controller Panel";
        }
        return this.controllerName;
    }

    public static void main(String[] argv) {
        EPOSControllerPanel p = new EPOSControllerPanel("myController");
        JFrame frame = new JFrame("EPOS Controller");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateController
    implements Runnable {
        private StatusDataPublishedByEPOSController s;

        public UpdateController(StatusDataPublishedByEPOSController status) {
            this.s = status;
        }

        @Override
        public void run() {
            EPOSControllerPanel.this.generalInfoPanel.updateCanOpenDevice(EPOSControllerPanel.this.controllerName, this.s);
            if (this.s.getMode() != null) {
                EPOSControllerPanel.this.modeLabel.setText(this.s.getMode().toString());
            }
            if (this.s.isInitialized()) {
                EPOSControllerPanel.this.faultSwitch.setColor(this.s.isInError() ? Color.RED : Tools.greenColor);
                EPOSControllerPanel.this.errorRegisterLabel.setText(this.s.getErrorRegister());
                int[] historyList = this.s.getErrorHistory();
                if (historyList == null || historyList.length == 0) {
                    EPOSControllerPanel.this.errorHistoryLabel.setText("no error");
                } else {
                    StringBuilder sb = new StringBuilder("<html>");
                    for (int i = 0; i < this.s.getErrorHistory().length; ++i) {
                        if (i > 0) {
                            sb.append("<br>");
                        }
                        sb.append(Integer.toHexString(historyList[i]));
                        sb.append("<br>");
                    }
                    sb.append("</html>");
                    EPOSControllerPanel.this.errorHistoryLabel.setText(sb.toString());
                }
            } else if (this.s.isBooted()) {
                EPOSControllerPanel.this.faultSwitch.setColor(Color.ORANGE);
                EPOSControllerPanel.this.errorRegisterLabel.setText("Not initialized");
            } else {
                EPOSControllerPanel.this.faultSwitch.setColor(Color.RED);
                EPOSControllerPanel.this.errorRegisterLabel.setText("Not booted");
            }
            if (!this.s.isBooted()) {
                EPOSControllerPanel.this.enableSwitch.setColor(Color.RED);
                EPOSControllerPanel.this.enableLabel.setText("<HTML><CENTER>Controller is<BR>not booted</CENTER></HTML>");
            } else if (this.s.isEnabled()) {
                EPOSControllerPanel.this.enableSwitch.setColor(Tools.greenColor);
                EPOSControllerPanel.this.enableLabel.setText("<HTML><CENTER>Controller is<BR>enabled</CENTER></HTML>");
            } else {
                EPOSControllerPanel.this.enableSwitch.setColor(Color.ORANGE);
                EPOSControllerPanel.this.enableLabel.setText("<HTML><CENTER>Controller is<BR>disabled</CENTER></HTML>");
            }
            if (this.s.isBooted() && this.s.isControllerWithBrake() && this.s.isBrakeActivated()) {
                EPOSControllerPanel.this.brakeLabel.setText("<HTML><CENTER>Brake is<BR>activated</CENTER></HTML>");
            } else if (this.s.isControllerWithBrake() && !this.s.isBrakeActivated()) {
                EPOSControllerPanel.this.brakeLabel.setText("<HTML><CENTER>Brake is<BR>released</CENTER></HTML>");
            } else {
                EPOSControllerPanel.this.brakeLabel.setText("");
            }
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            EPOSControllerPanel.this.generalInfoPanel.initializeGui(this.configInfo);
            Map configForName = this.configInfo.getCurrentValuesFor(EPOSControllerPanel.this.controllerName);
            FCSCst.FCSLOG.fine((Object)(EPOSControllerPanel.this.controllerName + " configForName=" + configForName));
            Map currentParamsMap = (Map)InputConversionEngine.convertArgToType((String)((String)configForName.get("paramsForCurrent")), Map.class);
            EPOSControllerPanel.this.currentParamsPanel.initializeGUI(EPOSEnumerations.EposMode.CURRENT.toString(), currentParamsMap);
            Map profileParamsMap = (Map)InputConversionEngine.convertArgToType((String)((String)configForName.get("paramsForProfilePosition")), Map.class);
            EPOSControllerPanel.this.profile_positionParamsPanel.initializeGUI(EPOSEnumerations.EposMode.PROFILE_POSITION.toString(), profileParamsMap);
            Map homingParamsMap = (Map)InputConversionEngine.convertArgToType((String)((String)configForName.get("paramsForHoming")), Map.class);
            EPOSControllerPanel.this.homingParamsPanel.initializeGUI(EPOSEnumerations.EposMode.HOMING.toString(), homingParamsMap);
        }
    }
}

