/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;

public class CarouselDisk
extends JComponent {
    private static final long serialVersionUID = -2896017577739118272L;
    private double rotationInDegrees = 0.0;
    private String filterOnAutochanger;
    private transient Map<String, String> socketFilterMap;

    public CarouselDisk() {
        this.setPreferredSize(new Dimension(400, 400));
        this.socketFilterMap = new TreeMap<String, String>();
        this.socketFilterMap.put("socket1", "NO FILTER");
        this.socketFilterMap.put("socket2", "NO FILTER");
        this.socketFilterMap.put("socket3", "NO FILTER");
        this.socketFilterMap.put("socket4", "NO FILTER");
        this.socketFilterMap.put("socket5", "NO FILTER");
    }

    public void setRotationInDegrees(float rotationInDegrees) {
        this.rotationInDegrees = rotationInDegrees;
    }

    public void setFilterInCamera(String filterInCamera) {
        this.filterOnAutochanger = filterInCamera;
    }

    public void update(StatusDataPublishedByCarousel status) {
        this.rotationInDegrees = status.getPosition() * 360.0 / 4362240.0;
        this.filterOnAutochanger = status.getFilterOnAutochangerName();
        this.socketFilterMap = status.getFiltersOnCamera();
        if (this.socketFilterMap == null) {
            FCSCst.FCSLOG.info((Object)"socketFilterMap is null in method update");
        }
        this.repaint();
    }

    public void resetPanel() {
        this.rotationInDegrees = 0.0;
        this.filterOnAutochanger = null;
        this.socketFilterMap = new TreeMap<String, String>();
        this.socketFilterMap.put("socket1", "NO FILTER");
        this.socketFilterMap.put("socket2", "NO FILTER");
        this.socketFilterMap.put("socket3", "NO FILTER");
        this.socketFilterMap.put("socket4", "NO FILTER");
        this.socketFilterMap.put("socket5", "NO FILTER");
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);
        float width = this.getWidth();
        float height = this.getHeight();
        float actualWidth = Math.min(width, height);
        float border = 10.0f;
        Arc2D.Double circle = new Arc2D.Double(border, border, actualWidth - 2.0f * border, actualWidth - 2.0f * border, 0.0, 360.0, 1);
        g2.draw(circle);
        double filterDegrees = 72.0;
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(5.0f));
        Arc2D.Double loader = new Arc2D.Double(border, border, actualWidth - 2.0f * border, actualWidth - 2.0f * border, 0.0, -filterDegrees, 0);
        g2.draw(loader);
        g2.setStroke(oldStroke);
        g2.rotate(this.rotationInDegrees * Math.PI / 180.0, actualWidth / 2.0f, actualWidth / 2.0f);
        border *= 2.0f;
        if (this.socketFilterMap == null) {
            FCSCst.FCSLOG.error((Object)"socketFilterMap is null");
        } else {
            for (Map.Entry<String, String> entry : this.socketFilterMap.entrySet()) {
                boolean filterPresent;
                String socketName = entry.getKey();
                String filterName = entry.getValue();
                Arc2D.Double arc = new Arc2D.Double(border, border, actualWidth - 2.0f * border, actualWidth - 2.0f * border, 0.0, -filterDegrees, 2);
                boolean bl = filterPresent = !filterName.equals(this.filterOnAutochanger);
                if (filterPresent) {
                    g2.draw(arc);
                }
                g2.rotate(filterDegrees * Math.PI / 360.0, actualWidth / 2.0f, actualWidth / 2.0f);
                g2.drawString(socketName, actualWidth * 3.0f / 5.0f, actualWidth / 2.0f);
                if (filterPresent) {
                    g2.drawString(filterName, actualWidth * 3.0f / 4.0f, actualWidth / 2.0f);
                }
                g2.rotate(filterDegrees * Math.PI / 360.0, actualWidth / 2.0f, actualWidth / 2.0f);
            }
        }
    }
}

