/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerBottomPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGatherPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

public class AutochangerGUI
extends GeneralGUI
implements InterfaceAutochangerGUI {
    private static final long serialVersionUID = 1528028505886594591L;
    private final long updateTrucksPositionTimeout;
    private long timeoutForTrucksMotion;
    private final long timeoutForClosingClamps;
    private final long timeoutForOpeningClamps;
    private long timeoutForOnlineClampMotion;
    private final long timeoutForClosingLatches;
    private final long timeoutForOpeningLatches;

    public AutochangerGUI(String name, String role, AgentMessagingLayer aml) {
        super(name, role, aml);
        AutochangerGatherPanel autochangerGatherPanel = new AutochangerGatherPanel(this, "tcpProxy");
        AutochangerBottomPanel autochangerBottomPanel = new AutochangerBottomPanel(autochangerGatherPanel, "AUTOCHANGER");
        this.generalPanel = new GeneralPanel(this, autochangerBottomPanel);
        this.pane = new JScrollPane(this.generalPanel);
        this.updateTrucksPositionTimeout = 1000L;
        this.timeoutForTrucksMotion = 60000L;
        this.timeoutForClosingClamps = 10000L;
        this.timeoutForOpeningClamps = 10000L;
        this.timeoutForClosingLatches = 10000L;
        this.timeoutForOpeningLatches = 10000L;
    }

    @Override
    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }

    @Override
    public void setTimeoutForOnlineClampMotion(long timeoutForOnlineClampMotion) {
        this.timeoutForOnlineClampMotion = timeoutForOnlineClampMotion;
    }

    @Override
    public void updateTrucksPosition() {
        FCSCst.FCSLOG.info((Object)"Autochanger updating Trucks position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.updateTrucksPositionTimeout));
        new GeneralGUI.CommandSwingWorker(this, "updatePosition", this.updateTrucksPositionTimeout, "autochangerTrucks").execute();
    }

    @Override
    public void goToHandOff() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Handoff Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker(this, "goToHandOff", this.timeoutForTrucksMotion, "autochangerTrucks").execute();
    }

    @Override
    public void goToStandby() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Standby Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker(this, "goToStandby", this.timeoutForTrucksMotion, "autochangerTrucks").execute();
    }

    @Override
    public void goToOnline() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks going to Online Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker(this, "goToOnline", this.timeoutForTrucksMotion, "autochangerTrucks").execute();
    }

    @Override
    public void moveAndClampFilterOnline() {
        FCSCst.FCSLOG.info((Object)"Autochanger Trucks moving to Online Position, and clamping");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker(this, "moveAndClampFilterOnline", this.timeoutForTrucksMotion, "autochangerTrucks").execute();
    }

    @Override
    public void unlockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking online clamps");
        new GeneralGUI.CommandSwingWorker(this, "unlockClamps", this.timeoutForOnlineClampMotion, "onlineClamps").execute();
    }

    @Override
    public void lockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger locking online clamps");
        new GeneralGUI.CommandSwingWorker(this, "lockClamps", this.timeoutForOnlineClampMotion, "onlineClamps").execute();
    }

    @Override
    public void closeOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger closing online clamps");
        new GeneralGUI.CommandSwingWorker(this, "closeClamps", this.timeoutForOnlineClampMotion, "onlineClamps").execute();
    }

    @Override
    public void openOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger opening online clamps");
        new GeneralGUI.CommandSwingWorker(this, "openClamps", this.timeoutForOnlineClampMotion, "onlineClamps").execute();
    }

    @Override
    public void unlockAndOpenOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking and opening online clamps");
        new GeneralGUI.CommandSwingWorker(this, "unlockAndOpenClamps", this.timeoutForOnlineClampMotion, "onlineClamps").execute();
    }

    @Override
    public void closeAndLockOnlineClamps() {
        FCSCst.FCSLOG.info((Object)"Autochanger closing and locking online clamps");
        new GeneralGUI.CommandSwingWorker(this, "closeAndLockClamps", this.timeoutForOnlineClampMotion, "onlineClamps").execute();
    }

    @Override
    public void openOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger opening clamp: " + clampName));
        new GeneralGUI.CommandSwingWorker(this, "open", this.timeoutForOpeningClamps, clampName).execute();
    }

    @Override
    public void closeOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger closing clamp: " + clampName));
        new GeneralGUI.CommandSwingWorker(this, "close", this.timeoutForClosingClamps, clampName).execute();
    }

    @Override
    public void lockOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger clamping clamp: " + clampName));
        new GeneralGUI.CommandSwingWorker(this, "lock", this.timeoutForClosingClamps, clampName).execute();
    }

    @Override
    public void unlockOnlineClamp(String clampName) {
        FCSCst.FCSLOG.info((Object)("Autochanger unclamping clamp: " + clampName));
        new GeneralGUI.CommandSwingWorker(this, "unlock", this.timeoutForClosingClamps, clampName).execute();
    }

    @Override
    public void closeLatch(String latchName) {
        FCSCst.FCSLOG.info((Object)("Autochanger locking latch: " + latchName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker(this, "close", this.timeoutForClosingLatches, latchName).execute();
    }

    @Override
    public void openLatch(String latchName) {
        FCSCst.FCSLOG.info((Object)("Autochanger unlocking latch: " + latchName));
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningLatches));
        new GeneralGUI.CommandSwingWorker(this, "open", this.timeoutForOpeningLatches, latchName).execute();
    }

    @Override
    public void closeLatches() {
        FCSCst.FCSLOG.info((Object)"Autochanger locking latches.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker(this, "close", this.timeoutForClosingLatches, "latches").execute();
    }

    @Override
    public void openLatches() {
        FCSCst.FCSLOG.info((Object)"Autochanger unlocking latches.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.timeoutForOpeningLatches));
        new GeneralGUI.CommandSwingWorker(this, "open", this.timeoutForOpeningLatches, "latches").execute();
    }

    public static void main(String[] args) {
        Agent agent = new Agent("AutochangerGUI", AgentInfo.AgentType.CONSOLE);
        AutochangerGUI t = new AutochangerGUI(agent.getName(), "Autochanger", agent.getMessagingAccess());
        agent.startAgent();
        JFrame frame = new JFrame("Autochanger View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }
}

