
package org.lsst.ccs.subsystems.fcs.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

/**
 * A GUI for the whole Filter Changer Subsystem.
 * 
 * @author virieux
 */
public class FcsGUI extends GeneralGUI implements InterfaceCarouselGUI, InterfaceAutochangerGUI, InterfaceLoaderGUI {
    private static final long serialVersionUID = -6702752740750789411L;
    
    private static final String clampModuleName = "clamp";
    private static final String carrierModuleName = "carrier";
    
    /*actions timeout for autochanger*/
    protected long timeoutForTrucksMotion;
    protected long timeoutForOnlineClampMotion;

    //actions timeout for Loader
    protected long updateCarrierPositionTimeout;
    protected long openHooksTimeout;
    protected long closeHooksTimeout;
    protected long clampHooksTimeout;
    protected long homingHooksTimeout;
    protected long goToHandoffTimeout;
    protected long goToStorageTimeout;
    protected long quickStopTimeout;


    /**
     * A constructor with a name, a destination (subsystem name) and an AgentMessagingLayer.
     * @param name
     * @param role
     * @param aml 
     */
    public FcsGUI(String name, String role, AgentMessagingLayer aml) {
        super(name, role, aml);
        FcsGatherPanel fcsGatherPanel;
        fcsGatherPanel = new FcsGatherPanel(this);
        FcsBottomPanel fcsBottomPanel = new FcsBottomPanel(fcsGatherPanel, "FCS");
        this.generalPanel = new GeneralPanel(this, fcsBottomPanel);
        pane = new JScrollPane(generalPanel);
        
        /* Initialization of loader timeout */
        openHooksTimeout = 0;
        closeHooksTimeout = 0;
        clampHooksTimeout = 0;
        homingHooksTimeout = 0;
        goToHandoffTimeout = 0;
        goToStorageTimeout = 0;
        abortTimeout = 1000;
        quickStopTimeout = 1000;
        updateStateWithSensorsTimeout = 1000;
        updateCarrierPositionTimeout = 1000;
    }
    

    @Override
    public void setGoToHandoffTimeout(int aInt) {
        this.goToHandoffTimeout = aInt;
    }

    @Override
    public void setGoToStorageTimeout(int aInt) {
        this.goToStorageTimeout = aInt;
    }

    @Override
    public void setOpenHooksTimeout(long openHooksTimeout) {
        this.openHooksTimeout = openHooksTimeout;
    }

    @Override
    public void setCloseHooksTimeout(long closeHooksTimeout) {
        this.closeHooksTimeout = closeHooksTimeout;
    }

    @Override
    public void setClampHooksTimeout(long clampHooksTimeout) {
        this.clampHooksTimeout = clampHooksTimeout;
    }

    @Override
    public void setHomingHooksTimeout(long homingHooksTimeout) {
        this.homingHooksTimeout = homingHooksTimeout;
    }
    

    
    /**
     ******************************************************************************
     ** Carousel commands
     ******************************************************************************
     */ 
    
    @Override
    public void checkFiltersLocation() {
        new CommandSwingWorker("checkFiltersLocation", updateStateWithSensorsTimeout).execute();
    }

    
    @Override
    public void rotate() {
        new CommandSwingWorker("carousel/rotate", this.goToHandoffTimeout).execute();
    }
    
    
    @Override
    public void updatePosition() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void unlockClamps() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
     /**
     ******************************************************************************
     ** END of Carousel commands
     ******************************************************************************
     */   
    
    /**
     ******************************************************************************
     ** Autochanger commands
     ******************************************************************************
     * 
     */
    
    /**
     * 
     * @param timeoutForTrucksMotion 
     */
    @Override
    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }
    
    @Override
    public void setTimeoutForOnlineClampMotion(long timeoutForOnlineClampMotion) {
        this.timeoutForOnlineClampMotion = timeoutForOnlineClampMotion;
    }    

    @Override
    public void closeLatch(String latchName) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void closeLatches() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void openLatch(String latchName) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void openLatches() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void unlockOnlineClamps() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void lockOnlineClamps() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
    @Override
    public void unlockAndOpenOnlineClamps() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void closeAndLockOnlineClamps() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void updateTrucksPosition() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void goToOnline() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void goToStandby() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
    
    @Override
    public void moveAndClampFilterOnline() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    } 
    
    @Override
    public void openOnlineClamp(String clampName) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void closeOnlineClamp(String clampName) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void lockOnlineClamp(String clampName) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void unlockOnlineClamp(String clampName) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void closeOnlineClamps() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void openOnlineClamps() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }    

    /**
     ******************************************************************************
     ** Loader commands
     ******************************************************************************
     */
    
    /**
     * 
     */
    @Override
    public void loadFilter() {
        System.out.println(destination + "loadFilterInCamera with timeout=" + goToHandoffTimeout);
        FCSLOG.info("Loading filter in camera");
        FCSLOG.info("/timeout=" + goToHandoffTimeout);
        new CommandSwingWorker("loadFilterInCamera", this.goToHandoffTimeout).execute();
    }

    @Override
    public void unloadFilter() {
        System.out.println(destination + "unloadFilterFromCamera with timeout=" + goToStorageTimeout);
        FCSLOG.info("Loading filter in camera");
        FCSLOG.info("/timeout=" + goToStorageTimeout);
        new CommandSwingWorker("unloadFilterFromCamera", this.goToStorageTimeout).execute();
    }

    @Override
    public void updateCarrierPosition() {
        System.out.println(destination + "updateCarrierPosition with updateCarrierPositionTimeout=" + updateCarrierPositionTimeout);
        FCSLOG.info("Updating carrier position");
        FCSLOG.info("/timeout=" + updateCarrierPositionTimeout);
        new CommandSwingWorker("updatePosition", updateCarrierPositionTimeout, carrierModuleName).execute();
    }

    @Override
    public void openHooks() {
        FCSLOG.info("Opening Hooks");
        FCSLOG.info("/timeout=" + openHooksTimeout);
        new CommandSwingWorker("openHooks", openHooksTimeout).execute();
    }

    @Override
    public void closeHooks() {
        FCSLOG.info("Closing Hooks");
        System.out.println("/timeout=" + closeHooksTimeout);
        new CommandSwingWorker("closeHooks", this.closeHooksTimeout).execute();
    }

    @Override
    public void clampHooks() {
        FCSLOG.info("Clamping Hooks");
        FCSLOG.info("/timeout=" + clampHooksTimeout);
        new CommandSwingWorker("clampHooks", this.clampHooksTimeout).execute();
    }
    
    @Override
    public void unclampHooks() {
        FCSLOG.info("Unclamping Hooks");
        FCSLOG.info("/timeout=" + clampHooksTimeout);
        new CommandSwingWorker("unclamp", this.clampHooksTimeout, clampModuleName).execute();
    }

    
    @Override
    public void clampHoming() {
        FCSLOG.info("Clamp going to Home Position or CLAMPED position.");
        FCSLOG.info("/timeout=" + homingHooksTimeout);
        new CommandSwingWorker("initializeHardware", this.homingHooksTimeout, clampModuleName).execute();
    }

    @Override
    public void goToHandOff() {
        FCSLOG.info("Carrier going to Handoff Position");
        FCSLOG.info("/timeout=" + goToHandoffTimeout);
        new CommandSwingWorker("goToHandOff", this.goToHandoffTimeout, carrierModuleName).execute();
    }

    @Override
    public void goToStorage() {
        System.out.println(destination + "goToStorage with goToStorageTimeout=" + goToStorageTimeout);
        FCSLOG.info("Carrier going to Storage Position");
        FCSLOG.info("/timeout=" + goToStorageTimeout);
        new CommandSwingWorker("goToStorage", this.goToStorageTimeout, carrierModuleName).execute();
    }
    
    
    /**
     ******************************************************************************
     ** END of Loader commands
     ******************************************************************************
     */
    
    /**
     * This main launches an GUI for the whole subsystem "fcs".
     * It's used only for tests.
     * 
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        Agent agent = new Agent("FcsGUI", AgentInfo.AgentType.CONSOLE);
        FcsGUI t = new FcsGUI(agent.getName(), "fcs", 
                agent.getMessagingAccess());
        agent.startAgent();

        JFrame frame = new JFrame("Fcs View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }



    @Override
    public void setGoToEngagedTimeout(int toInt) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void goToEngaged() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }













    
}
