/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.canopenjni.rmi;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.lsst.ccs.drivers.canopenjni.BootMessageListener;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.EmergencyMessageListener;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.canopenjni.rmi.BootMessageRemoteListenerImpl;
import org.lsst.ccs.drivers.canopenjni.rmi.CanOpenRemoteInterface;
import org.lsst.ccs.drivers.canopenjni.rmi.EmergencyMessageRemoteListenerImpl;
import org.lsst.ccs.drivers.commons.DriverException;

public class CanOpenRMIClient
implements CanOpenInterface {
    private CanOpenRemoteInterface stub;
    private final String registryHostName;
    private final String bindName;

    @Deprecated
    public CanOpenRMIClient(String registryHostName) {
        this(registryHostName, "CanOpen");
    }

    public CanOpenRMIClient(String registryHostName, String bindName) {
        this.registryHostName = registryHostName;
        this.bindName = bindName;
    }

    @Override
    public void init(int master, String baud, String busName, int nodeID) throws DriverException {
        try {
            Registry registry = LocateRegistry.getRegistry(this.registryHostName);
            this.stub = (CanOpenRemoteInterface)registry.lookup(this.bindName);
            this.stub.init(master, baud, busName, nodeID);
        }
        catch (Exception ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void addReceivedPDO(int cobId) throws DriverException {
        try {
            this.stub.addReceivedPDO(cobId);
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void clearReceivedPDOs() throws DriverException {
        try {
            this.stub.clearReceivedPDOs();
        }
        catch (Exception ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public PDOData sync() throws DriverException {
        try {
            return this.stub.sync();
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public int scan() throws DriverException {
        try {
            return this.stub.scan();
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public String info(int nodeID) throws DriverException {
        try {
            return this.stub.info(nodeID);
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException {
        try {
            this.stub.wsdo(nodeId, index, subindex, size, data);
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public long rsdo(int nodeId, int index, int subindex) throws DriverException {
        try {
            return this.stub.rsdo(nodeId, index, subindex);
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void ssta(int nodeId) throws DriverException {
        try {
            this.stub.ssta(nodeId);
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void ssto(int nodeId) throws DriverException {
        try {
            this.stub.ssto(nodeId);
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void reset(int nodeId) throws DriverException {
        try {
            this.stub.reset(nodeId);
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void quit() throws DriverException {
        try {
            this.stub.quit();
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void init() throws DriverException {
        try {
            this.stub.init();
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void start() throws DriverException {
        try {
            this.stub.start();
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void stop() throws DriverException {
        try {
            this.stub.stop();
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public boolean isReady() throws DriverException {
        try {
            return this.stub.isReady();
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void setEmergencyMessageListener(EmergencyMessageListener eml) throws DriverException {
        try {
            this.stub.setEmergencyMessageListener(new EmergencyMessageRemoteListenerImpl(eml));
        }
        catch (RemoteException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void setBootMessageListener(BootMessageListener bml) throws DriverException {
        try {
            this.stub.setBootMessageListener(new BootMessageRemoteListenerImpl(bml));
        }
        catch (Exception ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public void setTimeoutMillis(long to) throws DriverException {
        try {
            this.stub.setTimeoutMillis(to);
        }
        catch (Exception ex) {
            throw new DriverException((Throwable)ex);
        }
    }
}

