/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.FcsBottomPanel;
import org.lsst.ccs.subsystems.fcs.ui.FcsGatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

public class FcsGUI
extends GeneralGUI
implements InterfaceCarouselGUI,
InterfaceAutochangerGUI,
InterfaceLoaderGUI {
    private static final long serialVersionUID = -6702752740750789411L;
    private static final String clampModuleName = "clamp";
    private static final String carrierModuleName = "carrier";
    protected long timeoutForTrucksMotion;
    protected long updateCarrierPositionTimeout;
    protected long openHooksTimeout;
    protected long closeHooksTimeout;
    protected long clampHooksTimeout;
    protected long homingHooksTimeout;
    protected long goToHandoffTimeout;
    protected long goToStorageTimeout;
    protected long quickStopTimeout;

    public FcsGUI(String name, String role, AgentMessagingLayer aml) {
        super(name, role, aml);
        FcsGatherPanel fcsGatherPanel = new FcsGatherPanel(this);
        FcsBottomPanel fcsBottomPanel = new FcsBottomPanel(fcsGatherPanel, "FCS");
        this.generalPanel = new GeneralPanel(this, fcsBottomPanel);
        this.pane = new JScrollPane(this.generalPanel);
        this.openHooksTimeout = 0L;
        this.closeHooksTimeout = 0L;
        this.clampHooksTimeout = 0L;
        this.homingHooksTimeout = 0L;
        this.goToHandoffTimeout = 0L;
        this.goToStorageTimeout = 0L;
        this.abortTimeout = 1000L;
        this.quickStopTimeout = 1000L;
        this.updateStateWithSensorsTimeout = 1000L;
        this.updateCarrierPositionTimeout = 1000L;
    }

    @Override
    public void setGoToHandoffTimeout(int aInt) {
        this.goToHandoffTimeout = aInt;
    }

    @Override
    public void setGoToStorageTimeout(int aInt) {
        this.goToStorageTimeout = aInt;
    }

    @Override
    public void setOpenHooksTimeout(long openHooksTimeout) {
        this.openHooksTimeout = openHooksTimeout;
    }

    @Override
    public void setCloseHooksTimeout(long closeHooksTimeout) {
        this.closeHooksTimeout = closeHooksTimeout;
    }

    @Override
    public void setClampHooksTimeout(long clampHooksTimeout) {
        this.clampHooksTimeout = clampHooksTimeout;
    }

    @Override
    public void setHomingHooksTimeout(long homingHooksTimeout) {
        this.homingHooksTimeout = homingHooksTimeout;
    }

    @Override
    public void checkFiltersLocation() {
        new GeneralGUI.CommandSwingWorker("checkFiltersLocation", this.updateStateWithSensorsTimeout).execute();
    }

    @Override
    public void rotate() {
        new GeneralGUI.CommandSwingWorker("carousel/rotate", this.goToHandoffTimeout).execute();
    }

    @Override
    public void updatePosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void unlockClamps() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }

    @Override
    public void closeLatch(String latchName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void closeLatches() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void openLatch(String latchName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void openLatches() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void unlockOnlineClamps() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void lockOnlineClamps() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void unlockAndOpenOnlineClamps() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void closeAndLockOnlineClamps() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateTrucksPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void goToOnline() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void goToStandby() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void loadFilter() {
        System.out.println(this.destination + "loadFilterInCamera with timeout=" + this.goToHandoffTimeout);
        FCSCst.FCSLOG.info((Object)"Loading filter in camera");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToHandoffTimeout));
        new GeneralGUI.CommandSwingWorker("loadFilterInCamera", this.goToHandoffTimeout).execute();
    }

    @Override
    public void unloadFilter() {
        System.out.println(this.destination + "unloadFilterFromCamera with timeout=" + this.goToStorageTimeout);
        FCSCst.FCSLOG.info((Object)"Loading filter in camera");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToStorageTimeout));
        new GeneralGUI.CommandSwingWorker("unloadFilterFromCamera", this.goToStorageTimeout).execute();
    }

    @Override
    public void updateCarrierPosition() {
        System.out.println(this.destination + "updateCarrierPosition with updateCarrierPositionTimeout=" + this.updateCarrierPositionTimeout);
        FCSCst.FCSLOG.info((Object)"Updating carrier position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.updateCarrierPositionTimeout));
        new GeneralGUI.CommandSwingWorker("updatePosition", this.updateCarrierPositionTimeout, carrierModuleName).execute();
    }

    @Override
    public void openHooks() {
        FCSCst.FCSLOG.info((Object)"Opening Hooks");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.openHooksTimeout));
        new GeneralGUI.CommandSwingWorker("openHooks", this.openHooksTimeout).execute();
    }

    @Override
    public void closeHooks() {
        FCSCst.FCSLOG.info((Object)"Closing Hooks");
        System.out.println("/timeout=" + this.closeHooksTimeout);
        new GeneralGUI.CommandSwingWorker("closeHooks", this.closeHooksTimeout).execute();
    }

    @Override
    public void clampHooks() {
        FCSCst.FCSLOG.info((Object)"Clamping Hooks");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.clampHooksTimeout));
        new GeneralGUI.CommandSwingWorker("clampHooks", this.clampHooksTimeout).execute();
    }

    @Override
    public void unclampHooks() {
        FCSCst.FCSLOG.info((Object)"Unclamping Hooks");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.clampHooksTimeout));
        new GeneralGUI.CommandSwingWorker("unclamp", this.clampHooksTimeout, clampModuleName).execute();
    }

    @Override
    public void clampHoming() {
        FCSCst.FCSLOG.info((Object)"Clamp going to Home Position or CLAMPED position.");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.homingHooksTimeout));
        new GeneralGUI.CommandSwingWorker("initializeHardware", this.homingHooksTimeout, clampModuleName).execute();
    }

    @Override
    public void goToHandOff() {
        FCSCst.FCSLOG.info((Object)"Carrier going to Handoff Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToHandoffTimeout));
        new GeneralGUI.CommandSwingWorker("goToHandOff", this.goToHandoffTimeout, carrierModuleName).execute();
    }

    @Override
    public void goToStorage() {
        System.out.println(this.destination + "goToStorage with goToStorageTimeout=" + this.goToStorageTimeout);
        FCSCst.FCSLOG.info((Object)"Carrier going to Storage Position");
        FCSCst.FCSLOG.info((Object)("/timeout=" + this.goToStorageTimeout));
        new GeneralGUI.CommandSwingWorker("goToStorage", this.goToStorageTimeout, carrierModuleName).execute();
    }

    public static void main(String[] args) {
        Agent agent = new Agent("FcsGUI", AgentInfo.AgentType.CONSOLE);
        FcsGUI t = new FcsGUI(agent.getName(), "fcs", agent.getMessagingAccess());
        agent.start();
        JFrame frame = new JFrame("Fcs View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }

    @Override
    public void openOnlineClamp(String clampName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void closeOnlineClamp(String clampName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void lockOnlineClamp(String clampName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void unlockOnlineClamp(String clampName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void closeOnlineClamps() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void openOnlineClamps() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setGoToEngagedTimeout(int toInt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void goToEngaged() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

