/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.AnalogMeter;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.HorizontalProgressBar;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.MovementPanel;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.VerticalProgressBar;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class SingleFilterTestExchangePanel
extends JPanel {
    private static final long serialVersionUID = -7001734238755354500L;
    private static final String CLAMPXMINUS_NAME = "clampXminus";
    private static final String CLAMPXPLUS_NAME = "clampXplus";
    private static final String CLAMPXMINUS_CTL_NAME = "clampXminusController";
    private static final String CLAMPXPLUS_CTL_NAME = "clampXplusController";
    private static final String LATCHXMINUS_CTL_NAME = "latchActuatorXminus";
    private static final String LATCHXPLUS_CTL_NAME = "latchActuatorXplus";
    private AnalogMeter clampActuatorCurrentMeterXminus;
    private AnalogMeter clampActuatorCurrentMeterXplus;
    private FilterPanel filterInAutochangerPanel;
    private FilterPanel filterInCarouselPanel;
    private JLabel filterPositionInClampXMinusLabel;
    private VerticalProgressBar filterPositionInClampXMinusProgress;
    private DigitalSwitch filterPositionInClampXMinusSwitch;
    private JLabel filterPositionInClampXPlusLabel;
    private VerticalProgressBar filterPositionInClampXPlusProgress;
    private DigitalSwitch filterPositionInClampXPlusSwitch;
    private DigitalSwitch filterPresenceSensorLatchXminus;
    private DigitalSwitch filterPresenceSensorLatchXplus;
    private JLabel xMinusLabel;
    private JLabel xPlusLabel2;
    private JLabel xPlusLabel;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel3;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel39;
    private JLabel jLabel40;
    private JLabel jLabel42;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JLabel xMinusLabel2;
    private AnalogMeter latchActuatorCurrentMeterXminus;
    private AnalogMeter latchActuatorCurrentMeterXplus;
    private DigitalSwitch lockSensorPositionLatchXminus;
    private DigitalSwitch lockSensorPositionLatchXplus;
    private JLabel lockSensorStateClampXMinusLabel;
    private HorizontalProgressBar lockSensorStateClampXMinusProgress;
    private DigitalSwitch lockSensorStateClampXMinusSwitch;
    private JLabel lockSensorStateClampXPlusLabel;
    private HorizontalProgressBar lockSensorStateClampXPlusProgress;
    private DigitalSwitch lockSensorStateClampXPlusSwitch;
    private JLabel lockSensorXMinusState;
    private JLabel lockSensorXPlusState;
    private MovementPanel movementPanel;
    private JLabel positionSensorXMinusState;
    private JLabel positionSensorXPlusState;
    private DigitalSwitch railSensorHandOffPositionXminus;
    private DigitalSwitch railSensorHandOffPositionXplus;
    private DigitalSwitch railSensorStandByPositionXminus;
    private DigitalSwitch railSensorStandByPositionXplus;
    private DigitalSwitch unlockSensorPositionLatchXminus;
    private DigitalSwitch unlockSensorPositionLatchXplus;

    public SingleFilterTestExchangePanel() {
        this.initComponents();
    }

    protected void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateClamp(StatusDataPublishedByCarouselClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateLatch(StatusDataPublishedByAutochangerLatch status) {
        SwingUtilities.invokeLater(new UpdateLatch(status));
    }

    public void updateAutoChanger(StatusDataPublishedByBasicAutoChanger status) {
        SwingUtilities.invokeLater(new UpdateAutoChanger(status));
    }

    public void updateCarousel(StatusDataPublishedByCarousel status) {
        SwingUtilities.invokeLater(new UpdateCarousel(status));
    }

    public void updateActuator(StatusDataPublishedByClampActuator status) {
        SwingUtilities.invokeLater(new UpdateActuator(status));
    }

    private static Color getLockSensorColor(String lockSensorStatus) {
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.ERROR.toString())) {
            return Color.red;
        }
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.LOCKED.toString())) {
            return FcsEnumerations.greenColor;
        }
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.UNKNOWN.toString())) {
            return Color.orange;
        }
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.UNLOCKED.toString())) {
            return Color.blue;
        }
        throw new IllegalArgumentException("Unknown Lock Sensor Status " + lockSensorStatus);
    }

    public static Color getFilterPresenceColor(String filterPresenceStatus) {
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.ERROR.toString())) {
            return Color.red;
        }
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.LOCKABLE.toString())) {
            return FcsEnumerations.greenColor;
        }
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE.toString())) {
            return Color.orange;
        }
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.NOFILTER.toString())) {
            return Color.gray;
        }
        throw new IllegalArgumentException("Unknown Filter Presence Status " + filterPresenceStatus);
    }

    private static void configureClampFilterPositionProgressBar(VerticalProgressBar progressBar, Map<String, String> config) {
        progressBar.setValues(0, Short.MAX_VALUE, Tools.toInt(config, "filterPositionValueA"), Tools.toInt(config, "filterPositionValueB"), Tools.toInt(config, "filterPositionValueC"));
    }

    private static void configureClampLockSensorProgressBar(HorizontalProgressBar progressBar, Map<String, String> config) {
        progressBar.setValues(0, Short.MAX_VALUE, Tools.toInt(config, "lockSensorValueA"), Tools.toInt(config, "lockSensorValueB"), Tools.toInt(config, "lockSensorValueC"));
    }

    private void initComponents() {
        this.xMinusLabel = new JLabel("X-");
        this.xMinusLabel.setFont(Tools.VERY_BIG_FONT);
        this.xPlusLabel = new JLabel("X+");
        this.xPlusLabel.setFont(Tools.VERY_BIG_FONT);
        this.xMinusLabel2 = new JLabel("X-");
        this.xMinusLabel2.setFont(Tools.VERY_BIG_FONT);
        this.xPlusLabel2 = new JLabel("X+");
        this.xPlusLabel2.setFont(Tools.VERY_BIG_FONT);
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jLabel20 = new JLabel();
        this.railSensorStandByPositionXminus = new DigitalSwitch();
        this.railSensorHandOffPositionXminus = new DigitalSwitch();
        this.railSensorHandOffPositionXplus = new DigitalSwitch();
        this.railSensorStandByPositionXplus = new DigitalSwitch();
        this.jLabel32 = new JLabel();
        this.jLabel34 = new JLabel();
        this.jLabel35 = new JLabel();
        this.lockSensorPositionLatchXminus = new DigitalSwitch();
        this.unlockSensorPositionLatchXminus = new DigitalSwitch();
        this.filterPresenceSensorLatchXminus = new DigitalSwitch();
        this.filterPresenceSensorLatchXplus = new DigitalSwitch();
        this.unlockSensorPositionLatchXplus = new DigitalSwitch();
        this.lockSensorPositionLatchXplus = new DigitalSwitch();
        this.jLabel36 = new JLabel();
        this.jLabel37 = new JLabel();
        this.jLabel40 = new JLabel();
        this.lockSensorStateClampXPlusLabel = new JLabel();
        this.filterInAutochangerPanel = new FilterPanel();
        this.filterInCarouselPanel = new FilterPanel();
        this.movementPanel = new MovementPanel();
        this.jLabel45 = new JLabel();
        this.jLabel46 = new JLabel();
        this.jLabel47 = new JLabel();
        this.jLabel33 = new JLabel();
        this.jLabel48 = new JLabel();
        this.jLabel24 = new JLabel();
        this.lockSensorStateClampXMinusSwitch = new DigitalSwitch();
        this.filterPositionInClampXMinusSwitch = new DigitalSwitch();
        this.filterPositionInClampXPlusSwitch = new DigitalSwitch();
        this.lockSensorStateClampXPlusSwitch = new DigitalSwitch();
        this.jLabel42 = new JLabel();
        this.filterPositionInClampXPlusLabel = new JLabel();
        this.lockSensorStateClampXMinusLabel = new JLabel();
        this.filterPositionInClampXMinusLabel = new JLabel();
        this.latchActuatorCurrentMeterXminus = new AnalogMeter();
        this.latchActuatorCurrentMeterXplus = new AnalogMeter();
        this.clampActuatorCurrentMeterXminus = new AnalogMeter();
        this.clampActuatorCurrentMeterXplus = new AnalogMeter();
        this.jLabel38 = new JLabel();
        this.jLabel39 = new JLabel();
        this.filterPositionInClampXMinusProgress = new VerticalProgressBar();
        this.filterPositionInClampXMinusProgress.setPosition("left");
        this.filterPositionInClampXPlusProgress = new VerticalProgressBar();
        this.filterPositionInClampXMinusProgress.setPosition("right");
        this.lockSensorStateClampXMinusProgress = new HorizontalProgressBar();
        this.lockSensorStateClampXMinusProgress.setPosition("left");
        this.lockSensorStateClampXPlusProgress = new HorizontalProgressBar();
        this.lockSensorStateClampXMinusProgress.setPosition("right");
        this.positionSensorXPlusState = new JLabel();
        this.lockSensorXMinusState = new JLabel();
        this.lockSensorXPlusState = new JLabel();
        this.positionSensorXMinusState = new JLabel();
        this.jLabel3 = new JLabel();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.xMinusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.xPlusLabel, gridBagConstraints);
        this.jLabel22.setFont(new Font("Tahoma", 0, 14));
        this.jLabel22.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel22.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel22, gridBagConstraints);
        this.jLabel23.setFont(new Font("Tahoma", 0, 14));
        this.jLabel23.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel23.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 21;
        gridBagConstraints.fill = 3;
        this.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel21.setFont(new Font("Tahoma", 0, 14));
        this.jLabel21.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel21.setMaximumSize(new Dimension(100, 2));
        this.jLabel21.setPreferredSize(null);
        this.jLabel21.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel21, gridBagConstraints);
        this.jLabel25.setFont(new Font("Tahoma", 0, 14));
        this.jLabel25.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel25.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 21;
        gridBagConstraints.fill = 3;
        this.add((Component)this.jLabel25, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 23;
        this.add((Component)this.xPlusLabel2, gridBagConstraints);
        this.jLabel20.setFont(new Font("Tahoma", 0, 14));
        this.jLabel20.setText("<html>Rail Sensor<br>Stand-back Position</html>");
        this.jLabel20.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 60, 0, 0);
        this.add((Component)this.jLabel20, gridBagConstraints);
        GroupLayout railSensorStandByPositionXminusLayout = new GroupLayout(this.railSensorStandByPositionXminus);
        this.railSensorStandByPositionXminus.setLayout(railSensorStandByPositionXminusLayout);
        railSensorStandByPositionXminusLayout.setHorizontalGroup(railSensorStandByPositionXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        railSensorStandByPositionXminusLayout.setVerticalGroup(railSensorStandByPositionXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 13;
        this.add((Component)this.railSensorStandByPositionXminus, gridBagConstraints);
        GroupLayout railSensorHandOffPositionXminusLayout = new GroupLayout(this.railSensorHandOffPositionXminus);
        this.railSensorHandOffPositionXminus.setLayout(railSensorHandOffPositionXminusLayout);
        railSensorHandOffPositionXminusLayout.setHorizontalGroup(railSensorHandOffPositionXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        railSensorHandOffPositionXminusLayout.setVerticalGroup(railSensorHandOffPositionXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.railSensorHandOffPositionXminus, gridBagConstraints);
        GroupLayout railSensorHandOffPositionXplusLayout = new GroupLayout(this.railSensorHandOffPositionXplus);
        this.railSensorHandOffPositionXplus.setLayout(railSensorHandOffPositionXplusLayout);
        railSensorHandOffPositionXplusLayout.setHorizontalGroup(railSensorHandOffPositionXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        railSensorHandOffPositionXplusLayout.setVerticalGroup(railSensorHandOffPositionXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.railSensorHandOffPositionXplus, gridBagConstraints);
        GroupLayout railSensorStandByPositionXplusLayout = new GroupLayout(this.railSensorStandByPositionXplus);
        this.railSensorStandByPositionXplus.setLayout(railSensorStandByPositionXplusLayout);
        railSensorStandByPositionXplusLayout.setHorizontalGroup(railSensorStandByPositionXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        railSensorStandByPositionXplusLayout.setVerticalGroup(railSensorStandByPositionXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 13;
        this.add((Component)this.railSensorStandByPositionXplus, gridBagConstraints);
        this.jLabel32.setFont(new Font("Tahoma", 0, 14));
        this.jLabel32.setText("<html><P align=\"center\">Latch control<br>value</p></html>");
        this.jLabel32.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.jLabel32, gridBagConstraints);
        this.jLabel34.setFont(new Font("Tahoma", 0, 14));
        this.jLabel34.setText("<html><P align=\"center\">Lock<br>Position</p></html>");
        this.jLabel34.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(0, 6, 0, 3);
        this.add((Component)this.jLabel34, gridBagConstraints);
        this.jLabel35.setFont(new Font("Tahoma", 0, 14));
        this.jLabel35.setText("<html><P align=\"center\">Unlock<br>Position</p></html>");
        this.jLabel35.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.jLabel35, gridBagConstraints);
        GroupLayout lockSensorPositionLatchXminusLayout = new GroupLayout(this.lockSensorPositionLatchXminus);
        this.lockSensorPositionLatchXminus.setLayout(lockSensorPositionLatchXminusLayout);
        lockSensorPositionLatchXminusLayout.setHorizontalGroup(lockSensorPositionLatchXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        lockSensorPositionLatchXminusLayout.setVerticalGroup(lockSensorPositionLatchXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        this.add((Component)this.lockSensorPositionLatchXminus, gridBagConstraints);
        GroupLayout unlockSensorPositionLatchXminusLayout = new GroupLayout(this.unlockSensorPositionLatchXminus);
        this.unlockSensorPositionLatchXminus.setLayout(unlockSensorPositionLatchXminusLayout);
        unlockSensorPositionLatchXminusLayout.setHorizontalGroup(unlockSensorPositionLatchXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        unlockSensorPositionLatchXminusLayout.setVerticalGroup(unlockSensorPositionLatchXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.unlockSensorPositionLatchXminus, gridBagConstraints);
        GroupLayout filterPresenceSensorLatchXminusLayout = new GroupLayout(this.filterPresenceSensorLatchXminus);
        this.filterPresenceSensorLatchXminus.setLayout(filterPresenceSensorLatchXminusLayout);
        filterPresenceSensorLatchXminusLayout.setHorizontalGroup(filterPresenceSensorLatchXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        filterPresenceSensorLatchXminusLayout.setVerticalGroup(filterPresenceSensorLatchXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        this.add((Component)this.filterPresenceSensorLatchXminus, gridBagConstraints);
        GroupLayout filterPresenceSensorLatchXplusLayout = new GroupLayout(this.filterPresenceSensorLatchXplus);
        this.filterPresenceSensorLatchXplus.setLayout(filterPresenceSensorLatchXplusLayout);
        filterPresenceSensorLatchXplusLayout.setHorizontalGroup(filterPresenceSensorLatchXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        filterPresenceSensorLatchXplusLayout.setVerticalGroup(filterPresenceSensorLatchXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        this.add((Component)this.filterPresenceSensorLatchXplus, gridBagConstraints);
        GroupLayout unlockSensorPositionLatchXplusLayout = new GroupLayout(this.unlockSensorPositionLatchXplus);
        this.unlockSensorPositionLatchXplus.setLayout(unlockSensorPositionLatchXplusLayout);
        unlockSensorPositionLatchXplusLayout.setHorizontalGroup(unlockSensorPositionLatchXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        unlockSensorPositionLatchXplusLayout.setVerticalGroup(unlockSensorPositionLatchXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        this.add((Component)this.unlockSensorPositionLatchXplus, gridBagConstraints);
        GroupLayout lockSensorPositionLatchXplusLayout = new GroupLayout(this.lockSensorPositionLatchXplus);
        this.lockSensorPositionLatchXplus.setLayout(lockSensorPositionLatchXplusLayout);
        lockSensorPositionLatchXplusLayout.setHorizontalGroup(lockSensorPositionLatchXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        lockSensorPositionLatchXplusLayout.setVerticalGroup(lockSensorPositionLatchXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.3;
        this.add((Component)this.lockSensorPositionLatchXplus, gridBagConstraints);
        this.jLabel36.setFont(new Font("Tahoma", 0, 14));
        this.jLabel36.setText("<html><P align=\"center\">Lock<br>Position</p></html>");
        this.jLabel36.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(0, 3, 0, 6);
        this.add((Component)this.jLabel36, gridBagConstraints);
        this.jLabel37.setFont(new Font("Tahoma", 0, 14));
        this.jLabel37.setText("<html><P align=\"center\">Unlock<br>Position</p></html>");
        this.jLabel37.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.jLabel37, gridBagConstraints);
        this.jLabel40.setFont(new Font("Tahoma", 0, 14));
        this.jLabel40.setText("<html><P align=\"center\">Filter<br>Engaged</p></html>");
        this.jLabel40.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(0, 6, 0, 3);
        this.add((Component)this.jLabel40, gridBagConstraints);
        this.lockSensorStateClampXPlusLabel.setFont(new Font("Tahoma", 0, 14));
        this.lockSensorStateClampXPlusLabel.setText("<html><P align=\"center\">Lock</p></html>");
        this.lockSensorStateClampXPlusLabel.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 19;
        this.add((Component)this.lockSensorStateClampXPlusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.xMinusLabel2, gridBagConstraints);
        GroupLayout filterInAutochangerPanelLayout = new GroupLayout(this.filterInAutochangerPanel);
        this.filterInAutochangerPanel.setLayout(filterInAutochangerPanelLayout);
        filterInAutochangerPanelLayout.setHorizontalGroup(filterInAutochangerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        filterInAutochangerPanelLayout.setVerticalGroup(filterInAutochangerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 9;
        this.add((Component)this.filterInAutochangerPanel, gridBagConstraints);
        GroupLayout filterInCarouselPanelLayout = new GroupLayout(this.filterInCarouselPanel);
        this.filterInCarouselPanel.setLayout(filterInCarouselPanelLayout);
        filterInCarouselPanelLayout.setHorizontalGroup(filterInCarouselPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        filterInCarouselPanelLayout.setVerticalGroup(filterInCarouselPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridheight = 4;
        this.add((Component)this.filterInCarouselPanel, gridBagConstraints);
        GroupLayout movementPanelLayout = new GroupLayout(this.movementPanel);
        this.movementPanel.setLayout(movementPanelLayout);
        movementPanelLayout.setHorizontalGroup(movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 120, Short.MAX_VALUE));
        movementPanelLayout.setVerticalGroup(movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 90, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 12;
        this.add((Component)this.movementPanel, gridBagConstraints);
        this.jLabel45.setFont(Tools.VERY_BIG_FONT);
        this.jLabel45.setText("CAROUSEL");
        this.jLabel45.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 17;
        this.add((Component)this.jLabel45, gridBagConstraints);
        this.jLabel46.setFont(new Font("Tahoma", 0, 14));
        this.jLabel46.setText("<html><P align=\"right\">Rail Sensor<br>Stand-back Position</p></html>");
        this.jLabel46.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 60);
        this.add((Component)this.jLabel46, gridBagConstraints);
        this.jLabel47.setFont(Tools.VERY_BIG_FONT);
        this.jLabel47.setText("CHANGER");
        this.jLabel47.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 11;
        this.add((Component)this.jLabel47, gridBagConstraints);
        this.jLabel33.setFont(new Font("Tahoma", 0, 14));
        this.jLabel33.setText("<html><P align=\"center\">Unclamping<br>Current</p></html>");
        this.jLabel33.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.jLabel33, gridBagConstraints);
        this.jLabel48.setFont(new Font("Tahoma", 0, 14));
        this.jLabel48.setText("<html><P align=\"right\">Rail Sensor<br>Stand-by Position</p></html>");
        this.jLabel48.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 60);
        this.add((Component)this.jLabel48, gridBagConstraints);
        this.jLabel24.setFont(new Font("Tahoma", 0, 14));
        this.jLabel24.setText("<html>Rail Sensor<br>Stand-by Position</html>");
        this.jLabel24.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 60, 0, 0);
        this.add((Component)this.jLabel24, gridBagConstraints);
        GroupLayout lockSensorStateClampXMinusSwitchLayout = new GroupLayout(this.lockSensorStateClampXMinusSwitch);
        this.lockSensorStateClampXMinusSwitch.setLayout(lockSensorStateClampXMinusSwitchLayout);
        lockSensorStateClampXMinusSwitchLayout.setHorizontalGroup(lockSensorStateClampXMinusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        lockSensorStateClampXMinusSwitchLayout.setVerticalGroup(lockSensorStateClampXMinusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 17;
        this.add((Component)this.lockSensorStateClampXMinusSwitch, gridBagConstraints);
        GroupLayout filterPositionInClampXMinusSwitchLayout = new GroupLayout(this.filterPositionInClampXMinusSwitch);
        this.filterPositionInClampXMinusSwitch.setLayout(filterPositionInClampXMinusSwitchLayout);
        filterPositionInClampXMinusSwitchLayout.setHorizontalGroup(filterPositionInClampXMinusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        filterPositionInClampXMinusSwitchLayout.setVerticalGroup(filterPositionInClampXMinusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 17;
        this.add((Component)this.filterPositionInClampXMinusSwitch, gridBagConstraints);
        GroupLayout filterPositionInClampXPlusSwitchLayout = new GroupLayout(this.filterPositionInClampXPlusSwitch);
        this.filterPositionInClampXPlusSwitch.setLayout(filterPositionInClampXPlusSwitchLayout);
        filterPositionInClampXPlusSwitchLayout.setHorizontalGroup(filterPositionInClampXPlusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        filterPositionInClampXPlusSwitchLayout.setVerticalGroup(filterPositionInClampXPlusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 17;
        this.add((Component)this.filterPositionInClampXPlusSwitch, gridBagConstraints);
        GroupLayout lockSensorStateClampXPlusSwitchLayout = new GroupLayout(this.lockSensorStateClampXPlusSwitch);
        this.lockSensorStateClampXPlusSwitch.setLayout(lockSensorStateClampXPlusSwitchLayout);
        lockSensorStateClampXPlusSwitchLayout.setHorizontalGroup(lockSensorStateClampXPlusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        lockSensorStateClampXPlusSwitchLayout.setVerticalGroup(lockSensorStateClampXPlusSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 17;
        this.add((Component)this.lockSensorStateClampXPlusSwitch, gridBagConstraints);
        this.jLabel42.setFont(new Font("Tahoma", 0, 14));
        this.jLabel42.setText("<html><P align=\"center\">Filter<br>Engaged</p></html>");
        this.jLabel42.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(0, 3, 0, 6);
        this.add((Component)this.jLabel42, gridBagConstraints);
        this.filterPositionInClampXPlusLabel.setFont(new Font("Tahoma", 0, 14));
        this.filterPositionInClampXPlusLabel.setText("<html><P align=\"center\">Filter</p></html>");
        this.filterPositionInClampXPlusLabel.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 19;
        this.add((Component)this.filterPositionInClampXPlusLabel, gridBagConstraints);
        this.lockSensorStateClampXMinusLabel.setFont(new Font("Tahoma", 0, 14));
        this.lockSensorStateClampXMinusLabel.setText("<html><P align=\"center\">Lock</p></html>");
        this.lockSensorStateClampXMinusLabel.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 19;
        this.add((Component)this.lockSensorStateClampXMinusLabel, gridBagConstraints);
        this.filterPositionInClampXMinusLabel.setFont(new Font("Tahoma", 0, 14));
        this.filterPositionInClampXMinusLabel.setText("<html><P align=\"center\">Filter</p></html>");
        this.filterPositionInClampXMinusLabel.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 19;
        this.add((Component)this.filterPositionInClampXMinusLabel, gridBagConstraints);
        GroupLayout latchActuatorCurrentMeterXminusLayout = new GroupLayout(this.latchActuatorCurrentMeterXminus);
        this.latchActuatorCurrentMeterXminus.setLayout(latchActuatorCurrentMeterXminusLayout);
        latchActuatorCurrentMeterXminusLayout.setHorizontalGroup(latchActuatorCurrentMeterXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 160, Short.MAX_VALUE));
        latchActuatorCurrentMeterXminusLayout.setVerticalGroup(latchActuatorCurrentMeterXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 95, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        this.add((Component)this.latchActuatorCurrentMeterXminus, gridBagConstraints);
        GroupLayout latchActuatorCurrentMeterXplusLayout = new GroupLayout(this.latchActuatorCurrentMeterXplus);
        this.latchActuatorCurrentMeterXplus.setLayout(latchActuatorCurrentMeterXplusLayout);
        latchActuatorCurrentMeterXplusLayout.setHorizontalGroup(latchActuatorCurrentMeterXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 160, Short.MAX_VALUE));
        latchActuatorCurrentMeterXplusLayout.setVerticalGroup(latchActuatorCurrentMeterXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 95, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        this.add((Component)this.latchActuatorCurrentMeterXplus, gridBagConstraints);
        GroupLayout clampActuatorCurrentMeterXminusLayout = new GroupLayout(this.clampActuatorCurrentMeterXminus);
        this.clampActuatorCurrentMeterXminus.setLayout(clampActuatorCurrentMeterXminusLayout);
        clampActuatorCurrentMeterXminusLayout.setHorizontalGroup(clampActuatorCurrentMeterXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 160, Short.MAX_VALUE));
        clampActuatorCurrentMeterXminusLayout.setVerticalGroup(clampActuatorCurrentMeterXminusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 95, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.clampActuatorCurrentMeterXminus, gridBagConstraints);
        GroupLayout clampActuatorCurrentMeterXplusLayout = new GroupLayout(this.clampActuatorCurrentMeterXplus);
        this.clampActuatorCurrentMeterXplus.setLayout(clampActuatorCurrentMeterXplusLayout);
        clampActuatorCurrentMeterXplusLayout.setHorizontalGroup(clampActuatorCurrentMeterXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 160, Short.MAX_VALUE));
        clampActuatorCurrentMeterXplusLayout.setVerticalGroup(clampActuatorCurrentMeterXplusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 95, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.clampActuatorCurrentMeterXplus, gridBagConstraints);
        this.jLabel38.setFont(new Font("Tahoma", 0, 14));
        this.jLabel38.setText("<html><P align=\"center\">Latch control<br>value</p></html>");
        this.jLabel38.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.jLabel38, gridBagConstraints);
        this.jLabel39.setFont(new Font("Tahoma", 0, 14));
        this.jLabel39.setText("<html><P align=\"center\">Unclamping<br>Current</p></html>");
        this.jLabel39.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.jLabel39, gridBagConstraints);
        GroupLayout filterPositionInClampXMinusProgressLayout = new GroupLayout(this.filterPositionInClampXMinusProgress);
        this.filterPositionInClampXMinusProgress.setLayout(filterPositionInClampXMinusProgressLayout);
        filterPositionInClampXMinusProgressLayout.setHorizontalGroup(filterPositionInClampXMinusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 40, Short.MAX_VALUE));
        filterPositionInClampXMinusProgressLayout.setVerticalGroup(filterPositionInClampXMinusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.filterPositionInClampXMinusProgress, gridBagConstraints);
        GroupLayout filterPositionInClampXPlusProgressLayout = new GroupLayout(this.filterPositionInClampXPlusProgress);
        this.filterPositionInClampXPlusProgress.setLayout(filterPositionInClampXPlusProgressLayout);
        filterPositionInClampXPlusProgressLayout.setHorizontalGroup(filterPositionInClampXPlusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 40, Short.MAX_VALUE));
        filterPositionInClampXPlusProgressLayout.setVerticalGroup(filterPositionInClampXPlusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.filterPositionInClampXPlusProgress, gridBagConstraints);
        GroupLayout lockSensorStateClampXMinusProgressLayout = new GroupLayout(this.lockSensorStateClampXMinusProgress);
        this.lockSensorStateClampXMinusProgress.setLayout(lockSensorStateClampXMinusProgressLayout);
        lockSensorStateClampXMinusProgressLayout.setHorizontalGroup(lockSensorStateClampXMinusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        lockSensorStateClampXMinusProgressLayout.setVerticalGroup(lockSensorStateClampXMinusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 50, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.lockSensorStateClampXMinusProgress, gridBagConstraints);
        GroupLayout lockSensorStateClampXPlusProgressLayout = new GroupLayout(this.lockSensorStateClampXPlusProgress);
        this.lockSensorStateClampXPlusProgress.setLayout(lockSensorStateClampXPlusProgressLayout);
        lockSensorStateClampXPlusProgressLayout.setHorizontalGroup(lockSensorStateClampXPlusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        lockSensorStateClampXPlusProgressLayout.setVerticalGroup(lockSensorStateClampXPlusProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 50, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.lockSensorStateClampXPlusProgress, gridBagConstraints);
        this.positionSensorXPlusState.setText("No Filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 18;
        this.add((Component)this.positionSensorXPlusState, gridBagConstraints);
        this.lockSensorXMinusState.setText("Locked");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.lockSensorXMinusState, gridBagConstraints);
        this.lockSensorXPlusState.setText("Unlocked");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.lockSensorXPlusState, gridBagConstraints);
        this.positionSensorXMinusState.setText("Unknown");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 18;
        this.add((Component)this.positionSensorXMinusState, gridBagConstraints);
        this.jLabel3.setText("hardwareType");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.railSensorStandByPositionXminus.setColor(Color.gray);
        this.railSensorHandOffPositionXminus.setColor(Color.gray);
        this.railSensorHandOffPositionXplus.setColor(Color.gray);
        this.railSensorStandByPositionXplus.setColor(Color.gray);
        this.lockSensorPositionLatchXminus.setColor(Color.gray);
        this.unlockSensorPositionLatchXminus.setColor(Color.gray);
        this.filterPresenceSensorLatchXminus.setColor(Color.gray);
        this.filterPresenceSensorLatchXplus.setColor(Color.gray);
        this.unlockSensorPositionLatchXplus.setColor(Color.gray);
        this.lockSensorPositionLatchXplus.setColor(Color.gray);
        this.filterPositionInClampXMinusProgress.setValueAndColor(0, Color.gray);
        this.filterPositionInClampXPlusProgress.setValueAndColor(0, Color.gray);
        this.lockSensorStateClampXMinusProgress.setValueAndColor(0, Color.gray);
        this.lockSensorStateClampXPlusProgress.setValueAndColor(0, Color.gray);
        this.filterPositionInClampXPlusSwitch.setColor(Color.gray);
        this.filterPositionInClampXMinusSwitch.setColor(Color.gray);
        this.lockSensorStateClampXPlusSwitch.setColor(Color.gray);
        this.lockSensorStateClampXMinusSwitch.setColor(Color.gray);
        this.movementPanel.setStatus(false, false);
        Color backgroundColor = this.getBackground();
        this.latchActuatorCurrentMeterXplus.setBackground(backgroundColor);
        this.latchActuatorCurrentMeterXminus.setBackground(backgroundColor);
        this.clampActuatorCurrentMeterXplus.setBackground(backgroundColor);
        this.clampActuatorCurrentMeterXminus.setBackground(backgroundColor);
    }

    @Override
    public String toString() {
        return "Filter Exchange Panel";
    }

    private class UpdateClamp
    implements Runnable {
        private final StatusDataPublishedByCarouselClamp s;

        UpdateClamp(StatusDataPublishedByCarouselClamp s) {
            this.s = s;
        }

        @Override
        public void run() {
            String clampName = this.s.getName();
            int filterPositionValue = this.s.getFilterPositionSensorValue();
            int lockSensorValue = this.s.getLockSensorValue();
            HorizontalProgressBar lockSensorProgressBar = clampName.toLowerCase().contains("xminus") ? SingleFilterTestExchangePanel.this.lockSensorStateClampXMinusProgress : SingleFilterTestExchangePanel.this.lockSensorStateClampXPlusProgress;
            VerticalProgressBar filterPositionProgressBar = clampName.toLowerCase().contains("xminus") ? SingleFilterTestExchangePanel.this.filterPositionInClampXMinusProgress : SingleFilterTestExchangePanel.this.filterPositionInClampXPlusProgress;
            DigitalSwitch lockSensorSwitch = clampName.toLowerCase().contains("xminus") ? SingleFilterTestExchangePanel.this.lockSensorStateClampXMinusSwitch : SingleFilterTestExchangePanel.this.lockSensorStateClampXPlusSwitch;
            DigitalSwitch filterPositionSwitch = clampName.toLowerCase().contains("xminus") ? SingleFilterTestExchangePanel.this.filterPositionInClampXMinusSwitch : SingleFilterTestExchangePanel.this.filterPositionInClampXPlusSwitch;
            JLabel lockSensorLabel = clampName.toLowerCase().contains("xminus") ? SingleFilterTestExchangePanel.this.lockSensorXMinusState : SingleFilterTestExchangePanel.this.lockSensorXPlusState;
            JLabel filterPositionSensorLabel = clampName.toLowerCase().contains("xminus") ? SingleFilterTestExchangePanel.this.positionSensorXMinusState : SingleFilterTestExchangePanel.this.positionSensorXPlusState;
            Color lockSensorColor = this.s.getLockStatus().getColor();
            lockSensorProgressBar.setValueAndColor(lockSensorValue, lockSensorColor);
            lockSensorSwitch.setColor(lockSensorColor);
            Color filterPositionColor = this.s.getFilterPresenceStatus().getColor();
            filterPositionProgressBar.setValueAndColor(filterPositionValue, filterPositionColor);
            filterPositionSwitch.setColor(filterPositionColor);
            lockSensorLabel.setText(this.s.getLockStatus().toString());
            lockSensorLabel.setForeground(lockSensorColor);
            filterPositionSensorLabel.setText(this.s.getFilterPresenceStatus().toString());
            filterPositionSensorLabel.setForeground(filterPositionColor);
        }
    }

    private class UpdateLatch
    implements Runnable {
        private final StatusDataPublishedByAutochangerLatch s;

        UpdateLatch(StatusDataPublishedByAutochangerLatch s) {
            this.s = s;
        }

        @Override
        public void run() {
            String latchName = this.s.getName();
            DigitalSwitch lockSensorSwitch = latchName.toLowerCase().contains("xminus") ? SingleFilterTestExchangePanel.this.lockSensorPositionLatchXminus : SingleFilterTestExchangePanel.this.lockSensorPositionLatchXplus;
            DigitalSwitch unlockSensorSwitch = latchName.toLowerCase().contains("xminus") ? SingleFilterTestExchangePanel.this.unlockSensorPositionLatchXminus : SingleFilterTestExchangePanel.this.unlockSensorPositionLatchXplus;
            DigitalSwitch filterPositionSensorSwitch = latchName.toLowerCase().contains("xminus") ? SingleFilterTestExchangePanel.this.filterPresenceSensorLatchXminus : SingleFilterTestExchangePanel.this.filterPresenceSensorLatchXplus;
            filterPositionSensorSwitch.setColor(this.s.getFilterPresenceSensorValue() ? FcsEnumerations.greenColor : Color.gray);
            lockSensorSwitch.updateColor(this.s.isInError(), this.s.getLockSensorValue());
            unlockSensorSwitch.updateColor(this.s.isInError(), this.s.getUnlockSensorValue());
        }
    }

    private class UpdateCarousel
    implements Runnable {
        private final StatusDataPublishedByCarousel s;

        UpdateCarousel(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            SingleFilterTestExchangePanel.this.filterInCarouselPanel.setIsFilterInHouse(!this.s.getFilterAtStandbyName().equals("NO FILTER"), this.s.getFilterAtStandbyName());
        }
    }

    private class UpdateAutoChanger
    implements Runnable {
        private StatusDataPublishedByBasicAutoChanger s;

        UpdateAutoChanger(StatusDataPublishedByBasicAutoChanger s) {
            this.s = s;
        }

        @Override
        public void run() {
            SingleFilterTestExchangePanel.this.filterInAutochangerPanel.setIsFilterInHouse(!this.s.isTrucksEmpty(), "dummyFilter");
            SingleFilterTestExchangePanel.this.railSensorHandOffPositionXminus.setColor(this.s.getRailSensorStandbackXminusValue() ? FcsEnumerations.greenColor : Color.gray);
            SingleFilterTestExchangePanel.this.railSensorHandOffPositionXplus.setColor(this.s.getRailSensorStandbackXplusValue() ? FcsEnumerations.greenColor : Color.gray);
            SingleFilterTestExchangePanel.this.railSensorStandByPositionXminus.setColor(this.s.getRailSensorStandbyXminusValue() ? FcsEnumerations.greenColor : Color.gray);
            SingleFilterTestExchangePanel.this.railSensorStandByPositionXplus.setColor(this.s.getRailSensorStandbyXplusValue() ? FcsEnumerations.greenColor : Color.gray);
            SingleFilterTestExchangePanel.this.movementPanel.setStatus(this.s.isMovingToStandback(), this.s.isMovingToStandby());
        }
    }

    private class UpdateActuator
    implements Runnable {
        private StatusDataPublishedByClampActuator s;

        UpdateActuator(StatusDataPublishedByClampActuator s) {
            this.s = s;
        }

        @Override
        public void run() {
            String actuatorName = this.s.getName();
            AnalogMeter meter = null;
            switch (actuatorName) {
                case "clampXplusController": {
                    meter = SingleFilterTestExchangePanel.this.clampActuatorCurrentMeterXplus;
                    break;
                }
                case "clampXminusController": {
                    meter = SingleFilterTestExchangePanel.this.clampActuatorCurrentMeterXminus;
                    break;
                }
                case "latchActuatorXplus": {
                    meter = SingleFilterTestExchangePanel.this.latchActuatorCurrentMeterXminus;
                    break;
                }
                case "latchActuatorXminus": {
                    meter = SingleFilterTestExchangePanel.this.latchActuatorCurrentMeterXplus;
                    break;
                }
                default: {
                    FCSCst.FCSLOG.error((Object)("Unexpected actuator name: " + actuatorName));
                }
            }
            if (meter != null) {
                meter.setValue(this.s.getSentValue());
            }
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            SingleFilterTestExchangePanel.this.jLabel3.setText(this.configInfo.getDescriptionName());
            Map xMinusClampConfig = this.configInfo.getCurrentValuesFor(SingleFilterTestExchangePanel.CLAMPXMINUS_NAME);
            Map xPlusClampConfig = this.configInfo.getCurrentValuesFor(SingleFilterTestExchangePanel.CLAMPXPLUS_NAME);
            SingleFilterTestExchangePanel.configureClampFilterPositionProgressBar(SingleFilterTestExchangePanel.this.filterPositionInClampXMinusProgress, xMinusClampConfig);
            SingleFilterTestExchangePanel.configureClampFilterPositionProgressBar(SingleFilterTestExchangePanel.this.filterPositionInClampXPlusProgress, xPlusClampConfig);
            SingleFilterTestExchangePanel.configureClampLockSensorProgressBar(SingleFilterTestExchangePanel.this.lockSensorStateClampXMinusProgress, xMinusClampConfig);
            SingleFilterTestExchangePanel.configureClampLockSensorProgressBar(SingleFilterTestExchangePanel.this.lockSensorStateClampXPlusProgress, xPlusClampConfig);
            Map clampXminusControllerConfig = this.configInfo.getCurrentValuesFor(SingleFilterTestExchangePanel.CLAMPXMINUS_CTL_NAME);
            SingleFilterTestExchangePanel.this.clampActuatorCurrentMeterXminus.setLimits(0, Tools.toInt(clampXminusControllerConfig, "sentCurrentMaxValue"));
            Map clampXplusControllerConfig = this.configInfo.getCurrentValuesFor(SingleFilterTestExchangePanel.CLAMPXPLUS_CTL_NAME);
            SingleFilterTestExchangePanel.this.clampActuatorCurrentMeterXplus.setLimits(0, Tools.toInt(clampXplusControllerConfig, "sentCurrentMaxValue"));
            Map latchXminusActuatorConfig = this.configInfo.getCurrentValuesFor(SingleFilterTestExchangePanel.LATCHXMINUS_CTL_NAME);
            SingleFilterTestExchangePanel.this.latchActuatorCurrentMeterXminus.setLimits(Tools.toInt(latchXminusActuatorConfig, "speedVoltageMinValue"), Tools.toInt(latchXminusActuatorConfig, "speedVoltageMaxValue"));
            Map latchXplusActuatorConfig = this.configInfo.getCurrentValuesFor(SingleFilterTestExchangePanel.LATCHXPLUS_CTL_NAME);
            SingleFilterTestExchangePanel.this.latchActuatorCurrentMeterXplus.setLimits(Tools.toInt(latchXplusActuatorConfig, "speedVoltageMinValue"), Tools.toInt(latchXplusActuatorConfig, "speedVoltageMaxValue"));
        }
    }
}

